/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class SelectCommand
extends Command {
    private final Collection<OsmPrimitive> newSelection;
    private Collection<OsmPrimitive> oldSelection;

    @Deprecated
    public SelectCommand(Collection<OsmPrimitive> newSelection) {
        this.newSelection = newSelection == null || newSelection.isEmpty() ? Collections.emptySet() : new HashSet<OsmPrimitive>(newSelection);
    }

    public SelectCommand(DataSet dataset, Collection<OsmPrimitive> newSelection) {
        super(dataset);
        this.newSelection = newSelection == null || newSelection.isEmpty() ? Collections.emptySet() : new HashSet<OsmPrimitive>(newSelection);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public void undoCommand() {
        this.ensurePrimitivesAreInDataset();
        this.getAffectedDataSet().setSelected(this.oldSelection);
    }

    @Override
    public boolean executeCommand() {
        this.ensurePrimitivesAreInDataset();
        this.oldSelection = this.getAffectedDataSet().getSelected();
        this.getAffectedDataSet().setSelected(this.newSelection);
        return true;
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return Collections.unmodifiableCollection(this.newSelection);
    }

    @Override
    public String getDescriptionText() {
        int size = this.newSelection != null ? this.newSelection.size() : 0;
        return I18n.trn("Selected {0} object", "Selected {0} objects", size, size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.newSelection, this.oldSelection);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SelectCommand that = (SelectCommand)obj;
        return Objects.equals(this.newSelection, that.newSelection) && Objects.equals(this.oldSelection, that.oldSelection);
    }
}

