/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateNode
extends Test {
    protected static final int DUPLICATE_NODE = 1;
    protected static final int DUPLICATE_NODE_MIXED = 2;
    protected static final int DUPLICATE_NODE_OTHER = 3;
    protected static final int DUPLICATE_NODE_BUILDING = 10;
    protected static final int DUPLICATE_NODE_BOUNDARY = 11;
    protected static final int DUPLICATE_NODE_HIGHWAY = 12;
    protected static final int DUPLICATE_NODE_LANDUSE = 13;
    protected static final int DUPLICATE_NODE_NATURAL = 14;
    protected static final int DUPLICATE_NODE_POWER = 15;
    protected static final int DUPLICATE_NODE_RAILWAY = 16;
    protected static final int DUPLICATE_NODE_WATERWAY = 17;
    private static final String[] TYPES = new String[]{"none", "highway", "railway", "waterway", "boundary", "power", "natural", "landuse", "building"};
    private Storage<Object> potentialDuplicates;

    public DuplicateNode() {
        super(I18n.tr("Duplicated nodes", new Object[0]), I18n.tr("This test checks that there are no nodes at the very same location.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.potentialDuplicates = new Storage<Object>(new NodeHash());
    }

    @Override
    public void endTest() {
        for (Object v : this.potentialDuplicates) {
            if (v instanceof Node) continue;
            List nodes = (List)v;
            HashSet<String> eles = new HashSet<String>();
            for (Node n : nodes) {
                String ele = n.get("ele");
                if (ele == null) continue;
                eles.add(ele);
            }
            if (eles.size() == nodes.size()) continue;
            this.errors.addAll(this.buildTestErrors(this, nodes));
        }
        super.endTest();
        this.potentialDuplicates = null;
    }

    public List<TestError> buildTestErrors(Test parentTest, List<Node> nodes) {
        ArrayList<TestError> errors = new ArrayList<TestError>();
        MultiMap<Map, Node> mm = new MultiMap<Map, Node>();
        for (Node n : nodes) {
            mm.put(n.getKeys(), n);
        }
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        Iterator it = mm.keySet().iterator();
        while (it.hasNext()) {
            Set primitives = mm.get((Map)it.next());
            if (primitives.size() <= 1) continue;
            for (String type : TYPES) {
                typeMap.put(type, Boolean.FALSE);
            }
            for (OsmPrimitive p : primitives) {
                if (p.getType() != OsmPrimitiveType.NODE) continue;
                Node n = (Node)p;
                List<OsmPrimitive> lp = n.getReferrers();
                for (OsmPrimitive sp : lp) {
                    if (sp.getType() != OsmPrimitiveType.WAY) continue;
                    boolean typed = false;
                    Way w = (Way)sp;
                    TagMap keys = w.getKeys();
                    for (String type : typeMap.keySet()) {
                        if (!keys.containsKey(type)) continue;
                        typeMap.put(type, Boolean.TRUE);
                        typed = true;
                    }
                    if (typed) continue;
                    typeMap.put("none", Boolean.TRUE);
                }
            }
            long nbType = typeMap.entrySet().stream().filter(Map.Entry::getValue).count();
            if (nbType > 1L) {
                errors.add(TestError.builder(parentTest, Severity.WARNING, 2).message(I18n.tr("Mixed type duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("highway")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 12).message(I18n.tr("Highway duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("railway")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 16).message(I18n.tr("Railway duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("waterway")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 17).message(I18n.tr("Waterway duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("boundary")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 11).message(I18n.tr("Boundary duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("power")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 15).message(I18n.tr("Power duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("natural")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 14).message(I18n.tr("Natural duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("building")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 10).message(I18n.tr("Building duplicated nodes", new Object[0])).primitives(primitives).build());
            } else if (((Boolean)typeMap.get("landuse")).booleanValue()) {
                errors.add(TestError.builder(parentTest, Severity.ERROR, 13).message(I18n.tr("Landuse duplicated nodes", new Object[0])).primitives(primitives).build());
            } else {
                errors.add(TestError.builder(parentTest, Severity.WARNING, 3).message(I18n.tr("Other duplicated nodes", new Object[0])).primitives(primitives).build());
            }
            it.remove();
        }
        if (!mm.isEmpty()) {
            ArrayList duplicates = new ArrayList();
            for (Set l : mm.values()) {
                duplicates.addAll(l);
            }
            if (duplicates.size() > 1) {
                errors.add(TestError.builder(parentTest, Severity.WARNING, 1).message(I18n.tr("Nodes at same position", new Object[0])).primitives(duplicates).build());
            }
        }
        return errors;
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            if (this.potentialDuplicates.get(n) == null) {
                this.potentialDuplicates.put(n);
            } else if (this.potentialDuplicates.get(n) instanceof Node) {
                Node n1 = (Node)this.potentialDuplicates.get(n);
                ArrayList<Node> nodes = new ArrayList<Node>(2);
                nodes.add(n1);
                nodes.add(n);
                this.potentialDuplicates.put(nodes);
            } else if (this.potentialDuplicates.get(n) instanceof List) {
                List nodes = (List)this.potentialDuplicates.get(n);
                nodes.add(n);
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>(testError.getPrimitives());
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(OsmPrimitive.getFilteredList(sel, Node.class));
        nodes.removeIf(AbstractPrimitive::isDeleted);
        if (nodes.size() >= 2) {
            Node target = null;
            for (Node n : nodes) {
                if (n.isNew()) continue;
                target = n;
                break;
            }
            if (target == null) {
                target = (Node)nodes.iterator().next();
            }
            if (Command.checkOutlyingOrIncompleteOperation(nodes, Collections.singleton(target)) == 0) {
                return MergeNodesAction.mergeNodes(nodes, target);
            }
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateNode)) {
            return false;
        }
        if (testError.getCode() == 1) {
            return false;
        }
        Iterator<? extends OsmPrimitive> it = testError.getPrimitives().iterator();
        return it.hasNext() && !it.next().isOutsideDownloadArea();
    }

    private static class NodeHash
    implements Hash<Object, Object> {
        private final double precision = Config.getPref().getDouble("validator.duplicatenodes.precision", 0.0);

        private NodeHash() {
        }

        private LatLon roundCoord(LatLon coor) {
            return new LatLon((double)Math.round(coor.lat() / this.precision) * this.precision, (double)Math.round(coor.lon() / this.precision) * this.precision);
        }

        private LatLon getLatLon(Object o) {
            if (o instanceof Node) {
                LatLon coor = ((Node)o).getCoor();
                if (coor == null) {
                    return null;
                }
                if (this.precision == 0.0) {
                    return coor.getRoundedToOsmPrecision();
                }
                return this.roundCoord(coor);
            }
            if (o instanceof List) {
                LatLon coor = ((Node)((List)o).get(0)).getCoor();
                if (coor == null) {
                    return null;
                }
                if (this.precision == 0.0) {
                    return coor.getRoundedToOsmPrecision();
                }
                return this.roundCoord(coor);
            }
            throw new AssertionError();
        }

        @Override
        public boolean equals(Object k, Object t) {
            LatLon coorT;
            LatLon coorK = this.getLatLon(k);
            return coorK == (coorT = this.getLatLon(t)) || coorK != null && coorT != null && coorK.equals(coorT);
        }

        @Override
        public int getHashCode(Object k) {
            LatLon coorK = this.getLatLon(k);
            return coorK == null ? 0 : coorK.hashCode();
        }
    }
}

