/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.RelationMemberTableColumnModel;

public class RelationMemberListViewer
extends HistoryViewerPanel {
    @Override
    protected JTable buildReferenceTable() {
        JTable table = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new RelationMemberTableColumnModel());
        table.setName("table.referencememberlisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.getModel().addTableModelListener(new MemberModelChanged(table));
        return table;
    }

    @Override
    protected JTable buildCurrentTable() {
        JTable table = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new RelationMemberTableColumnModel());
        table.setName("table.currentmemberlisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.getModel().addTableModelListener(new MemberModelChanged(table));
        return table;
    }

    public RelationMemberListViewer(HistoryBrowserModel model) {
        super(model);
    }

    protected static class MemberModelChanged
    implements TableModelListener {
        private final JTable table;

        protected MemberModelChanged(JTable table) {
            this.table = table;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            Rectangle rect = this.table.getCellRect(((DiffTableModel)e.getSource()).getFirstChange(), 0, true);
            this.table.scrollRectToVisible(rect);
        }
    }
}

