/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class CacheCustomContent<T extends Throwable> {
    public static final int INTERVAL_ALWAYS = -1;
    public static final int INTERVAL_HOURLY = (int)TimeUnit.HOURS.toSeconds(1L);
    public static final int INTERVAL_DAILY = (int)TimeUnit.DAYS.toSeconds(1L);
    public static final int INTERVAL_WEEKLY = (int)TimeUnit.DAYS.toSeconds(7L);
    public static final int INTERVAL_MONTHLY = (int)TimeUnit.DAYS.toSeconds(28L);
    public static final int INTERVAL_NEVER = Integer.MAX_VALUE;
    private byte[] data;
    private final String ident;
    private final File path;
    private final int updateInterval;

    protected abstract byte[] updateData() throws T;

    public CacheCustomContent(String ident, int updateInterval) {
        this.ident = ident;
        this.updateInterval = updateInterval;
        this.path = new File(Config.getDirs().getCacheDirectory(true), ident);
    }

    protected boolean isCacheValid() {
        return true;
    }

    private boolean needsUpdate() {
        if (this.isOffline()) {
            return false;
        }
        return (long)(Config.getPref().getInt("cache." + this.ident, 0) + this.updateInterval) < TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) || !this.isCacheValid();
    }

    private boolean isOffline() {
        try {
            this.checkOfflineAccess();
            return false;
        }
        catch (OfflineAccessException e) {
            Logging.trace(e);
            return true;
        }
    }

    protected abstract void checkOfflineAccess();

    public byte[] updateIfRequired() throws T {
        if (this.needsUpdate()) {
            return this.updateForce();
        }
        return this.getData();
    }

    public String updateIfRequiredString() throws T {
        if (this.needsUpdate()) {
            return this.updateForceString();
        }
        return this.getDataString();
    }

    private byte[] updateForce() throws T {
        this.data = this.updateData();
        this.saveToDisk();
        Config.getPref().putInt("cache." + this.ident, (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        return this.data;
    }

    public String updateForceString() throws T {
        this.updateForce();
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public byte[] getData() throws T {
        if (this.data == null) {
            this.loadFromDisk();
        }
        return Utils.copyArray(this.data);
    }

    public String getDataString() throws T {
        byte[] array = this.getData();
        if (array == null) {
            return null;
        }
        return new String(array, StandardCharsets.UTF_8);
    }

    private void loadFromDisk() throws T {
        block8: {
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.path));){
                this.data = new byte[input.available()];
                if (input.read(this.data) < this.data.length) {
                    Logging.error("Failed to read expected contents from " + this.path);
                }
            }
            catch (IOException e) {
                Logging.trace(e);
                if (this.isOffline()) break block8;
                this.data = this.updateForce();
            }
        }
    }

    private void saveToDisk() {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.path));){
            output.write(this.data);
            output.flush();
        }
        catch (IOException e) {
            Logging.error(e);
        }
    }

    public void flushData() {
        this.data = null;
    }
}

