/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class HiDPISupport {
    private static volatile Optional<Class<? extends Image>> baseMultiResolutionImageClass;
    private static volatile Optional<Constructor<? extends Image>> baseMultiResolutionImageConstructor;
    private static volatile Optional<Method> resolutionVariantsMethod;

    private HiDPISupport() {
    }

    public static Image getMultiResolutionImage(Image base, ImageResource ir) {
        ImageIcon zoomed;
        Image mrImg;
        double uiScale = HiDPISupport.getHiDPIScale();
        if (uiScale != 1.0 && HiDPISupport.getBaseMultiResolutionImageConstructor().isPresent() && (mrImg = HiDPISupport.getMultiResolutionImage(Arrays.asList(base, (zoomed = ir.getImageIcon(new Dimension((int)Math.round((double)base.getWidth(null) * uiScale), (int)Math.round((double)base.getHeight(null) * uiScale)), false)).getImage()))) != null) {
            return mrImg;
        }
        return base;
    }

    public static Image getMultiResolutionImage(List<Image> imgs) {
        CheckParameterUtil.ensure(imgs, "imgs", "not empty", ls -> !ls.isEmpty());
        Optional<Constructor<? extends Image>> baseMrImageConstructor = HiDPISupport.getBaseMultiResolutionImageConstructor();
        if (baseMrImageConstructor.isPresent()) {
            try {
                return baseMrImageConstructor.get().newInstance(new Object[]{imgs.toArray(new Image[0])});
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                Logging.error("Unexpected error while instantiating object of class BaseMultiResolutionImage: " + ex);
            }
        }
        return imgs.get(0);
    }

    public static Image getBaseImage(Image img) {
        Optional<Class<? extends Image>> baseMrImageClass = HiDPISupport.getBaseMultiResolutionImageClass();
        Optional<Method> resVariantsMethod = HiDPISupport.getResolutionVariantsMethod();
        if (!baseMrImageClass.isPresent() || !resVariantsMethod.isPresent()) {
            return img;
        }
        if (baseMrImageClass.get().isInstance(img)) {
            try {
                List imgVars = (List)resVariantsMethod.get().invoke((Object)img, new Object[0]);
                if (!imgVars.isEmpty()) {
                    return (Image)imgVars.get(0);
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Logging.error("Unexpected error while calling method: " + ex);
            }
        }
        return img;
    }

    public static List<Image> getResolutionVariants(Image img) {
        Optional<Class<? extends Image>> baseMrImageClass = HiDPISupport.getBaseMultiResolutionImageClass();
        Optional<Method> resVariantsMethod = HiDPISupport.getResolutionVariantsMethod();
        if (!baseMrImageClass.isPresent() || !resVariantsMethod.isPresent()) {
            return Collections.singletonList(img);
        }
        if (baseMrImageClass.get().isInstance(img)) {
            try {
                List imgVars = (List)resVariantsMethod.get().invoke((Object)img, new Object[0]);
                if (!imgVars.isEmpty()) {
                    return imgVars;
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Logging.error("Unexpected error while calling method: " + ex);
            }
        }
        return Collections.singletonList(img);
    }

    private static double getHiDPIScale() {
        if (GraphicsEnvironment.isHeadless()) {
            return 1.0;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform transform = gc.getDefaultTransform();
        if (!Utils.equalsEpsilon(transform.getScaleX(), transform.getScaleY())) {
            Logging.warn("Unexpected ui transform: " + transform);
        }
        return transform.getScaleX();
    }

    public static Image processMRImage(Image img, Function<Image, Image> processor) {
        return HiDPISupport.processMRImages(Collections.singletonList(img), imgs -> (Image)processor.apply((Image)imgs.get(0)));
    }

    public static Image processMRImages(List<Image> imgs, Function<List<Image>, Image> processor) {
        CheckParameterUtil.ensureThat(imgs.size() >= 1, "at least on element expected");
        if (!HiDPISupport.getBaseMultiResolutionImageClass().isPresent()) {
            return processor.apply(imgs);
        }
        List allVars = imgs.stream().map(HiDPISupport::getResolutionVariants).collect(Collectors.toList());
        int maxVariants = allVars.stream().mapToInt(lst -> lst.size()).max().getAsInt();
        if (maxVariants == 1) {
            return processor.apply(imgs);
        }
        List<Image> imgsProcessed = IntStream.range(0, maxVariants).mapToObj(k -> (Image)processor.apply(allVars.stream().map(vars -> (Image)vars.get(k)).collect(Collectors.toList()))).collect(Collectors.toList());
        return HiDPISupport.getMultiResolutionImage(imgsProcessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<Class<? extends Image>> getBaseMultiResolutionImageClass() {
        if (baseMultiResolutionImageClass != null) return baseMultiResolutionImageClass;
        Class<HiDPISupport> clazz = HiDPISupport.class;
        synchronized (HiDPISupport.class) {
            if (baseMultiResolutionImageClass != null) return baseMultiResolutionImageClass;
            try {
                Class<?> c = Class.forName("java.awt.image.BaseMultiResolutionImage");
                baseMultiResolutionImageClass = Optional.ofNullable(c);
            }
            catch (ClassNotFoundException ex) {
                baseMultiResolutionImageClass = Optional.empty();
                Logging.trace(ex);
            }
            return baseMultiResolutionImageClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<Constructor<? extends Image>> getBaseMultiResolutionImageConstructor() {
        if (baseMultiResolutionImageConstructor != null) return baseMultiResolutionImageConstructor;
        Class<HiDPISupport> clazz = HiDPISupport.class;
        synchronized (HiDPISupport.class) {
            if (baseMultiResolutionImageConstructor != null) return baseMultiResolutionImageConstructor;
            HiDPISupport.getBaseMultiResolutionImageClass().ifPresent(klass -> {
                try {
                    Constructor constr = klass.getConstructor(Image[].class);
                    baseMultiResolutionImageConstructor = Optional.ofNullable(constr);
                }
                catch (NoSuchMethodException ex) {
                    Logging.error("Cannot find expected constructor: " + ex);
                }
            });
            if (baseMultiResolutionImageConstructor != null) return baseMultiResolutionImageConstructor;
            baseMultiResolutionImageConstructor = Optional.empty();
            // ** MonitorExit[var0] (shouldn't be in output)
            return baseMultiResolutionImageConstructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<Method> getResolutionVariantsMethod() {
        if (resolutionVariantsMethod != null) return resolutionVariantsMethod;
        Class<HiDPISupport> clazz = HiDPISupport.class;
        synchronized (HiDPISupport.class) {
            if (resolutionVariantsMethod != null) return resolutionVariantsMethod;
            HiDPISupport.getBaseMultiResolutionImageClass().ifPresent(klass -> {
                try {
                    Method m = klass.getMethod("getResolutionVariants", new Class[0]);
                    resolutionVariantsMethod = Optional.ofNullable(m);
                }
                catch (NoSuchMethodException ex) {
                    Logging.error("Cannot find expected method: " + ex);
                }
            });
            if (resolutionVariantsMethod != null) return resolutionVariantsMethod;
            resolutionVariantsMethod = Optional.empty();
            // ** MonitorExit[var0] (shouldn't be in output)
            return resolutionVariantsMethod;
        }
    }
}

