/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Objects;
import org.languagetool.rules.patterns.PatternToken;

public class PatternTokenBuilder {
    private String token;
    private String posTag;
    private boolean matchInflectedForms = false;
    private boolean caseSensitive;
    private boolean regexp;
    private boolean negation;

    public PatternTokenBuilder token(String token) {
        this.token = Objects.requireNonNull(token);
        return this;
    }

    public PatternTokenBuilder csToken(String token) {
        this.token = Objects.requireNonNull(token);
        this.caseSensitive = true;
        return this;
    }

    public PatternTokenBuilder tokenRegex(String token) {
        this.token = Objects.requireNonNull(token);
        this.regexp = true;
        return this;
    }

    public PatternTokenBuilder pos(String posTag) {
        return this.pos(posTag, false);
    }

    public PatternTokenBuilder posRegex(String posTag) {
        return this.pos(posTag, true);
    }

    private PatternTokenBuilder pos(String posTag, boolean regexp) {
        this.posTag = Objects.requireNonNull(posTag);
        this.regexp = regexp;
        return this;
    }

    public PatternTokenBuilder negate() {
        this.negation = true;
        return this;
    }

    public PatternTokenBuilder matchInflectedForms() {
        this.matchInflectedForms = true;
        return this;
    }

    public PatternToken build() {
        if (this.posTag != null) {
            PatternToken patternToken = new PatternToken(null, false, false, false);
            patternToken.setPosToken(new PatternToken.PosToken(this.posTag, this.regexp, false));
            patternToken.setNegation(this.negation);
            return patternToken;
        }
        return new PatternToken(this.token, this.caseSensitive, this.regexp, this.matchInflectedForms);
    }
}

