/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.XComponentContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openoffice.da.comp.w2lcommon.filter.ConfigurationDialogBase;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.FieldMasterNameProvider;
import org.openoffice.da.comp.w2lcommon.helper.StyleNameProvider;
import org.openoffice.da.comp.writer2latex.CustomSymbolNameProvider;
import writer2latex.api.ComplexOption;
import writer2latex.util.Misc;

public final class ConfigurationDialog
extends ConfigurationDialogBase
implements XServiceInfo {
    public static String __serviceName = "org.openoffice.da.writer2latex.ConfigurationDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2latex.ConfigurationDialog";

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] sSupportedServiceNames = new String[]{__serviceName};
        return sSupportedServiceNames;
    }

    @Override
    protected String getMIMEType() {
        return "application/x-latex";
    }

    @Override
    protected String getDialogLibraryName() {
        return "W2LDialogs2";
    }

    @Override
    protected String getConfigFileName() {
        return "writer2latex.xml";
    }

    public ConfigurationDialog(XComponentContext xContext) {
        super(xContext);
        this.pageHandlers.put("Documentclass", new DocumentclassHandler());
        this.pageHandlers.put("Headings", new HeadingsHandler());
        this.pageHandlers.put("Styles", new StylesHandler());
        this.pageHandlers.put("Characters", new CharactersHandler());
        this.pageHandlers.put("Fonts", new FontsHandler());
        this.pageHandlers.put("Pages", new PagesHandler());
        this.pageHandlers.put("Tables", new TablesHandler());
        this.pageHandlers.put("Figures", new FiguresHandler());
        this.pageHandlers.put("TextAndMath", new TextAndMathHandler());
    }

    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"NoPreambleChange", "MaxLevelChange", "WriterLevelChange", "NoIndexChange", "StyleFamilyChange", "StyleNameChange", "NewStyleClick", "DeleteStyleClick", "AddNextClick", "RemoveNextClick", "LoadDefaultsClick", "UseSoulChange", "FormattingAttributeChange", "CustomAttributeChange", "ExportGeometryChange", "ExportHeaderAndFooterChange", "NoTablesChange", "UseSupertabularChange", "UseLongtableChange", "NoImagesChange", "MathSymbolNameChange", "NewSymbolClick", "DeleteSymbolClick", "TextInputChange", "NewTextClick", "DeleteTextClick"};
        return sNames;
    }

    private class TextAndMathHandler
    extends ConfigurationDialogBase.UserListPageHandler {
        private CustomSymbolNameProvider customSymbolNameProvider = null;
        private ComplexOption mathSymbols;
        private ComplexOption stringReplace;
        private String sCurrentMathSymbol = null;
        private String sCurrentText = null;

        protected TextAndMathHandler() {
            this.customSymbolNameProvider = new CustomSymbolNameProvider(ConfigurationDialog.this.xContext);
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            if (this.mathSymbols != null) {
                this.mathSymbols.clear();
            } else {
                this.mathSymbols = new ComplexOption();
            }
            this.mathSymbols.copyAll(ConfigurationDialog.this.config.getComplexOption("math-symbol-map"));
            this.sCurrentMathSymbol = null;
            dlg.setListBoxStringItemList("MathSymbolName", Misc.sortStringSet(this.mathSymbols.keySet()));
            dlg.setListBoxSelectedItem("MathSymbolName", (short)Math.min(0, this.mathSymbols.keySet().size() - 1));
            this.mathSymbolNameChange(dlg);
            if (this.stringReplace != null) {
                this.stringReplace.clear();
            } else {
                this.stringReplace = new ComplexOption();
            }
            this.stringReplace.copyAll(ConfigurationDialog.this.config.getComplexOption("string-replace"));
            this.sCurrentText = null;
            dlg.setListBoxStringItemList("TextInput", Misc.sortStringSet(this.stringReplace.keySet()));
            dlg.setListBoxSelectedItem("TextInput", (short)Math.min(0, this.stringReplace.keySet().size() - 1));
            this.textInputChange(dlg);
            this.checkBoxFromConfig(dlg, "UseOoomath", "use_ooomath");
            this.textFieldFromConfig(dlg, "TabStopLaTeX", "tabstop");
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.updateSymbol(dlg);
            ConfigurationDialog.this.config.getComplexOption("math-symbol-map").clear();
            ConfigurationDialog.this.config.getComplexOption("math-symbol-map").copyAll(this.mathSymbols);
            this.updateText(dlg);
            ConfigurationDialog.this.config.getComplexOption("string-replace").clear();
            ConfigurationDialog.this.config.getComplexOption("string-replace").copyAll(this.stringReplace);
            this.checkBoxToConfig(dlg, "UseOoomath", "use_ooomath");
            this.textFieldToConfig(dlg, "TabStopLaTeX", "tabstop");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("MathSymbolNameChange")) {
                this.mathSymbolNameChange(dlg);
                return true;
            }
            if (sMethod.equals("NewSymbolClick")) {
                this.newSymbolClick(dlg);
                return true;
            }
            if (sMethod.equals("DeleteSymbolClick")) {
                this.deleteSymbolClick(dlg);
                return true;
            }
            if (sMethod.equals("TextInputChange")) {
                this.textInputChange(dlg);
                return true;
            }
            if (sMethod.equals("NewTextClick")) {
                this.newTextClick(dlg);
                return true;
            }
            if (sMethod.equals("DeleteTextClick")) {
                this.deleteTextClick(dlg);
                return true;
            }
            return false;
        }

        private void mathSymbolNameChange(DialogAccess dlg) {
            this.updateSymbol(dlg);
            this.updateSymbolControls(dlg);
        }

        private void newSymbolClick(DialogAccess dlg) {
            this.appendItem(dlg, "MathSymbolName", this.customSymbolNameProvider.getNames());
            this.mathSymbolNameChange(dlg);
        }

        private void deleteSymbolClick(DialogAccess dlg) {
            String sMathSymbol = this.sCurrentMathSymbol;
            if (this.deleteCurrentItem(dlg, "MathSymbolName")) {
                this.mathSymbols.remove(sMathSymbol);
                this.sCurrentMathSymbol = null;
            }
            this.mathSymbolNameChange(dlg);
        }

        private void updateSymbol(DialogAccess dlg) {
            if (this.sCurrentMathSymbol != null) {
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("latex", dlg.getTextFieldText("MathLaTeX"));
                this.mathSymbols.put(this.sCurrentMathSymbol, attr);
            }
        }

        private void updateSymbolControls(DialogAccess dlg) {
            short nSymbolItem = dlg.getListBoxSelectedItem("MathSymbolName");
            if (nSymbolItem >= 0) {
                Map<Object, Object> attributes;
                this.sCurrentMathSymbol = dlg.getListBoxStringItemList("MathSymbolName")[nSymbolItem];
                if (this.mathSymbols.containsKey(this.sCurrentMathSymbol)) {
                    attributes = this.mathSymbols.get(this.sCurrentMathSymbol);
                } else {
                    attributes = new HashMap<String, String>();
                    attributes.put("latex", "");
                    this.mathSymbols.put(this.sCurrentMathSymbol, attributes);
                }
                dlg.setTextFieldText("MathLaTeX", (String)attributes.get("latex"));
                dlg.setControlEnabled("MathLaTeX", true);
                dlg.setControlEnabled("DeleteSymbolButton", true);
            } else {
                this.sCurrentMathSymbol = null;
                dlg.setTextFieldText("MathLaTeX", "");
                dlg.setControlEnabled("MathLaTeX", false);
                dlg.setControlEnabled("DeleteSymbolButton", false);
            }
        }

        private void textInputChange(DialogAccess dlg) {
            this.updateText(dlg);
            this.updateTextControls(dlg);
        }

        private void newTextClick(DialogAccess dlg) {
            this.appendItem(dlg, "TextInput", new HashSet<String>());
            this.textInputChange(dlg);
        }

        private void deleteTextClick(DialogAccess dlg) {
            String sText = this.sCurrentText;
            if (this.deleteCurrentItem(dlg, "TextInput")) {
                this.stringReplace.remove(sText);
                this.sCurrentText = null;
            }
            this.textInputChange(dlg);
        }

        private void updateText(DialogAccess dlg) {
            if (this.sCurrentText != null) {
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("latex-code", dlg.getTextFieldText("LaTeX"));
                attr.put("fontenc", "any");
                this.stringReplace.put(this.sCurrentText, attr);
            }
        }

        private void updateTextControls(DialogAccess dlg) {
            short nItem = dlg.getListBoxSelectedItem("TextInput");
            if (nItem >= 0) {
                Map<Object, Object> attributes;
                this.sCurrentText = dlg.getListBoxStringItemList("TextInput")[nItem];
                if (this.stringReplace.containsKey(this.sCurrentText)) {
                    attributes = this.stringReplace.get(this.sCurrentText);
                } else {
                    attributes = new HashMap<String, String>();
                    attributes.put("latex-code", "");
                    attributes.put("fontenc", "any");
                    this.stringReplace.put(this.sCurrentText, attributes);
                }
                dlg.setTextFieldText("LaTeX", (String)attributes.get("latex-code"));
                dlg.setControlEnabled("LaTeX", true);
                dlg.setControlEnabled("DeleteTextButton", !"\u00a0!".equals(this.sCurrentText) && !"\u00a0?".equals(this.sCurrentText) && !"\u00a0:".equals(this.sCurrentText) && !"\u00a0;".equals(this.sCurrentText) && !"\u00a0\u2014".equals(this.sCurrentText));
            } else {
                this.sCurrentText = null;
                dlg.setTextFieldText("LaTeX", "");
                dlg.setControlEnabled("DeleteTextButton", false);
            }
        }
    }

    private class FiguresHandler
    extends ConfigurationDialogBase.PageHandler {
        private FiguresHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            FieldMasterNameProvider fieldMasterNameProvider = new FieldMasterNameProvider(ConfigurationDialog.this.xContext);
            dlg.setListBoxStringItemList("FigureSequenceName", Misc.sortStringSet(fieldMasterNameProvider.getFieldMasterNames("com.sun.star.text.fieldmaster.SetExpression.")));
            this.checkBoxFromConfig(dlg, "UseCaption", "use_caption");
            this.checkBoxFromConfig(dlg, "AlignFrames", "align_frames");
            this.textFieldFromConfig(dlg, "FigureSequenceName", "figure_sequence_name");
            dlg.setCheckBoxStateAsBoolean("NoImages", !"accept".equals(ConfigurationDialog.this.config.getOption("image_content")));
            this.checkBoxFromConfig(dlg, "RemoveGraphicsExtension", "remove_graphics_extension");
            this.textFieldFromConfig(dlg, "ImageOptions", "image_options");
            this.noImagesChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.checkBoxToConfig(dlg, "UseCaption", "use_caption");
            this.checkBoxToConfig(dlg, "AlignFrames", "align_frames");
            this.textFieldToConfig(dlg, "FigureSequenceName", "figure_sequence_name");
            ConfigurationDialog.this.config.setOption("image_content", dlg.getCheckBoxStateAsBoolean("NoImages") ? "ignore" : "accept");
            this.checkBoxToConfig(dlg, "RemoveGraphicsExtension", "remove_graphics_extension");
            this.textFieldToConfig(dlg, "ImageOptions", "image_options");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("NoImagesChange")) {
                this.noImagesChange(dlg);
                return true;
            }
            return false;
        }

        private void noImagesChange(DialogAccess dlg) {
            boolean bNoImages = dlg.getCheckBoxStateAsBoolean("NoImages");
            dlg.setControlEnabled("RemoveGraphicsExtension", !bNoImages);
            dlg.setControlEnabled("ImageOptionsLabel", !bNoImages);
            dlg.setControlEnabled("ImageOptions", !bNoImages);
        }
    }

    private class TablesHandler
    extends ConfigurationDialogBase.PageHandler {
        protected TablesHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            StyleNameProvider styleNameProvider = new StyleNameProvider(ConfigurationDialog.this.xContext);
            Map<String, String> internalNames = styleNameProvider.getInternalNames("ParagraphStyles");
            if (internalNames != null) {
                String[] styleNames = Misc.sortStringSet(internalNames.keySet());
                dlg.setListBoxStringItemList("TableFirstHeadStyle", styleNames);
                dlg.setListBoxStringItemList("TableHeadStyle", styleNames);
                dlg.setListBoxStringItemList("TableFootStyle", styleNames);
                dlg.setListBoxStringItemList("TableLastFootStyle", styleNames);
            }
            FieldMasterNameProvider fieldMasterNameProvider = new FieldMasterNameProvider(ConfigurationDialog.this.xContext);
            dlg.setListBoxStringItemList("TableSequenceName", Misc.sortStringSet(fieldMasterNameProvider.getFieldMasterNames("com.sun.star.text.fieldmaster.SetExpression.")));
            dlg.setCheckBoxStateAsBoolean("NoTables", !"accept".equals(ConfigurationDialog.this.config.getOption("table_content")));
            this.checkBoxFromConfig(dlg, "UseColortbl", "use_colortbl");
            this.checkBoxFromConfig(dlg, "UseTabulary", "use_tabulary");
            this.checkBoxFromConfig(dlg, "UseSupertabular", "use_supertabular");
            this.checkBoxFromConfig(dlg, "UseLongtable", "use_longtable");
            this.textFieldFromConfig(dlg, "TableFirstHeadStyle", "table_first_head_style");
            this.textFieldFromConfig(dlg, "TableHeadStyle", "table_head_style");
            this.textFieldFromConfig(dlg, "TableFootStyle", "table_foot_style");
            this.textFieldFromConfig(dlg, "TableLastFootStyle", "table_last_foot_style");
            this.textFieldFromConfig(dlg, "TableSequenceName", "table_sequence_name");
            this.checkBoxChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            ConfigurationDialog.this.config.setOption("table_content", dlg.getCheckBoxStateAsBoolean("NoTables") ? "ignore" : "accept");
            this.checkBoxToConfig(dlg, "UseColortbl", "use_colortbl");
            this.checkBoxToConfig(dlg, "UseTabulary", "use_tabulary");
            this.checkBoxToConfig(dlg, "UseSupertabular", "use_supertabular");
            this.checkBoxToConfig(dlg, "UseLongtable", "use_longtable");
            this.textFieldToConfig(dlg, "TableFirstHeadStyle", "table_first_head_style");
            this.textFieldToConfig(dlg, "TableHeadStyle", "table_head_style");
            this.textFieldToConfig(dlg, "TableFootStyle", "table_foot_style");
            this.textFieldToConfig(dlg, "TableLastFootStyle", "table_last_foot_style");
            this.textFieldToConfig(dlg, "TableSequenceName", "table_sequence_name");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("NoTablesChange")) {
                this.checkBoxChange(dlg);
                return true;
            }
            if (sMethod.equals("UseSupertabularChange")) {
                this.checkBoxChange(dlg);
                return true;
            }
            if (sMethod.equals("UseLongtableChange")) {
                this.checkBoxChange(dlg);
                return true;
            }
            return false;
        }

        private void checkBoxChange(DialogAccess dlg) {
            boolean bNoTables = dlg.getCheckBoxStateAsBoolean("NoTables");
            boolean bSupertabular = dlg.getCheckBoxStateAsBoolean("UseSupertabular");
            boolean bLongtable = dlg.getCheckBoxStateAsBoolean("UseLongtable");
            dlg.setControlEnabled("UseColortbl", !bNoTables);
            dlg.setControlEnabled("UseTabulary", !bNoTables);
            dlg.setControlEnabled("UseMultirow", false);
            dlg.setControlEnabled("UseSupertabular", !bNoTables);
            dlg.setControlEnabled("UseLongtable", !bNoTables && !bSupertabular);
            dlg.setControlEnabled("TableFirstHeadLabel", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableFirstHeadStyle", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableHeadLabel", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableHeadStyle", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableFootLabel", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableFootStyle", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableLastFootLabel", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableLastFootStyle", !bNoTables && (bSupertabular || bLongtable));
            dlg.setControlEnabled("TableSequenceLabel", !bNoTables);
            dlg.setControlEnabled("TableSequenceName", !bNoTables);
        }
    }

    private class PagesHandler
    extends ConfigurationDialogBase.PageHandler {
        private PagesHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            String sPageFormatting = ConfigurationDialog.this.config.getOption("page_formatting");
            if ("ignore_all".equals(sPageFormatting)) {
                dlg.setCheckBoxStateAsBoolean("ExportGeometry", false);
                dlg.setCheckBoxStateAsBoolean("ExportHeaderFooter", false);
            } else if ("convert_geometry".equals(sPageFormatting)) {
                dlg.setCheckBoxStateAsBoolean("ExportGeometry", true);
                dlg.setCheckBoxStateAsBoolean("ExportHeaderFooter", false);
            } else if ("convert_header_footer".equals(sPageFormatting)) {
                dlg.setCheckBoxStateAsBoolean("ExportGeometry", false);
                dlg.setCheckBoxStateAsBoolean("ExportHeaderFooter", true);
            } else if ("convert_all".equals(sPageFormatting)) {
                dlg.setCheckBoxStateAsBoolean("ExportGeometry", true);
                dlg.setCheckBoxStateAsBoolean("ExportHeaderFooter", true);
            }
            this.checkBoxFromConfig(dlg, "UseGeometry", "use_geometry");
            this.checkBoxFromConfig(dlg, "UseFancyhdr", "use_fancyhdr");
            this.checkBoxFromConfig(dlg, "UseLastpage", "use_lastpage");
            this.checkBoxFromConfig(dlg, "UseEndnotes", "use_endnotes");
            this.exportGeometryChange(dlg);
            this.exportHeaderAndFooterChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            boolean bGeometry = dlg.getCheckBoxStateAsBoolean("ExportGeometry");
            boolean bHeaderFooter = dlg.getCheckBoxStateAsBoolean("ExportHeaderFooter");
            if (bGeometry && bHeaderFooter) {
                ConfigurationDialog.this.config.setOption("page_formatting", "convert_all");
            } else if (bGeometry && !bHeaderFooter) {
                ConfigurationDialog.this.config.setOption("page_formatting", "convert_geometry");
            } else if (!bGeometry && bHeaderFooter) {
                ConfigurationDialog.this.config.setOption("page_formatting", "convert_header_footer");
            } else {
                ConfigurationDialog.this.config.setOption("page_formatting", "ignore_all");
            }
            this.checkBoxToConfig(dlg, "UseGeometry", "use_geometry");
            this.checkBoxToConfig(dlg, "UseFancyhdr", "use_fancyhdr");
            this.checkBoxToConfig(dlg, "UseLastpage", "use_lastpage");
            this.checkBoxToConfig(dlg, "UseEndnotes", "use_endnotes");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("ExportGeometryChange")) {
                this.exportGeometryChange(dlg);
                return true;
            }
            if (sMethod.equals("ExportHeaderAndFooterChange")) {
                this.exportHeaderAndFooterChange(dlg);
                return true;
            }
            return false;
        }

        private void exportGeometryChange(DialogAccess dlg) {
            dlg.setControlEnabled("UseGeometry", dlg.getCheckBoxStateAsBoolean("ExportGeometry"));
        }

        private void exportHeaderAndFooterChange(DialogAccess dlg) {
            dlg.setControlEnabled("UseFancyhdr", dlg.getCheckBoxStateAsBoolean("ExportHeaderFooter"));
        }
    }

    private class FontsHandler
    extends ConfigurationDialogBase.PageHandler {
        private FontsHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            this.checkBoxFromConfig(dlg, "UsePifont", "use_pifont");
            this.checkBoxFromConfig(dlg, "UseTipa", "use_tipa");
            this.checkBoxFromConfig(dlg, "UseEurosym", "use_eurosym");
            this.checkBoxFromConfig(dlg, "UseWasysym", "use_wasysym");
            this.checkBoxFromConfig(dlg, "UseIfsym", "use_ifsym");
            this.checkBoxFromConfig(dlg, "UseBbding", "use_bbding");
            this.checkBoxFromConfig(dlg, "UseFontspec", "use_fontspec");
            dlg.setControlEnabled("UseFontspec", false);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.checkBoxToConfig(dlg, "UsePifont", "use_pifont");
            this.checkBoxToConfig(dlg, "UseTipa", "use_tipa");
            this.checkBoxToConfig(dlg, "UseEurosym", "use_eurosym");
            this.checkBoxToConfig(dlg, "UseWasysym", "use_wasysym");
            this.checkBoxToConfig(dlg, "UseIfsym", "use_ifsym");
            this.checkBoxToConfig(dlg, "UseBbding", "use_bbding");
            this.checkBoxToConfig(dlg, "UseFontspec", "use_fontspec");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            return false;
        }
    }

    private class CharactersHandler
    extends ConfigurationDialogBase.AttributePageHandler {
        private final String[] sLaTeXAttributeNames = new String[]{"bold", "italic", "small-caps", "superscript", "subscript"};

        protected CharactersHandler() {
            this.sAttributeNames = this.sLaTeXAttributeNames;
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            super.setControls(dlg);
            this.checkBoxFromConfig(dlg, "UseHyperref", "use_hyperref");
            this.checkBoxFromConfig(dlg, "UseColor", "use_color");
            this.checkBoxFromConfig(dlg, "UseSoul", "use_soul");
            this.checkBoxFromConfig(dlg, "UseUlem", "use_ulem");
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            super.getControls(dlg);
            this.checkBoxToConfig(dlg, "UseHyperref", "use_hyperref");
            this.checkBoxToConfig(dlg, "UseColor", "use_color");
            this.checkBoxToConfig(dlg, "UseSoul", "use_soul");
            this.checkBoxToConfig(dlg, "UseUlem", "use_ulem");
        }

        @Override
        protected void setControls(DialogAccess dlg, Map<String, String> attr) {
            if (!attr.containsKey("before")) {
                attr.put("before", "");
            }
            if (!attr.containsKey("after")) {
                attr.put("after", "");
            }
            dlg.setTextFieldText("Before", attr.get("before"));
            dlg.setTextFieldText("After", attr.get("after"));
        }

        @Override
        protected void getControls(DialogAccess dlg, Map<String, String> attr) {
            attr.put("before", dlg.getComboBoxText("Before"));
            attr.put("after", dlg.getComboBoxText("After"));
        }

        @Override
        protected void prepareControls(DialogAccess dlg, boolean bEnable) {
            dlg.setControlEnabled("BeforeLabel", bEnable);
            dlg.setControlEnabled("Before", bEnable);
            dlg.setControlEnabled("AfterLabel", bEnable);
            dlg.setControlEnabled("After", bEnable);
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("UseSoulChange")) {
                this.useSoulChange(dlg);
                return true;
            }
            return super.handleEvent(dlg, sMethod);
        }

        private void useSoulChange(DialogAccess dlg) {
            dlg.setControlEnabled("UseSoul", false);
        }
    }

    private class StylesHandler
    extends ConfigurationDialogBase.StylesPageHandler {
        private final String[] sLaTeXFamilyNames;
        private final String[] sLaTeXOOoFamilyNames;

        protected StylesHandler() {
            super(5);
            this.sLaTeXFamilyNames = new String[]{"text", "paragraph", "paragraph-block", "list", "listitem"};
            this.sLaTeXOOoFamilyNames = new String[]{"CharacterStyles", "ParagraphStyles", "ParagraphStyles", "NumberingStyles", "NumberingStyles"};
            this.sFamilyNames = this.sLaTeXFamilyNames;
            this.sOOoFamilyNames = this.sLaTeXOOoFamilyNames;
        }

        @Override
        public void setControls(DialogAccess dlg) {
            super.setControls(dlg);
            String sOtherStyles = ConfigurationDialog.this.config.getOption("other_styles");
            if ("accept".equals(sOtherStyles)) {
                dlg.setListBoxSelectedItem("OtherStyles", (short)1);
            } else {
                dlg.setListBoxSelectedItem("OtherStyles", (short)0);
            }
            String sFormatting = ConfigurationDialog.this.config.getOption("formatting");
            if ("ignore_all".equals(sFormatting)) {
                dlg.setListBoxSelectedItem("Formatting", (short)0);
            } else if ("ignore_most".equals(sFormatting)) {
                dlg.setListBoxSelectedItem("Formatting", (short)1);
            } else if ("convert_most".equals(sFormatting)) {
                dlg.setListBoxSelectedItem("Formatting", (short)3);
            } else if ("convert_all".equals(sFormatting)) {
                dlg.setListBoxSelectedItem("Formatting", (short)4);
            } else {
                dlg.setListBoxSelectedItem("Formatting", (short)2);
            }
        }

        @Override
        public void getControls(DialogAccess dlg) {
            super.getControls(dlg);
            switch (dlg.getListBoxSelectedItem("OtherStyles")) {
                case 0: {
                    ConfigurationDialog.this.config.setOption("other_styles", "ignore");
                    break;
                }
                case 1: {
                    ConfigurationDialog.this.config.setOption("other_styles", "accept");
                }
            }
            switch (dlg.getListBoxSelectedItem("Formatting")) {
                case 0: {
                    ConfigurationDialog.this.config.setOption("formatting", "ignore_all");
                    break;
                }
                case 1: {
                    ConfigurationDialog.this.config.setOption("formatting", "ignore_most");
                    break;
                }
                case 2: {
                    ConfigurationDialog.this.config.setOption("formatting", "convert_basic");
                    break;
                }
                case 3: {
                    ConfigurationDialog.this.config.setOption("formatting", "convert_most");
                    break;
                }
                case 4: {
                    ConfigurationDialog.this.config.setOption("formatting", "convert_all");
                }
            }
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("AddNextClick")) {
                this.addNextClick(dlg);
                return true;
            }
            if (sMethod.equals("RemoveNextClick")) {
                this.removeNextClick(dlg);
                return true;
            }
            return super.handleEvent(dlg, sMethod);
        }

        @Override
        protected String getDefaultConfigName() {
            return "clean.xml";
        }

        @Override
        protected void setControls(DialogAccess dlg, Map<String, String> attr) {
            String[] sNextItems;
            if (!attr.containsKey("before")) {
                attr.put("before", "");
            }
            if (!attr.containsKey("after")) {
                attr.put("after", "");
            }
            dlg.setTextFieldText("Before", attr.get("before"));
            dlg.setTextFieldText("After", attr.get("after"));
            if (this.nCurrentFamily == 2 && attr.containsKey("next") && attr.get("next").length() > 0) {
                sNextItems = attr.get("next").split(";");
                Map<String, String> displayNames = this.styleNameProvider.getDisplayNames(this.sOOoFamilyNames[this.nCurrentFamily]);
                int nLen = sNextItems.length;
                for (int i = 0; i < nLen; ++i) {
                    if (!displayNames.containsKey(sNextItems[i])) continue;
                    sNextItems[i] = displayNames.get(sNextItems[i]);
                }
            } else {
                sNextItems = new String[]{};
            }
            dlg.setListBoxStringItemList("Next", sNextItems);
            dlg.setListBoxSelectedItem("Next", (short)Math.min(sNextItems.length - 1, 0));
            this.updateRemoveNextButton(dlg);
            if (this.nCurrentFamily < 2) {
                dlg.setCheckBoxStateAsBoolean("Verbatim", attr.containsKey("verbatim") ? "true".equals(attr.get("verbatim")) : false);
            } else {
                dlg.setCheckBoxStateAsBoolean("Verbatim", false);
            }
            if (this.nCurrentFamily == 1) {
                dlg.setCheckBoxStateAsBoolean("LineBreak", attr.containsKey("line-break") ? "true".equals(attr.get("line-break")) : false);
            } else {
                dlg.setCheckBoxStateAsBoolean("LineBreak", false);
            }
        }

        @Override
        protected void getControls(DialogAccess dlg, Map<String, String> attr) {
            attr.put("before", dlg.getTextFieldText("Before"));
            attr.put("after", dlg.getTextFieldText("After"));
            if (this.nCurrentFamily == 2) {
                String[] sNextItems = dlg.getListBoxStringItemList("Next");
                Map<String, String> internalNames = this.styleNameProvider.getInternalNames(this.sOOoFamilyNames[this.nCurrentFamily]);
                int nLen = sNextItems.length;
                for (int i = 0; i < nLen; ++i) {
                    if (!internalNames.containsKey(sNextItems[i])) continue;
                    sNextItems[i] = internalNames.get(sNextItems[i]);
                }
                StringBuilder list = new StringBuilder();
                for (int i = 0; i < nLen; ++i) {
                    if (i > 0) {
                        list.append(';');
                    }
                    list.append(sNextItems[i]);
                }
                attr.put("next", list.toString());
            }
            if (this.nCurrentFamily < 2) {
                attr.put("verbatim", Boolean.toString(dlg.getCheckBoxStateAsBoolean("Verbatim")));
            }
            if (this.nCurrentFamily == 1) {
                attr.put("line-break", Boolean.toString(dlg.getCheckBoxStateAsBoolean("LineBreak")));
            }
        }

        @Override
        protected void clearControls(DialogAccess dlg) {
            dlg.setTextFieldText("Before", "");
            dlg.setTextFieldText("After", "");
            dlg.setListBoxStringItemList("Next", new String[0]);
            dlg.setCheckBoxStateAsBoolean("Verbatim", false);
            dlg.setCheckBoxStateAsBoolean("LineBreak", false);
        }

        @Override
        protected void prepareControls(DialogAccess dlg, boolean bHasMappings) {
            dlg.setControlEnabled("BeforeLabel", bHasMappings);
            dlg.setControlEnabled("Before", bHasMappings);
            dlg.setControlEnabled("AfterLabel", bHasMappings);
            dlg.setControlEnabled("After", bHasMappings);
            dlg.setControlEnabled("NextLabel", bHasMappings && this.nCurrentFamily == 2);
            dlg.setControlEnabled("Next", bHasMappings && this.nCurrentFamily == 2);
            dlg.setControlEnabled("AddNextButton", bHasMappings && this.nCurrentFamily == 2);
            dlg.setControlEnabled("Verbatim", bHasMappings && this.nCurrentFamily < 2);
            dlg.setControlEnabled("LineBreak", bHasMappings && this.nCurrentFamily == 1);
            this.updateRemoveNextButton(dlg);
        }

        private void addNextClick(DialogAccess dlg) {
            this.appendItem(dlg, "Next", this.styleNameProvider.getInternalNames(this.sOOoFamilyNames[this.nCurrentFamily]).keySet());
            this.updateRemoveNextButton(dlg);
        }

        private void removeNextClick(DialogAccess dlg) {
            this.deleteCurrentItem(dlg, "Next");
            this.updateRemoveNextButton(dlg);
        }

        private void updateRemoveNextButton(DialogAccess dlg) {
            dlg.setControlEnabled("RemoveNextButton", dlg.getListBoxStringItemList("Next").length > 0);
        }
    }

    private class HeadingsHandler
    extends ConfigurationDialogBase.PageHandler {
        ComplexOption headingMap = new ComplexOption();
        short nCurrentWriterLevel = (short)-1;

        private HeadingsHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            short nMaxLevel;
            this.headingMap.clear();
            this.headingMap.copyAll(ConfigurationDialog.this.config.getComplexOption("heading-map"));
            this.nCurrentWriterLevel = (short)-1;
            for (nMaxLevel = 0; nMaxLevel < 10 && this.headingMap.containsKey(Integer.toString(nMaxLevel + 1)); nMaxLevel = (short)(nMaxLevel + 1)) {
            }
            dlg.setListBoxSelectedItem("MaxLevel", nMaxLevel);
            this.maxLevelChange(dlg);
            this.checkBoxFromConfig(dlg, "UseTitlesec", "use_titlesec");
            this.checkBoxFromConfig(dlg, "NoIndex", "no_index");
            this.checkBoxFromConfig(dlg, "UseTitletoc", "use_titletoc");
            this.noIndexChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.updateHeadingMap(dlg);
            ConfigurationDialog.this.config.getComplexOption("heading-map").clear();
            int nMaxLevel = dlg.getListBoxSelectedItem("MaxLevel");
            for (int i = 1; i <= nMaxLevel; ++i) {
                String sLevel = Integer.toString(i);
                ConfigurationDialog.this.config.getComplexOption("heading-map").copy(sLevel, this.headingMap.get(sLevel));
            }
            this.checkBoxToConfig(dlg, "UseTitlesec", "use_titlesec");
            this.checkBoxToConfig(dlg, "NoIndex", "no_index");
            this.checkBoxToConfig(dlg, "UseTitletoc", "use_titletoc");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("MaxLevelChange")) {
                this.maxLevelChange(dlg);
                return true;
            }
            if (sMethod.equals("WriterLevelChange")) {
                this.writerLevelChange(dlg);
                return true;
            }
            if (sMethod.equals("NoIndexChange")) {
                this.noIndexChange(dlg);
                return true;
            }
            return false;
        }

        private void maxLevelChange(DialogAccess dlg) {
            short nPreviousWriterLevel = this.nCurrentWriterLevel;
            dlg.setListBoxSelectedItem("WriterLevel", (short)-1);
            int nMaxLevel = dlg.getListBoxSelectedItem("MaxLevel");
            String[] sWriterLevels = new String[nMaxLevel];
            for (int i = 0; i < nMaxLevel; ++i) {
                sWriterLevels[i] = Integer.toString(i + 1);
            }
            dlg.setListBoxStringItemList("WriterLevel", sWriterLevels);
            if (nMaxLevel > 0) {
                short nNewWriterLevel = nPreviousWriterLevel + 1 > nMaxLevel ? (short)(nMaxLevel - 1) : (nPreviousWriterLevel > -1 ? nPreviousWriterLevel : (short)0);
                dlg.setListBoxSelectedItem("WriterLevel", nNewWriterLevel);
            }
            this.writerLevelChange(dlg);
            boolean bUpdate = dlg.getListBoxSelectedItem("MaxLevel") > 0;
            dlg.setControlEnabled("WriterLevelLabel", bUpdate);
            dlg.setControlEnabled("WriterLevel", bUpdate);
            dlg.setControlEnabled("LaTeXLevelLabel", bUpdate);
            dlg.setControlEnabled("LaTeXLevel", bUpdate);
            dlg.setControlEnabled("LaTeXNameLabel", bUpdate);
            dlg.setControlEnabled("LaTeXName", bUpdate);
            dlg.setControlEnabled("UseTitlesec", false);
        }

        private void writerLevelChange(DialogAccess dlg) {
            this.updateHeadingMap(dlg);
            this.nCurrentWriterLevel = dlg.getListBoxSelectedItem("WriterLevel");
            if (this.nCurrentWriterLevel > -1) {
                String sLevel = Integer.toString(this.nCurrentWriterLevel + 1);
                if (this.headingMap.containsKey(sLevel)) {
                    Map<String, String> attr = this.headingMap.get(sLevel);
                    dlg.setComboBoxText("LaTeXLevel", attr.containsKey("level") ? attr.get("level") : "");
                    dlg.setComboBoxText("LaTeXName", attr.containsKey("name") ? attr.get("name") : "");
                } else {
                    dlg.setListBoxSelectedItem("LaTeXLevel", (short)2);
                    dlg.setComboBoxText("LaTeXName", "");
                }
            } else {
                dlg.setComboBoxText("LaTeXLevel", "");
                dlg.setComboBoxText("LaTeXName", "");
            }
        }

        private void noIndexChange(DialogAccess dlg) {
            dlg.setControlEnabled("UseTitletoc", false);
        }

        private void updateHeadingMap(DialogAccess dlg) {
            if (this.nCurrentWriterLevel > -1) {
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("name", dlg.getComboBoxText("LaTeXName"));
                attr.put("level", dlg.getComboBoxText("LaTeXLevel"));
                this.headingMap.put(Integer.toString(this.nCurrentWriterLevel + 1), attr);
            }
        }
    }

    private class DocumentclassHandler
    extends ConfigurationDialogBase.PageHandler {
        private DocumentclassHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            this.checkBoxFromConfig(dlg, "NoPreamble", "no_preamble");
            this.textFieldFromConfig(dlg, "Documentclass", "documentclass");
            this.textFieldFromConfig(dlg, "GlobalOptions", "global_options");
            this.textFieldFromConfig(dlg, "CustomPreamble", "custom-preamble");
            this.noPreambleChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.checkBoxToConfig(dlg, "NoPreamble", "no_preamble");
            this.textFieldToConfig(dlg, "Documentclass", "documentclass");
            this.textFieldToConfig(dlg, "GlobalOptions", "global_options");
            this.textFieldToConfig(dlg, "CustomPreamble", "custom-preamble");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("NoPreambleChange")) {
                this.noPreambleChange(dlg);
                return true;
            }
            return false;
        }

        private void noPreambleChange(DialogAccess dlg) {
            boolean bPreamble = !dlg.getCheckBoxStateAsBoolean("NoPreamble");
            dlg.setControlEnabled("DocumentclassLabel", bPreamble);
            dlg.setControlEnabled("Documentclass", bPreamble);
            dlg.setControlEnabled("GlobalOptionsLabel", bPreamble);
            dlg.setControlEnabled("GlobalOptions", bPreamble);
            dlg.setControlEnabled("CustomPreambleLabel", bPreamble);
            dlg.setControlEnabled("CustomPreamble", bPreamble);
        }
    }
}

