/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XStringSubstitution;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import writer2latex.api.Converter;

public class FilterDataParser {
    private XSimpleFileAccess2 sfa2 = null;
    private XStringSubstitution xPathSub;

    public FilterDataParser(XComponentContext xComponentContext) {
        try {
            Object sfaObject = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xComponentContext);
            this.sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.xPathSub = null;
        try {
            Object psObject = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.util.PathSubstitution", xComponentContext);
            this.xPathSub = (XStringSubstitution)UnoRuntime.queryInterface(XStringSubstitution.class, (Object)psObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyFilterData(Object data, Converter converter) {
        String sFileName;
        XInputStreamToInputStreamAdapter is;
        XInputStream xIs;
        PropertyValue[] filterData = null;
        if (AnyConverter.isArray((Object)data)) {
            try {
                Object[] arrayData = (Object[])AnyConverter.toArray((Object)data);
                if (arrayData instanceof PropertyValue[]) {
                    filterData = (PropertyValue[])arrayData;
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (filterData == null) {
            return;
        }
        PropertyHelper props = new PropertyHelper(filterData);
        Object tpl = props.get("TemplateURL");
        String sTemplate = null;
        if (tpl != null && AnyConverter.isString((Object)tpl)) {
            try {
                sTemplate = this.substituteVariables(AnyConverter.toString((Object)tpl));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Object styles = props.get("StyleSheetURL");
        String sStyleSheet = null;
        if (styles != null && AnyConverter.isString((Object)styles)) {
            try {
                sStyleSheet = this.substituteVariables(AnyConverter.toString((Object)styles));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Object resourcedir = props.get("ResourceURL");
        String sResourceURL = null;
        if (resourcedir != null && AnyConverter.isString((Object)resourcedir)) {
            try {
                sResourceURL = this.substituteVariables(AnyConverter.toString((Object)resourcedir));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Object resources = props.get("Resources");
        String[] sResources = null;
        if (resources != null && AnyConverter.isString((Object)resources)) {
            try {
                sResources = this.substituteVariables(AnyConverter.toString((Object)resources)).split(";");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Object auto = props.get("AutoCreate");
        boolean bAutoCreate = false;
        if (auto != null && AnyConverter.isString((Object)auto)) {
            try {
                if ("true".equals(AnyConverter.toString((Object)auto))) {
                    bAutoCreate = true;
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Object cfg = props.get("ConfigURL");
        String sConfig = null;
        if (cfg != null && AnyConverter.isString((Object)cfg)) {
            try {
                sConfig = this.substituteVariables(AnyConverter.toString((Object)cfg));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (this.sfa2 != null && sTemplate != null && sTemplate.length() > 0) {
            try {
                xIs = this.sfa2.openFileRead(sTemplate);
                if (xIs != null) {
                    is = new XInputStreamToInputStreamAdapter(xIs);
                    converter.readTemplate((InputStream)is);
                    is.close();
                    xIs.closeInput();
                }
            }
            catch (IOException e) {
            }
            catch (NotConnectedException e) {
            }
            catch (CommandAbortedException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sfa2 != null && sStyleSheet != null && sStyleSheet.length() > 0) {
            try {
                xIs = this.sfa2.openFileRead(sStyleSheet);
                if (xIs != null) {
                    is = new XInputStreamToInputStreamAdapter(xIs);
                    converter.readStyleSheet((InputStream)is);
                    is.close();
                    xIs.closeInput();
                }
            }
            catch (IOException e) {
            }
            catch (NotConnectedException e) {
            }
            catch (CommandAbortedException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sfa2 != null && sResourceURL != null && sResourceURL.length() > 0) {
            try {
                String[] sURLs;
                for (String sURL : sURLs = this.sfa2.getFolderContents(sResourceURL, false)) {
                    XInputStream xIs2 = this.sfa2.openFileRead(sURL);
                    if (xIs2 == null) continue;
                    sFileName = sURL.substring(sURL.lastIndexOf(47) + 1);
                    XInputStreamToInputStreamAdapter is2 = new XInputStreamToInputStreamAdapter(xIs2);
                    converter.readResource((InputStream)is2, sFileName, null);
                    is2.close();
                    xIs2.closeInput();
                }
            }
            catch (IOException e) {
            }
            catch (CommandAbortedException e1) {
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (this.sfa2 != null && sResources != null) {
            for (String sResource : sResources) {
                String[] sParts = sResource.split("::");
                if (sParts.length <= 0) continue;
                String sURL = sParts[0];
                String sMediaType = null;
                if (sParts.length == 3) {
                    sFileName = sParts[1];
                    sMediaType = sParts[2];
                } else {
                    sFileName = sURL.substring(sURL.lastIndexOf(47) + 1);
                    if (sParts.length == 2) {
                        sMediaType = sParts[1];
                    }
                }
                try {
                    XInputStream xIs3 = this.sfa2.openFileRead(sURL);
                    if (xIs3 == null) continue;
                    XInputStreamToInputStreamAdapter is3 = new XInputStreamToInputStreamAdapter(xIs3);
                    converter.readResource((InputStream)is3, sFileName, sMediaType);
                    is3.close();
                    xIs3.closeInput();
                }
                catch (IOException e) {
                }
                catch (NotConnectedException e) {
                }
                catch (CommandAbortedException e) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            XOutputStream xOs;
            if (bAutoCreate && this.sfa2 != null && sConfig != null && !sConfig.startsWith("*") && !this.sfa2.exists(sConfig) && (xOs = this.sfa2.openFileWrite(sConfig)) != null) {
                XOutputStreamToOutputStreamAdapter os = new XOutputStreamToOutputStreamAdapter(xOs);
                converter.getConfig().write((OutputStream)os);
                os.flush();
                os.close();
                xOs.closeOutput();
            }
        }
        catch (IOException e) {
        }
        catch (NotConnectedException e) {
        }
        catch (CommandAbortedException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sConfig != null) {
            if (sConfig.startsWith("*")) {
                try {
                    converter.getConfig().readDefaultConfig(sConfig.substring(1));
                }
                catch (java.lang.IllegalArgumentException e) {}
            } else if (this.sfa2 != null) {
                try {
                    xIs = this.sfa2.openFileRead(sConfig);
                    if (xIs != null) {
                        XInputStreamToInputStreamAdapter is4 = new XInputStreamToInputStreamAdapter(xIs);
                        converter.getConfig().read((InputStream)is4);
                        is4.close();
                        xIs.closeInput();
                    }
                }
                catch (IOException e) {
                }
                catch (NotConnectedException e) {
                }
                catch (CommandAbortedException e) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            Object value;
            String sKey = keys.nextElement();
            if ("ConfigURL".equals(sKey) || "TemplateURL".equals(sKey) || "StyleSheetURL".equals(sKey) || "Resources".equals(sKey) || "AutoCreate".equals(sKey) || !AnyConverter.isString((Object)(value = props.get(sKey)))) continue;
            try {
                converter.getConfig().setOption(sKey, AnyConverter.toString((Object)value));
            }
            catch (IllegalArgumentException e) {}
        }
    }

    private String substituteVariables(String sUrl) {
        if (this.xPathSub != null) {
            try {
                return this.xPathSub.substituteVariables(sUrl, false);
            }
            catch (NoSuchElementException e) {
                return sUrl;
            }
        }
        return sUrl;
    }
}

