/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XServiceName;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.text.XTextDocument;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.writer2xhtml.XBatchConverter;
import org.openoffice.da.writer2xhtml.XBatchHandler;
import writer2latex.api.ConverterFactory;
import writer2latex.api.IndexPageEntry;
import writer2latex.api.OutputFile;

public class BatchConverter
implements XBatchConverter,
XServiceName,
XServiceInfo,
XTypeProvider {
    public static final String __serviceName = "org.openoffice.da.writer2xhtml.BatchConverter";
    public static final String __implementationName = "org.openoffice.da.comp.writer2xhtml.BatchConverter";
    private XComponentContext xComponentContext = null;
    private XSimpleFileAccess2 sfa2 = null;
    private writer2latex.api.BatchConverter batchConverter = null;
    private XBatchHandler handler;
    private boolean bRecurse = true;
    private String sWriterFilterName = "org.openoffice.da.writer2xhtml";
    private Object writerFilterData = null;
    private String sCalcFilterName = "org.openoffice.da.calc2xhtml";
    private Object calcFilterData = null;
    private boolean bIncludePdf = true;
    private boolean bIncludeOriginal = false;
    private boolean bUseTitle = true;
    private boolean bUseDescription = true;
    private String sUplink = "";
    private String sDirectoryIcon = "";
    private String sDocumentIcon = "";
    private String sTemplateURL = null;

    public BatchConverter(XComponentContext xComponentContext) {
        this.xComponentContext = xComponentContext;
        try {
            Object sfaObject = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xComponentContext);
            this.sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    private String getValue(Object any) {
        if (AnyConverter.isString((Object)any)) {
            try {
                return AnyConverter.toString((Object)any);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        }
        return "";
    }

    @Override
    public void convert(String sSourceURL, String sTargetURL, PropertyValue[] lArguments, XBatchHandler handler) {
        this.batchConverter = ConverterFactory.createBatchConverter("text/html");
        this.handler = handler;
        int nSize = lArguments.length;
        for (int i = 0; i < nSize; ++i) {
            String sName = lArguments[i].Name;
            Object value = lArguments[i].Value;
            if ("Recurse".equals(sName)) {
                this.bRecurse = !"false".equals(this.getValue(value));
                continue;
            }
            if ("IncludePdf".equals(sName)) {
                this.bIncludePdf = !"false".equals(this.getValue(value));
                continue;
            }
            if ("IncludeOriginal".equals(sName)) {
                this.bIncludeOriginal = "true".equals(this.getValue(value));
                continue;
            }
            if ("UseTitle".equals(sName)) {
                this.bUseTitle = !"false".equals(this.getValue(value));
                continue;
            }
            if ("UseDescription".equals(sName)) {
                this.bUseDescription = !"false".equals(this.getValue(value));
                continue;
            }
            if ("Uplink".equals(sName)) {
                this.sUplink = this.getValue(value);
                continue;
            }
            if ("DirectoryIcon".equals(sName)) {
                this.sDirectoryIcon = this.getValue(value);
                continue;
            }
            if ("DocumentIcon".equals(sName)) {
                this.sDocumentIcon = this.getValue(value);
                continue;
            }
            if ("TemplateURL".equals(sName)) {
                this.sTemplateURL = this.getValue(value);
                continue;
            }
            if ("WriterFilterName".equals(sName)) {
                this.sWriterFilterName = this.getValue(value);
                continue;
            }
            if ("WriterFilterData".equals(sName)) {
                this.writerFilterData = lArguments[i].Value;
                continue;
            }
            if ("CalcFilterName".equals(sName)) {
                this.sCalcFilterName = this.getValue(value);
                continue;
            }
            if (!"CalcFilterData".equals(sName)) continue;
            this.calcFilterData = lArguments[i].Value;
        }
        this.batchConverter.getConfig().setOption("uplink", this.sUplink);
        this.batchConverter.getConfig().setOption("directory_icon", this.sDirectoryIcon);
        this.batchConverter.getConfig().setOption("document_icon", this.sDocumentIcon);
        if (this.sTemplateURL != null) {
            try {
                XInputStream xis = this.sfa2.openFileRead(this.sTemplateURL);
                XInputStreamToInputStreamAdapter isa = new XInputStreamToInputStreamAdapter(xis);
                this.batchConverter.readTemplate((InputStream)isa);
            }
            catch (IOException e) {
            }
            catch (CommandAbortedException e) {
            }
            catch (com.sun.star.uno.Exception e) {
                // empty catch block
            }
        }
        handler.startConversion();
        this.convertDirectory(sSourceURL, sTargetURL, this.getName(sSourceURL));
        handler.endConversion();
    }

    private boolean convertDirectory(String sSourceURL, String sTargetURL, String sHeading) {
        String[] contents;
        this.handler.startDirectory(sSourceURL);
        try {
            contents = this.sfa2.getFolderContents(sSourceURL, true);
        }
        catch (CommandAbortedException e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        catch (com.sun.star.uno.Exception e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        int nLen = contents.length;
        IndexPageEntry[] entries = new IndexPageEntry[nLen];
        if (this.bRecurse) {
            String sUplink = this.batchConverter.getConfig().getOption("uplink");
            for (int i = 0; i < nLen; ++i) {
                boolean bIsDirectory = false;
                try {
                    bIsDirectory = this.sfa2.isFolder(contents[i]);
                }
                catch (CommandAbortedException e) {
                }
                catch (com.sun.star.uno.Exception e) {
                    // empty catch block
                }
                if (!bIsDirectory) continue;
                this.batchConverter.getConfig().setOption("uplink", "../index.html");
                String sNewTargetURL = this.ensureSlash(sTargetURL) + this.getName(contents[i]);
                String sNewHeading = sHeading + " - " + this.decodeURL(this.getName(contents[i]));
                boolean bResult = this.convertDirectory(contents[i], sNewTargetURL, sNewHeading);
                this.batchConverter.getConfig().setOption("uplink", sUplink);
                if (!bResult) {
                    return false;
                }
                IndexPageEntry entry = new IndexPageEntry(this.ensureSlash(sNewTargetURL) + "index.html", true);
                entry.setDisplayName(this.decodeURL(this.getName(contents[i])));
                entries[i] = entry;
            }
        }
        for (int i = 0; i < nLen; ++i) {
            boolean bIsFile = false;
            try {
                bIsFile = this.sfa2.exists(contents[i]) && !this.sfa2.isFolder(contents[i]);
            }
            catch (CommandAbortedException e) {
            }
            catch (com.sun.star.uno.Exception e) {
                // empty catch block
            }
            if (!bIsFile) continue;
            IndexPageEntry entry = this.convertFile(contents[i], sTargetURL);
            if (entry != null) {
                entries[i] = entry;
            }
            if (!this.handler.cancel()) continue;
            return false;
        }
        OutputFile indexFile = this.batchConverter.createIndexFile(sHeading, entries);
        try {
            if (!this.sfa2.exists(sTargetURL)) {
                this.sfa2.createFolder(sTargetURL);
            }
        }
        catch (CommandAbortedException e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        catch (com.sun.star.uno.Exception e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        try {
            Object xPipeObj = this.xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.io.Pipe", this.xComponentContext);
            XInputStream xInStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, (Object)xPipeObj);
            XOutputStream xOutStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)xPipeObj);
            XOutputStreamToOutputStreamAdapter outStream = new XOutputStreamToOutputStreamAdapter(xOutStream);
            indexFile.write((OutputStream)outStream);
            outStream.flush();
            outStream.close();
            xOutStream.closeOutput();
            this.sfa2.writeFile(this.ensureSlash(sTargetURL) + "index.html", xInStream);
        }
        catch (IOException e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        catch (NotConnectedException e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        catch (com.sun.star.uno.Exception e) {
            this.handler.endDirectory(sSourceURL, false);
            return true;
        }
        this.handler.endDirectory(sSourceURL, true);
        return !this.handler.cancel();
    }

    private IndexPageEntry convertFile(String sSourceFileURL, String sTargetURL) {
        XComponent xDocument;
        this.handler.startFile(sSourceFileURL);
        String sTargetFileURL = this.ensureSlash(sTargetURL) + this.getBaseName(sSourceFileURL) + ".html";
        IndexPageEntry entry = new IndexPageEntry(this.getName(sTargetFileURL), false);
        entry.setDisplayName(this.decodeURL(this.getBaseName(sTargetFileURL)));
        try {
            Object desktop = this.xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", this.xComponentContext);
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)desktop);
            PropertyValue[] fileProps = new PropertyValue[]{new PropertyValue()};
            fileProps[0].Name = "Hidden";
            fileProps[0].Value = new Boolean(true);
            xDocument = xComponentLoader.loadComponentFromURL(sSourceFileURL, "_blank", 0, fileProps);
        }
        catch (com.sun.star.io.IOException e) {
            this.handler.endFile(sSourceFileURL, false);
            return null;
        }
        catch (com.sun.star.uno.Exception e) {
            this.handler.endFile(sSourceFileURL, false);
            return null;
        }
        XDocumentProperties docProps = ((XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xDocument)).getDocumentProperties();
        String loadedTitle = docProps.getTitle();
        if (this.bUseTitle && loadedTitle.length() > 0) {
            entry.setDisplayName(loadedTitle);
        }
        String loadedDescription = docProps.getDescription();
        if (this.bUseDescription && loadedDescription.length() > 0) {
            entry.setDescription(loadedDescription);
        }
        boolean bText = false;
        boolean bSpreadsheet = false;
        if (UnoRuntime.queryInterface(XTextDocument.class, (Object)xDocument) != null) {
            bText = true;
        } else if (UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xDocument) != null) {
            bSpreadsheet = true;
        }
        if (!bText && !bSpreadsheet) {
            this.handler.endFile(sSourceFileURL, false);
            xDocument.dispose();
            return null;
        }
        boolean bHtmlSuccess = true;
        PropertyHelper exportProps = new PropertyHelper();
        exportProps.put("FilterName", bText ? this.sWriterFilterName : this.sCalcFilterName);
        exportProps.put("Overwrite", new Boolean(true));
        if (bText && this.writerFilterData != null) {
            exportProps.put("FilterData", this.writerFilterData);
        }
        if (bSpreadsheet && this.calcFilterData != null) {
            exportProps.put("FilterData", this.calcFilterData);
        }
        try {
            XStorable xStore = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xDocument);
            xStore.storeToURL(sTargetFileURL, exportProps.toArray());
        }
        catch (com.sun.star.io.IOException e) {
            entry.setFile(null);
            bHtmlSuccess = false;
        }
        boolean bPdfSuccess = true;
        if (this.bIncludePdf) {
            PropertyValue[] pdfProps = new PropertyValue[2];
            pdfProps[0] = new PropertyValue();
            pdfProps[0].Name = "FilterName";
            pdfProps[0].Value = bText ? "writer_pdf_Export" : "calc_pdf_Export";
            pdfProps[1] = new PropertyValue();
            pdfProps[1].Name = "Overwrite";
            pdfProps[1].Value = new Boolean(true);
            String sPdfFileURL = this.ensureSlash(sTargetURL) + this.getBaseName(sSourceFileURL) + ".pdf";
            try {
                XStorable xStore = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xDocument);
                xStore.storeToURL(sPdfFileURL, pdfProps);
                entry.setPdfFile(sPdfFileURL);
            }
            catch (com.sun.star.io.IOException e) {
                bPdfSuccess = false;
            }
        }
        xDocument.dispose();
        if (this.bIncludeOriginal) {
            // empty if block
        }
        this.handler.endFile(sSourceFileURL, bHtmlSuccess && bPdfSuccess);
        if (bHtmlSuccess || bPdfSuccess) {
            return entry;
        }
        return null;
    }

    private String getName(String sURL) {
        int n = sURL.lastIndexOf("/");
        return n > -1 ? sURL.substring(n + 1) : sURL;
    }

    private String getBaseName(String sURL) {
        String sName = this.getName(sURL);
        int n = sName.lastIndexOf(".");
        return n > -1 ? sName.substring(0, n) : sName;
    }

    private String ensureSlash(String sURL) {
        return sURL.endsWith("/") ? sURL : sURL + "/";
    }

    private String decodeURL(String sURL) {
        try {
            return new URI(sURL).getPath();
        }
        catch (URISyntaxException e) {
            return sURL;
        }
    }

    public Type[] getTypes() {
        Type[] typeReturn = new Type[]{};
        try {
            typeReturn = new Type[]{new Type(XBatchConverter.class), new Type(XTypeProvider.class), new Type(XServiceName.class), new Type(XServiceInfo.class)};
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeReturn;
    }

    public byte[] getImplementationId() {
        byte[] byteReturn = new byte[]{};
        byteReturn = new String("" + this.hashCode()).getBytes();
        return byteReturn;
    }

    public String getServiceName() {
        return __serviceName;
    }

    public boolean supportsService(String stringServiceName) {
        return stringServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] stringSupportedServiceNames = new String[]{__serviceName};
        return stringSupportedServiceNames;
    }
}

