/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.Mouth;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.Token;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.TokenType;

public class DeTeXtive {
    private Mouth mouth;
    private Token token;
    private HashSet<String> packages;

    public String deTeXt(InputStream is) throws IOException {
        this.mouth = new Mouth((Reader)new InputStreamReader(is, "ISO8859_1"));
        this.token = this.mouth.getTokenObject();
        this.packages = new HashSet();
        this.mouth.getToken();
        if (this.parseHeader() && this.parsePreamble()) {
            if (this.packages.contains("xunicode")) {
                return "XeLaTeX";
            }
            return "LaTeX";
        }
        return null;
    }

    private boolean parseHeader() throws IOException {
        this.skipBlanks();
        if (this.token.isCS("documentclass") || this.token.isCS("documentstyle")) {
            String sClassName;
            this.mouth.getToken();
            this.skipSpaces();
            if (this.token.is('[', TokenType.OTHER)) {
                this.skipOptional();
                this.skipSpaces();
            }
            if (this.token.getType() == TokenType.BEGIN_GROUP && (sClassName = this.parseArgumentAsString()).length() > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean parsePreamble() throws IOException {
        while (this.token.getType() != TokenType.ENDINPUT) {
            if (this.token.isCS("usepackage")) {
                this.mouth.getToken();
                this.skipSpaces();
                if (this.token.is('[', TokenType.OTHER)) {
                    this.skipOptional();
                    this.skipSpaces();
                }
                String sName = this.parseArgumentAsString();
                this.packages.add(sName);
                continue;
            }
            if (this.token.getType() == TokenType.BEGIN_GROUP) {
                this.skipGroup();
                continue;
            }
            if (this.token.isCS("begin")) {
                this.mouth.getToken();
                this.skipSpaces();
                if (!"document".equals(this.parseArgumentAsString())) continue;
                return true;
            }
            this.mouth.getToken();
        }
        return false;
    }

    private void skipBlanks() throws IOException {
        while (this.token.getType() == TokenType.SPACE || this.token.isCS("par")) {
            this.mouth.getToken();
        }
    }

    private void skipSpaces() throws IOException {
        while (this.token.getType() == TokenType.SPACE) {
            this.mouth.getToken();
        }
    }

    private void skipOptional() throws IOException {
        assert (this.token.is('[', TokenType.OTHER));
        this.mouth.getToken();
        while (!this.token.is(']', TokenType.OTHER) && this.token.getType() != TokenType.ENDINPUT) {
            if (this.token.getType() == TokenType.BEGIN_GROUP) {
                this.skipGroup();
                continue;
            }
            this.mouth.getToken();
        }
        this.mouth.getToken();
    }

    private void skipGroup() throws IOException {
        assert (this.token.getType() == TokenType.BEGIN_GROUP);
        this.mouth.getToken();
        while (this.token.getType() != TokenType.END_GROUP && this.token.getType() != TokenType.ENDINPUT) {
            if (this.token.getType() == TokenType.BEGIN_GROUP) {
                this.skipGroup();
                continue;
            }
            this.mouth.getToken();
        }
        this.mouth.getToken();
    }

    private String parseArgumentAsString() throws IOException {
        if (this.token.getType() == TokenType.BEGIN_GROUP) {
            this.mouth.getToken();
            StringBuilder sb = new StringBuilder();
            while (this.token.getType() != TokenType.END_GROUP && this.token.getType() != TokenType.ENDINPUT) {
                if (this.token.getType() != TokenType.COMMAND_SEQUENCE) {
                    sb.append(this.token.getChar());
                }
                this.mouth.getToken();
            }
            this.mouth.getToken();
            return sb.toString();
        }
        String s = "";
        if (this.token.getType() != TokenType.COMMAND_SEQUENCE) {
            s = this.token.getString();
        }
        this.mouth.getToken();
        return s;
    }
}

