// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TFunction_Driver_HeaderFile
#define _TFunction_Driver_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_TFunction_Driver.hxx>

#include <TDF_Label.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class TDF_Label;
class TFunction_Logbook;
class TDF_LabelList;


//! This  driver  class provide  services  around function
//! execution.   One instance of  this class is  built for
//! the whole  session.    The driver  is bound   to   the
//! DriverGUID in the DriverTable class.
//! It allows you to create classes which inherit from
//! this abstract class.
//! These subclasses identify the various algorithms
//! which can be applied to the data contained in the
//! attributes of sub-labels of a model.
//! A single instance of this class and each of its
//! subclasses is built for the whole session.
class TFunction_Driver : public MMgt_TShared
{

public:

  
  //! Initializes the label L for this function prior to its  execution.
  Standard_EXPORT   void Init (const TDF_Label& L) ;
  
  //! Returns the label of the driver for this function.
      TDF_Label Label()  const;
  
  //! Validates labels of a function  in <log>.
  //! This function is the one initialized in this function driver.
  //! Warning
  //! In regeneration mode, the solver must call this
  //! method even if the function is not executed.
  //! execution of function
  //! =====================
  Standard_EXPORT virtual   void Validate (TFunction_Logbook& log)  const;
  
  //! Analyzes the labels in the logbook log.
  //! Returns true if attributes have been modified.
  //! If the function label itself has been modified, the function must be executed.
  Standard_EXPORT virtual   Standard_Boolean MustExecute (const TFunction_Logbook& log)  const;
  
  //! Executes the function in this function driver and
  //! puts the impacted labels in the logbook log.
  //! arguments & results of functions
  //! ================================
  Standard_EXPORT virtual   Standard_Integer Execute (TFunction_Logbook& log)  const = 0;
  
  //! The method fills-in the list by labels,
  //! where the arguments of the function are located.
  Standard_EXPORT virtual   void Arguments (TDF_LabelList& args)  const;
  
  //! The method fills-in the list by labels,
  //! where the results of the function are located.
  Standard_EXPORT virtual   void Results (TDF_LabelList& res)  const;




  DEFINE_STANDARD_RTTI(TFunction_Driver)

protected:

  
  //! initialisation of the driver
  //! ============================
  Standard_EXPORT TFunction_Driver();



private: 


  TDF_Label myLabel;


};


#include <TFunction_Driver.lxx>





#endif // _TFunction_Driver_HeaderFile
