/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.util.GT;

public class ServerErrorMessage
implements Serializable {
    private static final Character SEVERITY = Character.valueOf('S');
    private static final Character MESSAGE = Character.valueOf('M');
    private static final Character DETAIL = Character.valueOf('D');
    private static final Character HINT = Character.valueOf('H');
    private static final Character POSITION = Character.valueOf('P');
    private static final Character WHERE = Character.valueOf('W');
    private static final Character FILE = Character.valueOf('F');
    private static final Character LINE = Character.valueOf('L');
    private static final Character ROUTINE = Character.valueOf('R');
    private static final Character SQLSTATE = Character.valueOf('C');
    private static final Character INTERNAL_POSITION = Character.valueOf('p');
    private static final Character INTERNAL_QUERY = Character.valueOf('q');
    private static final Character SCHEMA = Character.valueOf('s');
    private static final Character TABLE = Character.valueOf('t');
    private static final Character COLUMN = Character.valueOf('c');
    private static final Character DATATYPE = Character.valueOf('d');
    private static final Character CONSTRAINT = Character.valueOf('n');
    private final Map<Character, String> m_mesgParts = new HashMap<Character, String>();
    private final int verbosity;

    public ServerErrorMessage(String p_serverError, int verbosity) {
        this.verbosity = verbosity;
        char[] l_chars = p_serverError.toCharArray();
        int l_length = l_chars.length;
        for (int l_pos = 0; l_pos < l_length; ++l_pos) {
            char l_mesgType = l_chars[l_pos];
            if (l_mesgType == '\u0000') continue;
            int l_startString = ++l_pos;
            while (l_pos < l_length && l_chars[l_pos] != '\u0000') {
                ++l_pos;
            }
            String l_mesgPart = new String(l_chars, l_startString, l_pos - l_startString);
            this.m_mesgParts.put(Character.valueOf(l_mesgType), l_mesgPart);
        }
    }

    public String getSQLState() {
        return this.m_mesgParts.get(SQLSTATE);
    }

    public String getMessage() {
        return this.m_mesgParts.get(MESSAGE);
    }

    public String getSeverity() {
        return this.m_mesgParts.get(SEVERITY);
    }

    public String getDetail() {
        return this.m_mesgParts.get(DETAIL);
    }

    public String getHint() {
        return this.m_mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public String getWhere() {
        return this.m_mesgParts.get(WHERE);
    }

    public String getSchema() {
        return this.m_mesgParts.get(SCHEMA);
    }

    public String getTable() {
        return this.m_mesgParts.get(TABLE);
    }

    public String getColumn() {
        return this.m_mesgParts.get(COLUMN);
    }

    public String getDatatype() {
        return this.m_mesgParts.get(DATATYPE);
    }

    public String getConstraint() {
        return this.m_mesgParts.get(CONSTRAINT);
    }

    public String getFile() {
        return this.m_mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public String getRoutine() {
        return this.m_mesgParts.get(ROUTINE);
    }

    public String getInternalQuery() {
        return this.m_mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    private int getIntegerPart(Character c) {
        String s = this.m_mesgParts.get(c);
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public String toString() {
        StringBuilder l_totalMessage = new StringBuilder();
        String l_message = this.m_mesgParts.get(SEVERITY);
        if (l_message != null) {
            l_totalMessage.append(l_message).append(": ");
        }
        if ((l_message = this.m_mesgParts.get(MESSAGE)) != null) {
            l_totalMessage.append(l_message);
        }
        if ((l_message = this.m_mesgParts.get(DETAIL)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Detail: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(HINT)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Hint: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(POSITION)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Position: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(WHERE)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Where: {0}", l_message));
        }
        if (this.verbosity > 2) {
            String l_internalPosition;
            String l_internalQuery = this.m_mesgParts.get(INTERNAL_QUERY);
            if (l_internalQuery != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Internal Query: {0}", l_internalQuery));
            }
            if ((l_internalPosition = this.m_mesgParts.get(INTERNAL_POSITION)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Internal Position: {0}", l_internalPosition));
            }
            String l_file = this.m_mesgParts.get(FILE);
            String l_line = this.m_mesgParts.get(LINE);
            String l_routine = this.m_mesgParts.get(ROUTINE);
            if (l_file != null || l_line != null || l_routine != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", new Object[]{l_file, l_routine, l_line}));
            }
            if ((l_message = this.m_mesgParts.get(SQLSTATE)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Server SQLState: {0}", l_message));
            }
        }
        return l_totalMessage.toString();
    }
}

