/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassAccessFilter
implements ClassVisitor {
    private final int requiredSetAccessFlags;
    private final int requiredUnsetAccessFlags;
    private final ClassVisitor classVisitor;

    public ClassAccessFilter(int n, int n2, ClassVisitor classVisitor) {
        this.requiredSetAccessFlags = n;
        this.requiredUnsetAccessFlags = n2;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.accepted(programClass.getAccessFlags())) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.accepted(libraryClass.getAccessFlags())) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean accepted(int n) {
        return (this.requiredSetAccessFlags & ~n) == 0 && (this.requiredUnsetAccessFlags & n) == 0;
    }
}

