/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

class NameMarker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    NameMarker() {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.keepClassName(programClass);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.keepClassName(libraryClass);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.keepFieldName(programClass, programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.keepMethodName(programClass, programMethod);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.keepFieldName(libraryClass, libraryField);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.keepMethodName(libraryClass, libraryMethod);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        int n = innerClassesInfo.u2innerClassIndex;
        int n2 = innerClassesInfo.u2outerClassIndex;
        if (n != 0 && n2 != 0 && clazz.getClassName(n).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(n2, this);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    public void keepClassName(Clazz clazz) {
        ClassObfuscator.setNewClassName(clazz, clazz.getName());
    }

    private void keepFieldName(Clazz clazz, Field field) {
        MemberObfuscator.setFixedNewMemberName(field, field.getName(clazz));
    }

    private void keepMethodName(Clazz clazz, Method method) {
        String string = method.getName(clazz);
        if (!ClassUtil.isInitializer(string)) {
            MemberObfuscator.setFixedNewMemberName(method, string);
        }
    }
}

