/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.UInt32ImageTypeSpecifier;
import java.awt.color.ColorSpace;
import java.awt.image.IndexColorModel;
import javax.imageio.ImageTypeSpecifier;

public final class ImageTypeSpecifiers {
    private ImageTypeSpecifiers() {
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        return ImageTypeSpecifier.createFromBufferedImageType(n);
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return ImageTypeSpecifier.createPacked(colorSpace, n, n2, n3, n4, n5, bl);
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        if (n == 3) {
            return new UInt32ImageTypeSpecifier(colorSpace, nArray, bl, bl2);
        }
        return ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n, bl, bl2);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        return ImageTypeSpecifier.createBanded(colorSpace, nArray, nArray2, n, bl, bl2);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2) {
        if (n == 32 && n2 == 3) {
            return new UInt32ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0}, false, false);
        }
        return ImageTypeSpecifier.createGrayscale(n, n2, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        if (n == 32 && n2 == 3) {
            return new UInt32ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0, 1}, true, bl);
        }
        return ImageTypeSpecifier.createGrayscale(n, n2, false, bl);
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, n, n2);
    }

    public static ImageTypeSpecifier createIndexed(int[] nArray, boolean bl, int n, int n2, int n3) {
        return ImageTypeSpecifiers.createFromIndexColorModel(new IndexColorModel(n2, nArray.length, nArray, 0, bl, n, n3));
    }

    public static ImageTypeSpecifier createFromIndexColorModel(IndexColorModel indexColorModel) {
        return new IndexedImageTypeSpecifier(indexColorModel);
    }
}

