/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartFMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages;
    private MessageHandler myDefaultHandler;
    private volatile SmartFMap<Topic, Object> mySubscriptions;

    public MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(0);
        }
        this.myPendingMessages = MessageBusImpl.createThreadLocalQueue();
        this.mySubscriptions = SmartFMap.emptyMap();
        this.myBus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler) throws IllegalStateException {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(2);
        }
        ThreadLocal<Queue<Message>> threadLocal = this.myPendingMessages;
        synchronized (threadLocal) {
            if (this.mySubscriptions.get(topic) != null) {
                throw new IllegalStateException("Subscription to " + topic + " already exists");
            }
            this.mySubscriptions = this.mySubscriptions.plus(topic, handler);
        }
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public <L> void subscribe(@NotNull Topic<L> topic) throws IllegalStateException {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(3);
        }
        if (this.myDefaultHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        if (topic.getListenerClass().isInstance(this.myDefaultHandler)) {
            throw new IllegalStateException("Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + this.myDefaultHandler.getClass() + "'");
        }
        this.subscribe(topic, this.myDefaultHandler);
    }

    @Override
    public void setDefaultHandler(MessageHandler handler) {
        this.myDefaultHandler = handler;
    }

    @Override
    public void dispose() {
        Queue<Message> jobs = this.myPendingMessages.get();
        this.myPendingMessages.remove();
        this.myBus.notifyConnectionTerminated(this);
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
    }

    @Override
    public void disconnect() {
        Disposer.dispose(this);
    }

    @Override
    public void deliverImmediately() {
        Queue<Message> messages = this.myPendingMessages.get();
        while (!messages.isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(@NotNull Message message) {
        if (message == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(4);
        }
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message);
        Topic topic = message.getTopic();
        Object handler = this.mySubscriptions.get(topic);
        try {
            Method listenerMethod = message.getListenerMethod();
            if (handler == this.myDefaultHandler) {
                this.myDefaultHandler.handle(listenerMethod, message.getArgs());
            } else {
                listenerMethod.invoke(handler, message.getArgs());
            }
        }
        catch (AbstractMethodError listenerMethod) {
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
        catch (Throwable e) {
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
    }

    void scheduleMessageDelivery(@NotNull Message message) {
        if (message == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(5);
        }
        this.myPendingMessages.get().offer(message);
    }

    boolean containsMessage(@NotNull Topic topic) {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(6);
        }
        for (Message message : this.myPendingMessages.get()) {
            if (message.getTopic() != topic) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mySubscriptions.toString();
    }

    @NotNull
    MessageBusImpl getBus() {
        MessageBusImpl messageBusImpl = this.myBus;
        if (messageBusImpl == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(7);
        }
        return messageBusImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusConnectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusConnectionImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMessageDelivery";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsMessage";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

