/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.breadcrumbs;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;

public class Breadcrumbs
extends JBPanelWithEmptyText {
    private static final int LEFT_RIGHT = 5;
    private static final int TOP_BOTTOM = 3;
    private BiConsumer<Crumb, InputEvent> hover = (crumb, event) -> {
        this.hovered = crumb;
    };
    private BiConsumer<Crumb, InputEvent> select = (crumb, event) -> {
        this.selected = crumb;
    };
    private final ArrayList<CrumbView> views = new ArrayList();
    private final Font[] cache = new Font[4];
    private Crumb hovered;
    private Crumb selected;
    private static final AbstractLayoutManager STATELESS_LAYOUT = new AbstractLayoutManager(){

        public Dimension preferredLayoutSize(Container container) {
            Dimension size = new Dimension();
            if (container instanceof Breadcrumbs) {
                Breadcrumbs breadcrumbs = (Breadcrumbs)((Object)container);
                breadcrumbs.updatePreferredSize(size, breadcrumbs.getScale());
            }
            JBInsets.addTo((Dimension)size, (Insets)container.getInsets());
            return size;
        }

        public void layoutContainer(Container container) {
            if (container instanceof Breadcrumbs) {
                Breadcrumbs breadcrumbs = (Breadcrumbs)((Object)container);
                breadcrumbs.layout(false);
            }
        }
    };

    public Breadcrumbs() {
        MouseHandler handler = new MouseHandler();
        this.addMouseListener((MouseListener)((Object)handler));
        this.addMouseMotionListener((MouseMotionListener)((Object)handler));
        this.setLayout((LayoutManager)STATELESS_LAYOUT);
        this.setOpaque(true);
    }

    public void onHover(BiConsumer<Crumb, InputEvent> consumer) {
        this.hover = this.hover.andThen(consumer);
    }

    public void onSelect(BiConsumer<Crumb, InputEvent> consumer) {
        this.select = this.select.andThen(consumer);
    }

    public boolean isHovered(Crumb crumb) {
        return this.hovered == crumb;
    }

    public boolean isSelected(Crumb crumb) {
        return this.selected == crumb;
    }

    public boolean isAfterSelected(Crumb crumb) {
        for (CrumbView view : this.views) {
            if (view.crumb == null) continue;
            if (view.crumb == crumb) {
                return false;
            }
            if (!this.isSelected(view.crumb)) continue;
            break;
        }
        return true;
    }

    public Crumb getCrumbAt(int x, int y) {
        for (CrumbView view : this.views) {
            if (!view.contains(x, y)) continue;
            return view.crumb;
        }
        return null;
    }

    public Iterable<Crumb> getCrumbs() {
        return this.views.stream().map(view -> ((CrumbView)view).crumb).filter(crumb -> crumb != null).collect(Collectors.toList());
    }

    public void setCrumbs(Iterable<? extends Crumb> crumbs) {
        CrumbView view = null;
        int index = 0;
        if (crumbs != null) {
            for (Crumb crumb : crumbs) {
                if (crumb == null) continue;
                if (index < this.views.size()) {
                    view = this.views.get(index++);
                    view.initialize(crumb);
                    continue;
                }
                view = new CrumbView(view, crumb);
                this.views.add(view);
                ++index;
            }
        }
        while (index < this.views.size()) {
            this.views.get(index++).initialize(null);
        }
        if (this.hovered != null) {
            this.hover.accept(null, null);
        }
        if (this.selected != null) {
            this.select.accept(null, null);
        }
        this.revalidate();
        this.repaint();
    }

    public String getToolTipText(MouseEvent event) {
        return this.hovered == null ? null : this.hovered.getTooltip();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope(!Registry.is((String)"editor.breadcrumbs.system.font")));
            for (CrumbView view : this.views) {
                if (view.crumb == null) continue;
                view.paint(g2d);
            }
        }
    }

    protected void paintMarker(Graphics2D g, int x, int y, int width, int height, Crumb crumb, int thickness) {
        Color foreground;
        if (thickness > 0 && (foreground = this.getMarkerForeground(crumb)) != null) {
            g.setColor(foreground);
            g.fillRect(x, y + height - thickness, width, thickness);
        }
    }

    protected Color getMarkerForeground(Crumb crumb) {
        Color foreground;
        if (!Registry.is((String)"editor.breadcrumbs.marker")) {
            return null;
        }
        CrumbView found = this.getCrumbView(view -> ((CrumbView)view).crumb == crumb);
        Color color = foreground = found == null ? null : found.foreground;
        if (foreground == null) {
            return null;
        }
        double alpha = Registry.doubleValue((String)"editor.breadcrumbs.marker.alpha");
        return ColorUtil.toAlpha((Color)foreground, (int)((int)(alpha * (double)foreground.getAlpha())));
    }

    protected Font getFont(Crumb crumb) {
        int style;
        Font font = this.getFont();
        if (font == null) {
            return null;
        }
        int old = font.getStyle();
        if (font != this.cache[old]) {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = i == old ? font : null;
            }
        }
        if ((style = this.getFontStyle(crumb)) == old) {
            return font;
        }
        Font cached = this.cache[style];
        if (cached != null) {
            return cached;
        }
        this.cache[style] = font = font.deriveFont(style);
        return font;
    }

    @JdkConstants.FontStyle
    protected int getFontStyle(Crumb crumb) {
        TextAttributes attributes = this.getAttributes(crumb);
        return attributes == null ? 0 : attributes.getFontType();
    }

    protected Color getForeground(Crumb crumb) {
        TextAttributes attributes = this.getAttributes(crumb);
        Color foreground = attributes == null ? null : attributes.getForegroundColor();
        return foreground != null ? foreground : this.getForeground();
    }

    protected Color getBackground(Crumb crumb) {
        TextAttributes attributes = this.getAttributes(crumb);
        return attributes == null ? null : attributes.getBackgroundColor();
    }

    protected Color getEffectColor(Crumb crumb) {
        TextAttributes attributes = this.getAttributes(crumb);
        return attributes == null ? null : attributes.getEffectColor();
    }

    protected EffectType getEffectType(Crumb crumb) {
        TextAttributes attributes = this.getAttributes(crumb);
        return attributes == null ? null : attributes.getEffectType();
    }

    protected EffectPainter getEffectPainter(EffectType type) {
        if (type == EffectType.STRIKEOUT) {
            return EffectPainter.STRIKE_THROUGH;
        }
        if (type == EffectType.WAVE_UNDERSCORE) {
            return EffectPainter.WAVE_UNDERSCORE;
        }
        if (type == EffectType.LINE_UNDERSCORE) {
            return EffectPainter.LINE_UNDERSCORE;
        }
        if (type == EffectType.BOLD_LINE_UNDERSCORE) {
            return EffectPainter.BOLD_LINE_UNDERSCORE;
        }
        if (type == EffectType.BOLD_DOTTED_LINE) {
            return EffectPainter.BOLD_DOTTED_UNDERSCORE;
        }
        return null;
    }

    protected TextAttributes getAttributes(Crumb crumb) {
        return null;
    }

    private CrumbView getCrumbView(Predicate<CrumbView> predicate) {
        for (CrumbView view : this.views) {
            if (view.crumb == null || !predicate.test(view)) continue;
            return view;
        }
        return null;
    }

    private void layout(boolean update) {
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        int scale = this.getScale();
        for (CrumbView view : this.views) {
            if (view.crumb == null) continue;
            if (update || view.font == null) {
                view.update();
            }
            view.setBounds(bounds.x, bounds.y, ((CrumbView)view).preferred.width, bounds.height, scale);
            bounds.x += ((CrumbView)view).preferred.width;
        }
    }

    private void updatePreferredSize(Dimension size, int scale) {
        Font font;
        for (CrumbView view : this.views) {
            if (view.crumb == null) continue;
            if (view.font == null) {
                view.update();
            }
            size.width += ((CrumbView)view).preferred.width;
            if (size.height >= ((CrumbView)view).preferred.height) continue;
            size.height = ((CrumbView)view).preferred.height;
        }
        if (size.height == 0 && (font = this.getFont()) != null) {
            FontMetrics fm = this.getFontMetrics(font);
            size.height = scale * 6 + (fm != null ? fm.getHeight() : font.getSize());
        }
    }

    private int getScale() {
        int size;
        Font font = this.getFont();
        if (font != null && (size = font.getSize()) > 10) {
            return size / 10;
        }
        return 1;
    }

    private static float getFontSize(Font font) {
        return font == null ? 12.0f : font.getSize2D();
    }

    private final class CrumbView {
        private final Rectangle bounds = new Rectangle();
        private final Dimension preferred = new Dimension();
        private final CrumbView parent;
        private Crumb crumb;
        private Icon icon;
        private String text;
        private Path2D path;
        private Font font;
        private Color foreground;
        private Color background;
        private Color effectColor;
        private EffectType effectType;

        CrumbView(CrumbView parent, Crumb crumb) {
            this.parent = parent;
            this.initialize(crumb);
        }

        void initialize(Crumb crumb) {
            this.crumb = crumb;
            this.icon = null;
            this.text = null;
            this.path = null;
            this.font = null;
            this.foreground = null;
            this.background = null;
            this.effectColor = null;
        }

        private void update() {
            this.icon = this.crumb.getIcon();
            this.text = this.crumb.getText();
            this.font = Breadcrumbs.this.getFont(this.crumb);
            this.foreground = Breadcrumbs.this.getForeground(this.crumb);
            this.background = Breadcrumbs.this.getBackground(this.crumb);
            this.effectType = Breadcrumbs.this.getEffectType(this.crumb);
            this.effectColor = Breadcrumbs.this.getEffectColor(this.crumb);
            if (this.foreground == null) {
                this.foreground = Breadcrumbs.this.getForeground();
            }
            if (this.font == null) {
                this.font = Breadcrumbs.this.getFont();
            }
            if (this.icon != null) {
                this.icon = IconUtil.scaleByFont(this.icon, (Component)((Object)Breadcrumbs.this), Breadcrumbs.getFontSize(this.font));
            }
            int scale = Breadcrumbs.this.getScale();
            this.preferred.width = scale * (10 + this.getLeftGap() + this.getRightGap());
            this.preferred.height = scale * 6;
            if (this.font != null && !StringUtil.isEmpty((String)this.text)) {
                FontMetrics fm = Breadcrumbs.this.getFontMetrics(this.font);
                Rectangle iconR = new Rectangle();
                Rectangle textR = new Rectangle();
                this.layout(fm, iconR, textR, new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE));
                this.preferred.width += Math.max(iconR.x + iconR.width, textR.x + textR.width) - Math.min(iconR.x, textR.x);
                this.preferred.height += Math.max(iconR.y + iconR.height, textR.y + textR.height) - Math.min(iconR.y, textR.y);
            } else if (this.icon != null) {
                this.preferred.width += this.icon.getIconWidth();
                this.preferred.height += this.icon.getIconHeight();
            }
        }

        private String layout(FontMetrics fm, Rectangle iconR, Rectangle textR, Rectangle viewR) {
            int gap = this.icon == null ? 0 : this.icon.getIconWidth() / 4;
            return SwingUtilities.layoutCompoundLabel(fm, this.text, this.icon, 0, 2, 0, 4, viewR, iconR, textR, gap);
        }

        private Rectangle getBounds(int dx, int dy) {
            return new Rectangle(this.bounds.x + dx, this.bounds.y + dy, this.bounds.width - dx - dx, this.bounds.height - dy - dy);
        }

        private void setBounds(int x, int y, int width, int height, int scale) {
            int left = scale * this.getLeftGap();
            int right = scale * this.getRightGap();
            this.bounds.setBounds(x + left, y, width - left - right, height);
            this.path = Registry.is((String)"editor.breadcrumbs.marker") ? null : this.createPath(scale, true);
        }

        private boolean contains(int x, int y) {
            return this.crumb != null && (this.path != null ? this.path.contains(x, y) : this.bounds.contains(x, y));
        }

        private void paint(Graphics2D g) {
            Rectangle bounds;
            int scale = Breadcrumbs.this.getScale();
            if (this.path != null) {
                if (this.background != null) {
                    g.setColor(this.background);
                    g.fill(this.path);
                }
                if (this.parent != null && this.parent.background == this.background && !Registry.is((String)"editor.breadcrumbs.marker")) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    float stroke = JBUI.getFontScale((float)Breadcrumbs.getFontSize(Breadcrumbs.this.getFont()));
                    int delta = (int)((double)scale * (0.3 * (double)this.getRightGap() + (double)this.getLeftGap()));
                    g2.clipRect(this.bounds.x - delta, this.bounds.y, Short.MAX_VALUE, this.bounds.height);
                    g2.setPaint(Breadcrumbs.this.getForeground());
                    if (stroke > 1.0f) {
                        g2.setStroke(new BasicStroke(stroke));
                    }
                    g2.draw(this.createPath(scale, false));
                    g2.dispose();
                }
            }
            if (this.effectType == EffectType.ROUNDED_BOX && this.effectColor != null) {
                bounds = this.getBounds(scale, scale);
                RectanglePainter.paint((Graphics2D)g, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (int)(bounds.height / 2), (Color)this.background, (Color)this.effectColor);
            } else if (this.effectType == EffectType.BOXED && this.effectColor != null) {
                bounds = this.getBounds(scale, scale);
                RectanglePainter.paint((Graphics2D)g, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (int)0, (Color)this.background, (Color)this.effectColor);
            } else if (this.background != null) {
                g.setColor(this.background);
                g.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                if (Breadcrumbs.this.isSelected(this.crumb)) {
                    Breadcrumbs.this.paintMarker(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.crumb, scale * 2);
                }
            } else if (Breadcrumbs.this.isSelected(this.crumb)) {
                Breadcrumbs.this.paintMarker(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.crumb, scale * 2);
            } else if (Breadcrumbs.this.isHovered(this.crumb)) {
                Breadcrumbs.this.paintMarker(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, this.crumb, scale);
            }
            if (this.font != null && this.foreground != null) {
                g.setFont(this.font);
                FontMetrics fm = Breadcrumbs.this.getFontMetrics(this.font);
                if (fm != null) {
                    Rectangle iconR = new Rectangle();
                    Rectangle textR = new Rectangle();
                    Rectangle viewR = this.getBounds(scale * 5, scale * 3);
                    String text = this.layout(fm, iconR, textR, viewR);
                    if (!StringUtil.isEmpty((String)text)) {
                        EffectPainter painter;
                        g.setColor(this.foreground);
                        g.drawString(text, textR.x, textR.y += fm.getAscent());
                        if (this.effectColor != null && this.effectType != null && (painter = Breadcrumbs.this.getEffectPainter(this.effectType)) != null) {
                            g.setColor(this.effectColor);
                            textR.height = painter == EffectPainter.STRIKE_THROUGH ? fm.getAscent() : fm.getDescent();
                            painter.paint(g, textR.x, textR.y, textR.width, textR.height, this.font);
                        }
                    }
                    if (this.icon != null) {
                        this.icon.paintIcon((Component)((Object)Breadcrumbs.this), g, iconR.x, iconR.y);
                    }
                }
            }
        }

        private int getLeftGap() {
            return !Registry.is((String)"editor.breadcrumbs.marker") ? Registry.intValue((String)"editor.breadcrumbs.gap.left", (int)5) : (this.parent != null ? 10 : 0);
        }

        private int getRightGap() {
            return !Registry.is((String)"editor.breadcrumbs.marker") ? Registry.intValue((String)"editor.breadcrumbs.gap.right", (int)9) : 0;
        }

        private Path2D createPath(int scale, boolean closed) {
            Path2D.Double path2 = new Path2D.Double();
            int left = scale * this.getLeftGap();
            int right = scale * this.getRightGap();
            if (this.parent != null) {
                ((Path2D)path2).moveTo(this.bounds.x - (left += right), this.bounds.y);
                ((Path2D)path2).lineTo(this.bounds.x - left + right, (double)this.bounds.y + (double)this.bounds.height * 0.5);
            } else {
                ((Path2D)path2).moveTo(this.bounds.x - left, this.bounds.y);
            }
            ((Path2D)path2).lineTo(this.bounds.x - left, this.bounds.y + this.bounds.height);
            if (closed) {
                ((Path2D)path2).lineTo(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
                ((Path2D)path2).lineTo(this.bounds.x + this.bounds.width + right, (double)this.bounds.y + (double)this.bounds.height * 0.5);
                ((Path2D)path2).lineTo(this.bounds.x + this.bounds.width, this.bounds.y);
                path2.closePath();
            }
            return path2;
        }
    }

    private final class MouseHandler
    extends MouseEventHandler {
        private MouseHandler() {
        }

        protected void handle(MouseEvent event) {
            if (!event.isConsumed()) {
                Crumb crumb = null;
                BiConsumer consumer = null;
                switch (event.getID()) {
                    case 503: 
                    case 504: {
                        crumb = Breadcrumbs.this.getCrumbAt(event.getX(), event.getY());
                    }
                    case 505: {
                        if (Breadcrumbs.this.isHovered(crumb)) break;
                        consumer = Breadcrumbs.this.hover;
                        break;
                    }
                    case 500: {
                        if (!SwingUtilities.isLeftMouseButton(event) || (crumb = Breadcrumbs.this.getCrumbAt(event.getX(), event.getY())) == null) break;
                        consumer = Breadcrumbs.this.select;
                    }
                }
                if (consumer != null) {
                    consumer.accept(crumb, event);
                    event.consume();
                    Breadcrumbs.this.layout(true);
                    Breadcrumbs.this.repaint();
                }
            }
        }
    }
}

