/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class InjectedReferenceSelectioner
extends AbstractWordSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return PsiTreeUtil.getParentOfType((PsiElement)e, PsiLanguageInjectionHost.class) != null;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement host = PsiTreeUtil.getParentOfType((PsiElement)e, PsiLanguageInjectionHost.class);
        if (host == null) {
            return Collections.emptyList();
        }
        ArrayList ranges = (ArrayList)JBIterable.of((Object[])host.getReferences()).filter(PsiFileReference.class).map(r -> r.getRangeInElement().shiftRight(r.getElement().getTextRange().getStartOffset())).filter(r -> r.getStartOffset() <= cursorOffset).addAllTo((Collection)ContainerUtil.newArrayList());
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        TextRange smallest = null;
        for (TextRange r2 : ranges) {
            if (!r2.containsOffset(cursorOffset) || smallest != null && r2.getLength() >= smallest.getLength()) continue;
            smallest = r2;
        }
        if (smallest == null) {
            return Collections.emptyList();
        }
        int endOffset = smallest.getEndOffset();
        ListIterator<TextRange> it = ranges.listIterator();
        while (it.hasNext()) {
            TextRange r3 = (TextRange)it.next();
            if (r3.getEndOffset() > cursorOffset) continue;
            it.set(TextRange.create((int)r3.getStartOffset(), (int)endOffset));
        }
        return ranges;
    }
}

