/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCommentInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TextRange> ranges;
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            TodoCommentInspection.$$$reportNull$$$0(1);
        }
        if ((ranges = TodoCommentInspection.getTodoRanges(file2)).isEmpty()) {
            return null;
        }
        SmartList result2 = new SmartList();
        THashSet comments = new THashSet();
        for (TextRange todoRange : ranges) {
            int todoStart = todoRange.getStartOffset();
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(todoStart), PsiComment.class, (boolean)false);
            if (comment == null || !comments.add((Object)comment)) continue;
            int commentStart = comment.getTextOffset();
            TextRange range = new TextRange(todoStart - commentStart, todoRange.getEndOffset() - commentStart);
            result2.add(manager.createProblemDescriptor((PsiElement)comment, range, InspectionsBundle.message((String)"todo.comment.problem.descriptor", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
        return result2.toArray(new ProblemDescriptor[result2.size()]);
    }

    private static List<TextRange> getTodoRanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(2);
        }
        TodoIndexPatternProvider todoIndexPatternProvider = TodoIndexPatternProvider.getInstance();
        assert (todoIndexPatternProvider != null);
        Collection occurrences = IndexPatternSearch.search((PsiFile)file2, (IndexPatternProvider)todoIndexPatternProvider).findAll();
        List<TextRange> ranges = occurrences.stream().map(o -> o.getTextRange()).collect(Collectors.toList());
        ranges.sort((a, b) -> Comparing.compare((int)a.getStartOffset(), (int)b.getStartOffset()));
        return ranges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/TodoCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

