/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.util.Disposer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SyncScrollSupport
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.SyncScrollSupport");
    private boolean myDuringVerticalScroll = false;
    @NotNull
    private final ArrayList<ScrollListener> myScrollers = new ArrayList();
    private boolean myEnabled = true;

    public void install(EditingSides[] sideContainers) {
        Disposer.dispose((Disposable)this);
        Editor[] editors = new Editor[sideContainers.length + 1];
        editors[0] = sideContainers[0].getEditor(FragmentSide.SIDE1);
        for (int i = 0; i < sideContainers.length; ++i) {
            EditingSides sideContainer = sideContainers[i];
            LOG.assertTrue(sideContainer.getEditor(FragmentSide.SIDE1) == editors[i]);
            editors[i + 1] = sideContainer.getEditor(FragmentSide.SIDE2);
        }
        if (editors.length == 3) {
            this.install3(editors, sideContainers);
        } else if (editors.length == 2) {
            this.install2(editors, sideContainers);
        } else {
            LOG.error(String.valueOf(editors.length));
        }
    }

    public void dispose() {
        for (ScrollListener scrollListener : this.myScrollers) {
            Disposer.dispose((Disposable)scrollListener);
        }
        this.myScrollers.clear();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void install2(@NotNull Editor[] editors, @NotNull EditingSides[] sideContainers) {
        if (editors == null) {
            SyncScrollSupport.$$$reportNull$$$0(0);
        }
        if (sideContainers == null) {
            SyncScrollSupport.$$$reportNull$$$0(1);
        }
        this.addSlavesScroller(editors[0], new ScrollingContext(FragmentSide.SIDE1, sideContainers[0], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[1], new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE2));
    }

    private void install3(@NotNull Editor[] editors, @NotNull EditingSides[] sideContainers) {
        if (editors == null) {
            SyncScrollSupport.$$$reportNull$$$0(2);
        }
        if (sideContainers == null) {
            SyncScrollSupport.$$$reportNull$$$0(3);
        }
        this.addSlavesScroller(editors[0], new ScrollingContext(FragmentSide.SIDE1, sideContainers[0], FragmentSide.SIDE2), new ScrollingContext(FragmentSide.SIDE1, sideContainers[1], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[1], new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE1), new ScrollingContext(FragmentSide.SIDE1, sideContainers[1], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[2], new ScrollingContext(FragmentSide.SIDE2, sideContainers[1], FragmentSide.SIDE2), new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE1));
    }

    private void addSlavesScroller(@NotNull Editor editor, ScrollingContext ... contexts) {
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(4);
        }
        if (contexts == null) {
            SyncScrollSupport.$$$reportNull$$$0(5);
        }
        ScrollListener scroller = new ScrollListener(contexts, editor);
        scroller.install();
        this.myScrollers.add(scroller);
    }

    private static void syncHorizontalScroll(@NotNull ScrollingContext context, @NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
        FragmentSide masterSide;
        int newScrollOffset;
        if (context == null) {
            SyncScrollSupport.$$$reportNull$$$0(6);
        }
        if (newRectangle == null) {
            SyncScrollSupport.$$$reportNull$$$0(7);
        }
        if (oldRectangle == null) {
            SyncScrollSupport.$$$reportNull$$$0(8);
        }
        if ((newScrollOffset = newRectangle.x) == oldRectangle.x) {
            return;
        }
        EditingSides sidesContainer = context.getSidesContainer();
        Editor slaveEditor = sidesContainer.getEditor((masterSide = context.getMasterSide()).otherSide());
        if (slaveEditor == null) {
            return;
        }
        SyncScrollSupport.doScrollHorizontally(slaveEditor.getScrollingModel(), newScrollOffset);
    }

    private static void syncVerticalScroll(@NotNull ScrollingContext context, @NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
        int offset;
        if (context == null) {
            SyncScrollSupport.$$$reportNull$$$0(9);
        }
        if (newRectangle == null) {
            SyncScrollSupport.$$$reportNull$$$0(10);
        }
        if (oldRectangle == null) {
            SyncScrollSupport.$$$reportNull$$$0(11);
        }
        if (newRectangle.y == oldRectangle.y) {
            return;
        }
        EditingSides sidesContainer = context.getSidesContainer();
        FragmentSide masterSide = context.getMasterSide();
        FragmentSide masterDiffSide = context.getMasterDiffSide();
        Editor master = sidesContainer.getEditor(masterSide);
        Editor slave = sidesContainer.getEditor(masterSide.otherSide());
        if (master == null || slave == null) {
            return;
        }
        if (master.isDisposed() || slave.isDisposed()) {
            return;
        }
        int masterVerticalScrollOffset = master.getScrollingModel().getVerticalScrollOffset();
        int slaveVerticalScrollOffset = slave.getScrollingModel().getVerticalScrollOffset();
        Rectangle viewRect = master.getScrollingModel().getVisibleArea();
        int middleY = viewRect.height / 3;
        if (master.getDocument().getTextLength() == 0) {
            return;
        }
        LogicalPosition masterPos = master.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
        int masterCenterLine = masterPos.line;
        int scrollToLine = sidesContainer.getLineBlocks().transform(masterDiffSide, masterCenterLine);
        if (scrollToLine < 0) {
            offset = slaveVerticalScrollOffset + newRectangle.y - oldRectangle.y;
        } else {
            int correction = (masterVerticalScrollOffset + middleY) % master.getLineHeight();
            Point point = slave.logicalPositionToXY(new LogicalPosition(scrollToLine, masterPos.column));
            offset = point.y - middleY + correction;
        }
        int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(slave) - SyncScrollSupport.getHeaderOffset(master);
        SyncScrollSupport.doScrollVertically(slave.getScrollingModel(), offset + deltaHeaderOffset);
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        JComponent header;
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(12);
        }
        return (header = editor.getHeaderComponent()) == null ? 0 : header.getHeight();
    }

    private static void doScrollVertically(@NotNull ScrollingModel model, int offset) {
        if (model == null) {
            SyncScrollSupport.$$$reportNull$$$0(13);
        }
        model.disableAnimation();
        try {
            model.scrollVertically(offset);
        }
        finally {
            model.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull ScrollingModel model, int offset) {
        if (model == null) {
            SyncScrollSupport.$$$reportNull$$$0(14);
        }
        model.disableAnimation();
        try {
            model.scrollHorizontally(offset);
        }
        finally {
            model.enableAnimation();
        }
    }

    public static void scrollEditor(@NotNull Editor editor, int logicalLine) {
        if (editor == null) {
            SyncScrollSupport.$$$reportNull$$$0(15);
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logicalLine, 0));
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
        scrollingModel.enableAnimation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sideContainers";
                break;
            }
            case 4: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRectangle";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRectangle";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/util/SyncScrollSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install2";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "install3";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addSlavesScroller";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "syncHorizontalScroll";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "syncVerticalScroll";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeaderOffset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "doScrollVertically";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "doScrollHorizontally";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ScrollingContext {
        @NotNull
        private final EditingSides mySidesContainer;
        @NotNull
        private final FragmentSide myMasterSide;
        @NotNull
        private final FragmentSide myMasterDiffSide;

        public ScrollingContext(@NotNull FragmentSide masterSide, @NotNull EditingSides sidesContainer, @NotNull FragmentSide masterDiffSide) {
            if (masterSide == null) {
                ScrollingContext.$$$reportNull$$$0(0);
            }
            if (sidesContainer == null) {
                ScrollingContext.$$$reportNull$$$0(1);
            }
            if (masterDiffSide == null) {
                ScrollingContext.$$$reportNull$$$0(2);
            }
            this.mySidesContainer = sidesContainer;
            this.myMasterSide = masterSide;
            this.myMasterDiffSide = masterDiffSide;
        }

        @NotNull
        public EditingSides getSidesContainer() {
            EditingSides editingSides = this.mySidesContainer;
            if (editingSides == null) {
                ScrollingContext.$$$reportNull$$$0(3);
            }
            return editingSides;
        }

        @NotNull
        public FragmentSide getMasterSide() {
            FragmentSide fragmentSide = this.myMasterSide;
            if (fragmentSide == null) {
                ScrollingContext.$$$reportNull$$$0(4);
            }
            return fragmentSide;
        }

        @NotNull
        public FragmentSide getMasterDiffSide() {
            FragmentSide fragmentSide = this.myMasterDiffSide;
            if (fragmentSide == null) {
                ScrollingContext.$$$reportNull$$$0(5);
            }
            return fragmentSide;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "masterSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sidesContainer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "masterDiffSide";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSidesContainer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMasterSide";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMasterDiffSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ScrollListener
    implements VisibleAreaListener,
    Disposable {
        private ScrollingContext[] myScrollContexts;
        @NotNull
        private final Editor myEditor;

        public ScrollListener(@NotNull ScrollingContext[] scrollContexts, Editor editor) {
            if (scrollContexts == null) {
                ScrollListener.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ScrollListener.$$$reportNull$$$0(1);
            }
            this.myScrollContexts = scrollContexts;
            this.myEditor = editor;
        }

        public void install() {
            this.myEditor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        }

        public void dispose() {
            this.myEditor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
            this.myScrollContexts = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!SyncScrollSupport.this.myEnabled || SyncScrollSupport.this.myDuringVerticalScroll) {
                return;
            }
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (newRectangle == null || oldRectangle == null) {
                return;
            }
            SyncScrollSupport.this.myDuringVerticalScroll = true;
            try {
                for (ScrollingContext context : this.myScrollContexts) {
                    SyncScrollSupport.syncVerticalScroll(context, newRectangle, oldRectangle);
                    SyncScrollSupport.syncHorizontalScroll(context, newRectangle, oldRectangle);
                }
            }
            finally {
                SyncScrollSupport.this.myDuringVerticalScroll = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scrollContexts";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

