/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.CustomFileTypeFactory;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.JdomKt;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportFile="filetypes")
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    private static final int VERSION = 17;
    private static final ThreadLocal<Pair<VirtualFile, FileType>> FILE_TYPE_FIXED_TEMPORARILY = new ThreadLocal();
    static final Key<FileType> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final int DETECT_BUFFER_SIZE = 8192;
    private static final String DEFAULT_IGNORED = "*.hprof;*.pyc;*.pyo;*.rbc;*.yarb;*~;.DS_Store;.git;.hg;.svn;CVS;__pycache__;_svn;vssver.scc;vssver2.scc;";
    private static boolean RE_DETECT_ASYNC;
    private final Set<FileType> myDefaultTypes = new THashSet();
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final Map<FileNameMatcher, Trinity<String, String, Boolean>> myUnresolvedRemovedMappings = new THashMap();
    private final Map<FileNameMatcher, Pair<FileType, Boolean>> myRemovedMappings = new THashMap();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private final MessageBus myMessageBus;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS;
    private final SchemeManager<FileType> mySchemeManager;
    @NonNls
    static final String FILE_SPEC = "filetypes";
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final ConcurrentPackedBitsArray packedFlags = new ConcurrentPackedBitsArray(4);
    private final AtomicInteger counterAutoDetect = new AtomicInteger();
    private final AtomicLong elapsedAutoDetect = new AtomicLong();
    boolean toLog;
    private final BoundedTaskExecutor reDetectExecutor = new BoundedTaskExecutor("FileTypeManager redetect pool", (Executor)PooledThreadExecutor.INSTANCE, 1, (Disposable)this);
    private final HashSetQueue<VirtualFile> filesToRedetect = new HashSetQueue();
    private static final int CHUNK_SIZE = 10;
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    public FileTypeManagerImpl(MessageBus bus, SchemeManagerFactory schemeManagerFactory, PropertiesComponent propertiesComponent) {
        int fileTypeChangedCounter = StringUtilRt.parseInt((String)propertiesComponent.getValue("fileTypeChangedCounter"), (int)0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        this.myMessageBus = bus;
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new NonLazySchemeProcessor<FileType, AbstractFileType>(){

            @Override
            @NotNull
            public AbstractFileType readScheme(@NotNull Element element, boolean duringLoad) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType(element, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged();
                }
                AbstractFileType abstractFileType = type;
                if (abstractFileType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return abstractFileType;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull FileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(fileType instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(fileType)) {
                    SchemeState schemeState = SchemeState.NON_PERSISTENT;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return schemeState;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(fileType)) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return schemeState;
                }
                SchemeState schemeState = ((AbstractFileType)fileType).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(5);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(6);
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                root.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!StringUtil.isEmpty((String)fileType.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root);
                Element map2 = new Element("extensionMap");
                FileTypeManagerImpl.this.writeExtensionsMap(map2, fileType, false);
                if (!map2.getChildren().isEmpty()) {
                    root.addContent(map2);
                }
                Element element = root;
                if (element == null) {
                    1.$$$reportNull$$$0(7);
                }
                return element;
            }

            @Override
            public void onSchemeDeleted(@NotNull AbstractFileType scheme2) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(8);
                }
                GuiUtils.invokeLaterIfNeeded(() -> {
                    if (scheme2 == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    Application app = ApplicationManager.getApplication();
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations(scheme2);
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged());
                }, (ModalityState)ModalityState.NON_MODAL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileType";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readScheme";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$onSchemeDeleted$2";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                Set files = ContainerUtil.map2Set(events, event -> {
                    VirtualFile filtered;
                    VirtualFile file2 = event instanceof VFileCreateEvent ? null : event.getFile();
                    VirtualFile virtualFile = filtered = file2 != null && FileTypeManagerImpl.this.wasAutoDetectedBefore(file2) && FileTypeManagerImpl.isDetectable(file2) ? file2 : null;
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() VFS event " + event + "; filtered file: " + filtered + " (file: " + file2 + "; wasAutoDetectedBefore(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.this.wasAutoDetectedBefore(file2))) + "; isDetectable(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.isDetectable(file2))) + "; file.getLength(): " + (file2 == null ? null : Long.valueOf(file2.getLength())) + "; file.isValid(): " + (file2 == null ? null : Boolean.valueOf(file2.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file2 == null ? null : Boolean.valueOf(file2.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file2 instanceof VirtualFileWithId ? FileTypeManagerImpl.readableFlags(FileTypeManagerImpl.this.packedFlags.get(((VirtualFileWithId)file2).getId())) : null) + "; file.getFileSystem():" + (file2 == null ? null : file2.getFileSystem()) + ")");
                    }
                    return filtered;
                });
                files.remove(null);
                if (FileTypeManagerImpl.this.toLog()) {
                    FileTypeManagerImpl.log("F: after() VFS events: " + events + "; files: " + files);
                }
                if (!files.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() queued to redetect: " + files);
                    }
                    HashSetQueue hashSetQueue = FileTypeManagerImpl.this.filesToRedetect;
                    synchronized (hashSetQueue) {
                        if (FileTypeManagerImpl.this.filesToRedetect.addAll((Collection)files)) {
                            FileTypeManagerImpl.this.awakeReDetectExecutor();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "after"));
            }
        });
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        this.initStandardFileTypes();
    }

    @VisibleForTesting
    void initStandardFileTypes() {
        block10: {
            FileTypeConsumer consumer = new FileTypeConsumer(){

                public void consume(@NotNull FileType fileType) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
                }

                public void consume(@NotNull FileType fileType, String extensions) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(extensions));
                }

                public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (matchers == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
                }

                public FileType getStandardFileTypeByName(@NotNull String name) {
                    StandardFileType type;
                    if (name == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return (type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name)) != null ? type.fileType : null;
                }

                private void register(@NotNull FileType fileType, @NotNull List<FileNameMatcher> fileNameMatchers) {
                    StandardFileType type;
                    if (fileType == null) {
                        3.$$$reportNull$$$0(5);
                    }
                    if (fileNameMatchers == null) {
                        3.$$$reportNull$$$0(6);
                    }
                    if ((type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName())) != null) {
                        type.matchers.addAll(fileNameMatchers);
                    } else {
                        FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fileType";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "matchers";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = FileTypeManagerImpl.ATTRIBUTE_NAME;
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fileNameMatchers";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "consume";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getStandardFileTypeByName";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "register";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            for (FileTypeFactory factory : (FileTypeFactory[])FileTypeFactory.FILE_TYPE_FACTORY_EP.getExtensions()) {
                try {
                    factory.createFileTypes(consumer);
                }
                catch (Throwable e) {
                    PluginManager.handleComponentError(e, factory.getClass().getName(), null);
                }
            }
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers, true);
            }
            if (PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr()) {
                return;
            }
            try {
                URL defaultFileTypesUrl = FileTypeManagerImpl.class.getResource("/defaultFileTypes.xml");
                if (defaultFileTypesUrl == null) break block10;
                Element defaultFileTypesElement = JdomKt.loadElement((InputStream)URLUtil.openStream((URL)defaultFileTypesUrl));
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element : e.getChildren(ELEMENT_FILETYPE)) {
                            this.loadFileType(element, true);
                        }
                        continue;
                    }
                    if (!"extensionMap".equals(e.getName())) continue;
                    this.readGlobalMappings(e);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private boolean toLog() {
        return this.toLog;
    }

    private static void log(String message) {
        LOG.debug(message + " - " + Thread.currentThread());
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.submit(() -> {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(10);
            HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
            synchronized (hashSetQueue) {
                VirtualFile file2;
                for (int i = 0; i < 10 && (file2 = (VirtualFile)this.filesToRedetect.poll()) != null; ++i) {
                    files.add(file2);
                }
            }
            if (files.size() == 10) {
                this.awakeReDetectExecutor();
            }
            this.reDetect(files);
        });
    }

    public void drainReDetectQueue() {
        try {
            this.reDetectExecutor.waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        // MONITORENTER : hashSetQueue
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>((Collection<VirtualFile>)this.filesToRedetect);
        // MONITOREXIT : hashSetQueue
        if (arrayList != null) return arrayList;
        FileTypeManagerImpl.$$$reportNull$$$0(0);
        return arrayList;
    }

    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }

    private void reDetect(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> changed = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            FileType after;
            FileType before;
            block10: {
                boolean shouldRedetect;
                boolean bl = shouldRedetect = this.wasAutoDetectedBefore(file2) && FileTypeManagerImpl.isDetectable(file2);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") " + file2.getName() + "; shouldRedetect: " + shouldRedetect);
                }
                if (!shouldRedetect) continue;
                int id = ((VirtualFileWithId)file2).getId();
                long flags = this.packedFlags.get(id);
                before = (FileType)ObjectUtils.notNull((Object)FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags), (Object)ObjectUtils.notNull((Object)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY), (Object)((Object)PlainTextFileType.INSTANCE)));
                after = this.getByFile(file2);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") prepare to redetect. flags: " + FileTypeManagerImpl.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after == null ? null : after.getName()));
                }
                if (after == null) {
                    try {
                        after = this.detectFromContentAndCache(file2);
                        break block10;
                    }
                    catch (IOException e) {
                        crashed.add(file2);
                        if (!this.toLog()) continue;
                        FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") before: " + before.getName() + "; after: crashed with " + e.getMessage() + "; now getFileType()=" + file2.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                        continue;
                    }
                }
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id, flags);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: reDetect(" + file2.getName() + ") before: " + before.getName() + "; after: " + after.getName() + "; now getFileType()=" + file2.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after) continue;
            changed.add(file2);
        }
        if (!changed.isEmpty()) {
            FileTypeManagerImpl.reparseLater(changed);
        }
        if (!crashed.isEmpty()) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> FileTypeManagerImpl.reparseLater(crashed), 10L, TimeUnit.SECONDS);
        }
    }

    private static void reparseLater(@NotNull List<VirtualFile> changed) {
        if (changed == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (changed == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(100);
            }
            FileContentUtilCore.reparseFiles((Collection)changed);
        }, ApplicationManager.getApplication().getDisposed());
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(3);
        }
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id = Math.abs(((VirtualFileWithId)file2).getId());
            return (this.packedFlags.get(id) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        StandardFileType stdFileType;
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(4);
        }
        PlainTextFileType plainTextFileType = (stdFileType = this.myStandardFileTypes.get(name)) != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(5);
        }
        return plainTextFileType;
    }

    public void initComponent() {
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(pair);
            }
        }
        for (StandardFileType pair : this.myStandardFileTypes.values()) {
            this.bindUnresolvedMappings(pair.fileType);
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileType fileType : this.mySchemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor(fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(6);
        }
        FileType fileType = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(7);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(8);
        }
        FileType type = this.myPatternsTable.findAssociatedFileType(fileName);
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(9);
        }
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(10);
        }
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(11);
        }
        FileType fileType = file2.getFileType();
        Pair<VirtualFile, FileType> old = FILE_TYPE_FIXED_TEMPORARILY.get();
        FILE_TYPE_FIXED_TEMPORARILY.set((Pair<VirtualFile, FileType>)Pair.create((Object)file2, (Object)fileType));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: freezeFileTypeTemporarilyIn(" + file2.getName() + ") to " + fileType.getName() + " in " + Thread.currentThread());
        }
        try {
            runnable2.run();
        }
        finally {
            if (old == null) {
                FILE_TYPE_FIXED_TEMPORARILY.remove();
            } else {
                FILE_TYPE_FIXED_TEMPORARILY.set(old);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: unfreezeFileType(" + file2.getName() + ") in " + Thread.currentThread());
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(12);
        }
        if ((fileType = this.getByFile(file2)) == null) {
            fileType = file2 instanceof StubVirtualFile ? UnknownFileType.INSTANCE : this.getOrDetectFromContent(file2);
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(13);
        }
        return fileType2;
    }

    @Nullable
    public FileType getByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        Pair<VirtualFile, FileType> fixedType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(14);
        }
        if ((fixedType = FILE_TYPE_FIXED_TEMPORARILY.get()) != null && ((VirtualFile)fixedType.getFirst()).equals(file2)) {
            FileType fileType2 = (FileType)fixedType.getSecond();
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") was frozen to " + fileType2.getName() + " in " + Thread.currentThread());
            }
            return fileType2;
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileType type : this.mySpecialFileTypes) {
            if (!type.isMyFileType(file2)) continue;
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + "): Special file type: " + type.getName());
            }
            return type;
        }
        fileType = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") By name file type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    @NotNull
    private FileType getOrDetectFromContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(15);
        }
        if (!FileTypeManagerImpl.isDetectable(file2)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(16);
            }
            return fileType;
        }
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id = ((VirtualFileWithId)file2).getId();
            if (id < 0) {
                FileType fileType = UnknownFileType.INSTANCE;
                if (fileType == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(17);
                }
                return fileType;
            }
            long flags = this.packedFlags.get(id);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id, flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeManagerImpl.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    FileType fileType = type;
                    if (fileType == null) {
                        FileTypeManagerImpl.$$$reportNull$$$0(18);
                    }
                    return fileType;
                }
            }
        }
        FileType fileType = (FileType)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            try {
                fileType = this.detectFromContentAndCache(file2);
            }
            catch (IOException e) {
                fileType = UnknownFileType.INSTANCE;
            }
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType.getName());
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(19);
        }
        return fileType2;
    }

    private static String readableFlags(long flags) {
        String result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte readFlagsFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(20);
        }
        DataInputStream stream = this.autoDetectedAttribute.readAttribute(file2);
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try {
            try {
                status = stream == null ? (byte)0 : stream.readByte();
                wasAutoDetectRun = stream != null;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    protected void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(21);
        }
        try (DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearCaches()");
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearPersistentAttributes()");
        }
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    @Deprecated
    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(22);
        }
        FileType fileType = file2.getFileType();
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(23);
        }
        return fileType;
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(24);
        }
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(25);
        }
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file2, flags);
        if (file2 instanceof VirtualFileWithId) {
            int id = Math.abs(((VirtualFileWithId)file2).getId());
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        FileType type;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(26);
        }
        if ((type = this.getStdFileType(fileTypeName)) == PlainTextFileType.INSTANCE && !fileTypeName.equals(type.getName())) {
            for (FileType fileType : this.mySchemeManager.getAllSchemes()) {
                if (!fileTypeName.equals(fileType.getName())) continue;
                return fileType;
            }
        }
        return type;
    }

    private static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(27);
        }
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || file2.getLength() == 0L) {
            return false;
        }
        return file2.getFileSystem() instanceof FileSystemInterface;
    }

    private void processFirstBytes(@NotNull InputStream stream, int fileLength, int firstChunkLength, @NotNull PairConsumer<ByteSequence, Getter<ByteSequence>> processor2) throws IOException {
        if (stream == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(28);
        }
        if (processor2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(29);
        }
        byte[] bytes = FileUtilRt.getThreadLocalBuffer();
        assert (bytes.length >= firstChunkLength) : "Cannot process more than " + bytes.length + " in one call, requested:" + firstChunkLength;
        int n = this.readSafely(stream, bytes, 0, firstChunkLength);
        if (n <= 0) {
            return;
        }
        ByteSequence firstChunk = new ByteSequence(bytes, 0, n);
        processor2.consume((Object)firstChunk, () -> {
            int read2;
            if (stream == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(99);
            }
            if (fileLength <= n) {
                return firstChunk;
            }
            byte[] buffer = bytes.length >= fileLength ? bytes : ArrayUtil.realloc((byte[])bytes, (int)fileLength);
            try {
                read2 = this.readSafely(stream, buffer, n, fileLength - n);
            }
            catch (IOException e) {
                return null;
            }
            if (read2 <= 0) {
                return null;
            }
            return new ByteSequence(buffer, 0, n + read2);
        });
    }

    private int readSafely(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int n = stream.read(buffer, offset, length);
        if (n <= 0) {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): inputStream.read() returned " + n + "; retrying with read action. stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            n = (Integer)ApplicationManager.getApplication().runReadAction(() -> stream.read(buffer, offset, length));
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): under read action inputStream.read() returned " + n + "; stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(30);
        }
        long start = System.currentTimeMillis();
        Ref result2 = new Ref((Object)UnknownFileType.INSTANCE);
        InputStream inputStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);
        try {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + FileTypeManagerImpl.streamInfo(inputStream));
            }
            this.processFirstBytes(inputStream, (int)file2.getLength(), 8192, (PairConsumer<ByteSequence, Getter<ByteSequence>>)((PairConsumer)(firstChunk, entireFileBytesGetter) -> {
                if (file2 == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(98);
                }
                this.detect(file2, (Ref<FileType>)result2, (ByteSequence)firstChunk);
                if (result2.get() == UnknownFileType.INSTANCE) {
                    return;
                }
                int firstChunkLength = firstChunk.getLength();
                ByteSequence entireFile = (ByteSequence)entireFileBytesGetter.get();
                if (entireFile != null && entireFile.getLength() != firstChunkLength) {
                    this.detect(file2, (Ref<FileType>)result2, entireFile);
                }
            }));
        }
        finally {
            block33: {
                try {
                    if (!this.toLog()) break block33;
                    try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                        byte[] buffer = new byte[50];
                        int n = newStream.read(buffer, 0, buffer.length);
                        FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + ((FileType)result2.get()).getName() + "; stream: " + FileTypeManagerImpl.streamInfo(inputStream) + "; newStream: " + FileTypeManagerImpl.streamInfo(newStream) + "; read: " + n + "; buffer: " + Arrays.toString(buffer));
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        FileType fileType = (FileType)result2.get();
        if (LOG.isDebugEnabled()) {
            LOG.debug(file2 + "; type=" + fileType.getDescription() + "; " + this.counterAutoDetect);
        }
        this.cacheAutoDetectedFileType(file2, fileType);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start;
        this.elapsedAutoDetect.addAndGet(elapsed);
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(31);
        }
        return fileType2;
    }

    private void detect(@NotNull VirtualFile file2, Ref<FileType> result2, ByteSequence byteSequence) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(32);
        }
        LoadTextUtil.processTextFromBinaryPresentationOrNull(byteSequence.getBytes(), byteSequence.getOffset(), byteSequence.getOffset() + byteSequence.getLength(), file2, true, true, (FileType)PlainTextFileType.INSTANCE, (NullableConsumer<CharSequence>)((NullableConsumer)text -> {
            if (file2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(97);
            }
            Object[] detectors = (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME);
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): byteSequence.length=" + byteSequence.getLength() + "; isText=" + (text != null) + "; text='" + (text == null ? null : StringUtil.first((CharSequence)text, (int)100, (boolean)true)) + "', detectors=" + Arrays.toString(detectors));
            }
            Object detected = null;
            for (FileTypeRegistry.FileTypeDetector fileTypeDetector : detectors) {
                try {
                    detected = fileTypeDetector.detect(file2, byteSequence, text);
                }
                catch (Exception e) {
                    LOG.error("Detector " + fileTypeDetector + " (" + fileTypeDetector.getClass() + ") exception occurred:", (Throwable)e);
                }
                if (detected == null) continue;
                if (!this.toLog()) break;
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + fileTypeDetector + " type as " + detected.getName());
                break;
            }
            if (detected == null) {
                Object object = detected = text == null ? UnknownFileType.INSTANCE : PlainTextFileType.INSTANCE;
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                }
            }
            result2.set(detected);
        }));
    }

    private static Object streamInfo(InputStream stream) throws IOException {
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeManagerImpl.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel + ", channel.size=" + (channel == null ? null : Long.valueOf(channel.size())) + ", file.exists=" + file2.exists() + ", file.content='" + FileUtil.loadFile((File)file2) + "')";
        }
        return stream;
    }

    public boolean isFileOfType(@NotNull VirtualFile file2, @NotNull FileType type) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(33);
        }
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(34);
        }
        if (type instanceof FileTypeIdentifiableByVirtualFile) {
            return ((FileTypeIdentifiableByVirtualFile)type).isMyFileType(file2);
        }
        return this.getFileTypeByFileName(file2.getNameSequence()) == type;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(35);
        }
        FileType fileType = this.getFileTypeByFileName("IntelliJ_IDEA_RULES." + extension);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(36);
        }
        return fileType;
    }

    @Override
    public void registerFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(37);
        }
        this.registerFileType(fileType, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(38);
        }
        if (defaultAssociations == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (type == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(95);
            }
            if (defaultAssociations == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(96);
            }
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, defaultAssociations, true);
            this.fireFileTypesChanged();
        });
    }

    @Override
    public void unregisterFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(94);
            }
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType);
            this.fireFileTypesChanged();
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(41);
        }
        this.myPatternsTable.removeAllAssociations(fileType);
        this.mySchemeManager.removeScheme(fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        List<FileType> fileTypes = this.mySchemeManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(new FileType[fileTypes.size()]);
        if (fileTypeArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(42);
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        int index;
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(43);
        }
        if ((index = fileName.lastIndexOf(46)) < 0) {
            if ("" == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(44);
            }
            return "";
        }
        String string = fileName.substring(index + 1);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set<String> masks = this.myIgnoredPatterns.getIgnoreMasks();
        String string = masks.isEmpty() ? "" : StringUtil.join(masks, (String)";") + ";";
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(46);
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(47);
        }
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list2);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(48);
        }
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(49);
        }
        return this.myIgnoredPatterns.isIgnored(name);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(50);
        }
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(51);
        }
        String[] stringArray = this.myPatternsTable.getAssociatedExtensions(type);
        if (stringArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(52);
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(53);
        }
        List<FileNameMatcher> list2 = this.myPatternsTable.getAssociations(type);
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(54);
        }
        return list2;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(55);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(56);
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(57);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(58);
        }
        this.removeAssociation(type, matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.clearCaches();
        this.clearPersistentAttributes();
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener2) {
        if (listener2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(59);
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(TOPIC, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener2) {
        MessageBusConnection connection;
        if (listener2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(60);
        }
        if ((connection = this.myAdapters.remove(listener2)) != null) {
            connection.disconnect();
        }
    }

    public void loadState(Element state2) {
        int savedVersion = StringUtilRt.parseInt((String)state2.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element : state2.getChildren()) {
            if (element.getName().equals(ELEMENT_IGNORE_FILES)) {
                this.myIgnoredPatterns.setIgnoreMasks(element.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(element.getName())) continue;
            this.readGlobalMappings(element);
        }
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        this.myIgnoredFileCache.clearCache();
        String counter = JDOMExternalizer.readString((Element)state2, (String)"fileTypeChangedCounter");
        if (counter != null) {
            this.fileTypeChangedCount.set(StringUtilRt.parseInt((String)counter, (int)0));
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        if (maskToRemove == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(61);
        }
        LinkedHashSet<String> masks = new LinkedHashSet<String>(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(62);
        }
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e)) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            if (type != null) {
                FileType newFileType;
                if (PlainTextFileType.INSTANCE == type && (newFileType = this.myPatternsTable.findAssociatedFileType(matcher)) != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)newFileType, (Object)false));
                }
                this.associate(type, matcher, false);
                continue;
            }
            this.myUnresolvedMappings.put(matcher, (String)association.getSecond());
        }
        List<Trinity<FileNameMatcher, String, Boolean>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Trinity<FileNameMatcher, String, Boolean> trinity : removedAssociations) {
            FileType type = this.getFileTypeByName((String)trinity.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)trinity.getFirst();
            if (type != null) {
                this.removeAssociation(type, matcher, false);
                continue;
            }
            this.myUnresolvedRemovedMappings.put(matcher, (Trinity<String, String, Boolean>)Trinity.create((Object)trinity.getSecond(), (Object)this.myUnresolvedMappings.get(matcher), (Object)trinity.getThird()));
        }
    }

    private void addIgnore(@NonNls @NotNull String ignoreMask) {
        if (ignoreMask == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(63);
        }
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations(fileType)) {
                FileType defaultFileType = this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations(fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String ignoreFiles;
        Element state2 = new Element("state");
        Set<String> masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            ignoreFiles = "";
        } else {
            Object[] strings = ArrayUtil.toStringArray(masks);
            Arrays.sort(strings);
            ignoreFiles = StringUtil.join((String[])strings, (String)";") + ";";
        }
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state2.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element map2 = new Element("extensionMap");
        ArrayList<FileType> notExternalizableFileTypes = new ArrayList<FileType>();
        for (FileType type : this.mySchemeManager.getAllSchemes()) {
            if (type instanceof AbstractFileType && !this.myDefaultTypes.contains(type)) continue;
            notExternalizableFileTypes.add(type);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            Collections.sort(notExternalizableFileTypes, Comparator.comparing(FileType::getName));
            for (FileType type : notExternalizableFileTypes) {
                this.writeExtensionsMap(map2, type, true);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            FileNameMatcher[] unresolvedMappingKeys = this.myUnresolvedMappings.keySet().toArray(new FileNameMatcher[this.myUnresolvedMappings.size()]);
            Arrays.sort(unresolvedMappingKeys, Comparator.comparing(FileNameMatcher::getPresentableString));
            for (FileNameMatcher fileNameMatcher : unresolvedMappingKeys) {
                Element content = AbstractFileType.writeMapping(this.myUnresolvedMappings.get(fileNameMatcher), fileNameMatcher, true);
                if (content == null) continue;
                map2.addContent(content);
            }
        }
        if (!map2.getChildren().isEmpty()) {
            state2.addContent(map2);
        }
        if (!state2.getChildren().isEmpty()) {
            state2.setAttribute(ATTRIBUTE_VERSION, String.valueOf(17));
        }
        Element element = state2;
        if (element == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(64);
        }
        return element;
    }

    private void writeExtensionsMap(@NotNull Element map2, @NotNull FileType type, boolean specifyTypeName) {
        Element content;
        if (map2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(65);
        }
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(66);
        }
        List<FileNameMatcher> associations = this.myPatternsTable.getAssociations(type);
        THashSet defaultAssociations = new THashSet(this.myInitialAssociations.getAssociations(type));
        for (FileNameMatcher matcher : associations) {
            if (defaultAssociations.contains(matcher)) {
                defaultAssociations.remove(matcher);
                continue;
            }
            if (!FileTypeManagerImpl.shouldSave(type) || (content = AbstractFileType.writeMapping(type.getName(), matcher, specifyTypeName)) == null) continue;
            map2.addContent(content);
        }
        for (FileNameMatcher matcher : defaultAssociations) {
            content = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName, this.isApproved(matcher));
            if (content == null) continue;
            map2.addContent(content);
        }
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        Pair<FileType, Boolean> pair;
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(67);
        }
        return (pair = this.myRemovedMappings.get(matcher)) != null && (Boolean)pair.getSecond() != false;
    }

    @Nullable
    private FileType getFileTypeByName(@NotNull String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(68);
        }
        return this.mySchemeManager.findSchemeByName(name);
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited) {
        if (semicolonDelimited == null) {
            List<FileNameMatcher> list2 = Collections.emptyList();
            if (list2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(69);
            }
            return list2;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list3 = new ArrayList<FileNameMatcher>(semicolonDelimited.length() / "py;".length());
        while (tokenizer.hasMoreTokens()) {
            list3.add((FileNameMatcher)new ExtensionFileNameMatcher(tokenizer.nextToken().trim()));
        }
        ArrayList<FileNameMatcher> arrayList = list3;
        if (arrayList == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(70);
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers, boolean addScheme) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(71);
        }
        if (matchers == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(72);
        }
        if (addScheme) {
            this.mySchemeManager.addScheme(fileType);
        }
        for (FileNameMatcher matcher : matchers) {
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myInitialAssociations.addAssociation(matcher, fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)fileType), FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void bindUnresolvedMappings(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(73);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedRemovedMappings.keySet())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            if (!Comparing.equal((String)((String)trinity.getFirst()), (String)fileType.getName())) continue;
            this.removeAssociation(fileType, matcher, false);
            this.myUnresolvedRemovedMappings.remove(matcher);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private FileType loadFileType(@NotNull Element typeElement, boolean isDefault) {
        FileType type;
        if (typeElement == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(74);
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        String extensionsStr = StringUtil.nullize((String)typeElement.getAttributeValue("extensions"));
        if (isDefault && extensionsStr != null) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileType fileType = type = isDefault ? this.getFileTypeByName(fileTypeName) : null;
        if (type != null) {
            FileType fileType2 = type;
            if (fileType2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(75);
            }
            return fileType2;
        }
        Element element = typeElement.getChild("highlighting");
        if (element == null) {
            CustomFileTypeFactory factory;
            void var11_13;
            CustomFileTypeFactory[] customFileTypeFactoryArray = (CustomFileTypeFactory[])CustomFileTypeFactory.EP_NAME.getExtensions();
            int n = customFileTypeFactoryArray.length;
            boolean i = false;
            while (var11_13 < n && (type = (factory = customFileTypeFactoryArray[var11_13]).createFileType(typeElement)) == null) {
                ++var11_13;
            }
            if (type == null) {
                type = new UserBinaryFileType();
            }
        } else {
            SyntaxTable table = AbstractFileType.readSyntaxTable(element);
            type = new AbstractFileType(table);
            ((AbstractFileType)type).initSupport();
        }
        FileTypeManagerImpl.setFileTypeAttributes((UserFileType)type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.parse(extensionsStr), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild("extensionMap");
            if (extensions != null) {
                for (Pair<FileNameMatcher, String> pair : AbstractFileType.readAssociations(extensions)) {
                    this.associate(type, (FileNameMatcher)pair.getFirst(), false);
                }
                for (Trinity trinity : AbstractFileType.readRemovedAssociations(extensions)) {
                    this.removeAssociation(type, (FileNameMatcher)trinity.getFirst(), false);
                }
            }
        }
        FileType fileType3 = type;
        if (fileType3 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(76);
        }
        return fileType3;
    }

    @Nullable
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(77);
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(extension);
        }
        return builder == null ? null : builder.toString();
    }

    private static void setFileTypeAttributes(@NotNull UserFileType fileType, @Nullable String name, @Nullable String description, @Nullable String iconPath) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(78);
        }
        if (!StringUtil.isEmptyOrSpaces((String)iconPath)) {
            fileType.setIcon(IconLoader.getIcon((String)iconPath));
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name != null) {
            fileType.setName(name);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(79);
        }
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    @NotNull
    FileTypeAssocTable getExtensionMap() {
        FileTypeAssocTable<FileType> fileTypeAssocTable = this.myPatternsTable;
        if (fileTypeAssocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(80);
        }
        return fileTypeAssocTable;
    }

    void setPatternsTable(@NotNull Set<FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        if (fileTypes == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(81);
        }
        if (assocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(82);
        }
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemeManager.removeScheme(existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemeManager.addScheme(fileType);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
    }

    public void associate(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(83);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(84);
        }
        if (!this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(85);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(86);
        }
        if (this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(87);
        }
        if ((type = file2.getFileType()) == UnknownFileType.INSTANCE) {
            type = FileTypeChooser.associateFileType(file2.getName());
        }
        return type;
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(88);
        }
        if (project == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(89);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        FileType fileType;
        if (pair == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(90);
        }
        if ((fileType = pair.fileType) == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType, matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType, (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull FileType fileType, @NotNull FileNameMatcher matcher) {
        String typeName;
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(91);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(92);
        }
        if ((typeName = this.myUnresolvedMappings.get(matcher)) != null && !typeName.equals(fileType.getName())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)fileType, (Object)(trinity != null && (Boolean)trinity.third != false ? 1 : 0)));
            this.myUnresolvedMappings.remove(matcher);
        }
    }

    @NotNull
    Map<FileNameMatcher, Pair<FileType, Boolean>> getRemovedMappings() {
        Map<FileNameMatcher, Pair<FileType, Boolean>> map2 = this.myRemovedMappings;
        if (map2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(93);
        }
        return map2;
    }

    void clearForTests() {
        for (StandardFileType fileType : this.myStandardFileTypes.values()) {
            this.myPatternsTable.removeAllAssociations(fileType.fileType);
        }
        this.myStandardFileTypes.clear();
        this.myUnresolvedMappings.clear();
        this.mySchemeManager.setSchemes(Collections.emptyList());
    }

    public void dispose() {
        LOG.info("FileTypeManager: " + this.counterAutoDetect + " auto-detected files\nElapsed time on auto-detect: " + this.elapsedAutoDetect + " ms");
    }

    static {
        List strings = StringUtil.split((String)DEFAULT_IGNORED, (String)";");
        for (int i = 0; i < strings.size(); ++i) {
            String prev;
            String string = (String)strings.get(i);
            String string2 = prev = i == 0 ? "" : (String)strings.get(i - 1);
            assert (prev.compareTo(string) < 0) : "DEFAULT_IGNORED must be sorted, but got: '" + prev + "' >= '" + string + "'";
        }
        RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
        FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changed";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 50: 
            case 87: 
            case 88: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 49: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 6: 
            case 8: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 25: 
            case 37: 
            case 40: 
            case 41: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 83: 
            case 85: 
            case 91: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 28: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 34: 
            case 38: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 66: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 39: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAssociations";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_LIST;
                break;
            }
            case 56: 
            case 58: 
            case 67: 
            case 84: 
            case 86: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maskToRemove";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreMask";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimited";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocTable";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetectFromContent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileTypeFromContent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContentAndCache";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesList";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileType";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMap";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reDetect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reparseLater";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wasAutoDetectedBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyIn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getByFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrDetectFromContent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readFlagsFromCache";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeFlagsToCache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "detectFileTypeFromContent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cacheAutoDetectedFileType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDetectable";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processFirstBytes";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContentAndCache";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFileOfType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeWithoutNotification";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 55: 
            case 56: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 57: 
            case 58: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addFileTypeListener";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "removeFileTypeListener";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "unignoreMask";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "readGlobalMappings";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addIgnore";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "writeExtensionsMap";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isApproved";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByName";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeWithoutNotification";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "bindUnresolvedMappings";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "loadFileType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setFileTypeAttributes";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "shouldSave";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setPatternsTable";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMappings";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMapping";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "lambda$unregisterFileType$8";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerFileType$7";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detect$6";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detectFromContentAndCache$5";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFirstBytes$3";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reparseLater$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers) {
            if (fileType == null) {
                StandardFileType.$$$reportNull$$$0(0);
            }
            if (matchers == null) {
                StandardFileType.$$$reportNull$$$0(1);
            }
            this.fileType = fileType;
            this.matchers = matchers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matchers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

