/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "addPrimaryModuleDependency", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "newModule", "attachModule", "", "imlFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "findMainModule", "", "projectDir", "Ljava/nio/file/Path;", "updateVcsMapping", "primaryModule", "addedModuleContentRoot", "lang-impl"})
public final class ModuleAttachProcessorKt {
    private static final Logger LOG = Logger.getInstance(ModuleAttachProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean findMainModule(Project project, Path projectDir, ProjectOpenedCallback callback) {
        Path path = projectDir;
        Function1 filter$iv = findMainModule.1.INSTANCE;
        try {
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                for (Path file2 : it) {
                    VirtualFile virtualFile;
                    VirtualFile it2;
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)file2));
                    if (virtualFile2 == null) continue;
                    VirtualFile virtualFile3 = it2 = (virtualFile = virtualFile2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                    ModuleAttachProcessorKt.attachModule(project, virtualFile3, callback);
                    boolean bl = true;
                    return bl;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        return false;
    }

    private static final void attachModule(Project project, VirtualFile imlFile, ProjectOpenedCallback callback) {
        try {
            VirtualFile dotIdeaDir;
            Module newModule;
            ModifiableModuleModel model$iv;
            Project $receiver$iv = project;
            ModifiableModuleModel $receiver = model$iv = ModuleManager.getInstance((Project)$receiver$iv).getModifiableModel();
            Module result$iv = $receiver.loadModule(imlFile.getPath());
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(model$iv){
                final /* synthetic */ ModifiableModuleModel $model$inlined;
                {
                    this.$model$inlined = modifiableModuleModel;
                }

                public final T compute() {
                    this.$model$inlined.commit();
                    return (T)Unit.INSTANCE;
                }
            });
            Module module2 = result$iv;
            Module module3 = ModuleManager.getInstance((Project)project).findModuleByName(module2.getName());
            if (module3 == null) {
                Intrinsics.throwNpe();
            }
            Module module4 = newModule = module3;
            Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"newModule");
            Module primaryModule = ModuleAttachProcessorKt.addPrimaryModuleDependency(project, module4);
            if (primaryModule != null && (dotIdeaDir = imlFile.getParent()) != null) {
                VirtualFile virtualFile = dotIdeaDir.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"dotIdeaDir.parent");
                ModuleAttachProcessorKt.updateVcsMapping(primaryModule, virtualFile);
            }
            ProjectOpenedCallback projectOpenedCallback = callback;
            if (projectOpenedCallback != null) {
                projectOpenedCallback.projectOpened(project, newModule);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((Project)project, (String)("Cannot attach project: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static final void updateVcsMapping(Module primaryModule, VirtualFile addedModuleContentRoot) {
        AbstractVcs vcs;
        VirtualFile[] contentRoots;
        Project project = primaryModule.getProject();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        List mappings = vcsManager.getDirectoryMappings();
        if (mappings.size() == 1 && ((Object[])(contentRoots = ModuleRootManager.getInstance((Module)primaryModule).getContentRoots())).length == 1 && FileUtil.filesEqual((File)new File(contentRoots[0].getPath()), (File)new File(((VcsDirectoryMapping)mappings.get(0)).getDirectory())) && (vcs = vcsManager.findVersioningVcs(addedModuleContentRoot)) != null && Intrinsics.areEqual((Object)vcs.getName(), (Object)((VcsDirectoryMapping)mappings.get(0)).getVcs())) {
            vcsManager.setDirectoryMappings(CollectionsKt.listOf((Object)new VcsDirectoryMapping("", vcs.getName())));
            return;
        }
        AbstractVcs vcs2 = vcsManager.findVersioningVcs(addedModuleContentRoot);
        if (vcs2 != null) {
            ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(mappings);
            newMappings.add(new VcsDirectoryMapping(addedModuleContentRoot.getPath(), vcs2.getName()));
            vcsManager.setDirectoryMappings((List)newMappings);
        }
    }

    private static final Module addPrimaryModuleDependency(Project project, Module newModule) {
        Module module2 = ModuleAttachProcessor.Companion.getPrimaryModule(project);
        if (module2 != null && module2 != newModule) {
            ModuleRootModificationUtil.addDependency((Module)module2, (Module)newModule);
            return module2;
        }
        return null;
    }

    public static final /* synthetic */ boolean access$findMainModule(@NotNull Project project, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback) {
        return ModuleAttachProcessorKt.findMainModule(project, projectDir, callback);
    }
}

