/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.reflect;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.SmartList;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.ConvertAnnotationImpl;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DomExtensionImpl
implements DomExtension {
    public static final Key<DomAnchor> KEY_DOM_DECLARATION = Key.create((String)"DOM_DECLARATION");
    public static final Key<List<DomExtender>> DOM_EXTENDER_KEY = Key.create((String)"Dom.Extender");
    public static final Key<SmartPsiElementPointer<?>> DECLARING_ELEMENT_KEY = Key.create((String)"Dom.Extension.PsiDeclaration");
    private final XmlName myXmlName;
    private final Type myType;
    private Converter myConverter;
    private final List<Annotation> myCustomAnnos = new SmartList();
    private boolean mySoft;
    private int myCount = 1;
    private Map myUserMap;
    private CustomDomChildrenDescription.TagNameDescriptor myTagNameDescriptor = CustomDomChildrenDescription.AttributeDescriptor.EMPTY;
    private CustomDomChildrenDescription.AttributeDescriptor myAttributesDescriptor;

    public DomExtensionImpl(Type type, XmlName xmlName) {
        this.myType = type;
        this.myXmlName = xmlName;
    }

    public void setTagNameDescriptor(CustomDomChildrenDescription.TagNameDescriptor tagNameDescriptor) {
        this.myTagNameDescriptor = tagNameDescriptor;
    }

    public CustomDomChildrenDescription.TagNameDescriptor getTagNameDescriptor() {
        return this.myTagNameDescriptor;
    }

    public CustomDomChildrenDescription.AttributeDescriptor getAttributesDescriptor() {
        return this.myAttributesDescriptor;
    }

    public void setAttributesDescriptor(CustomDomChildrenDescription.AttributeDescriptor attributesDescriptor) {
        this.myAttributesDescriptor = attributesDescriptor;
    }

    @NotNull
    public XmlName getXmlName() {
        XmlName xmlName = this.myXmlName;
        if (xmlName == null) {
            DomExtensionImpl.$$$reportNull$$$0(0);
        }
        return xmlName;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            DomExtensionImpl.$$$reportNull$$$0(1);
        }
        return type;
    }

    public DomExtension setDeclaringElement(@NotNull DomElement declaringElement) {
        if (declaringElement == null) {
            DomExtensionImpl.$$$reportNull$$$0(2);
        }
        this.putUserData(KEY_DOM_DECLARATION, DomAnchorImpl.createAnchor(declaringElement, true));
        return this;
    }

    public DomExtension setDeclaringElement(@NotNull PsiElement declaringElement) {
        if (declaringElement == null) {
            DomExtensionImpl.$$$reportNull$$$0(3);
        }
        this.putUserData(DECLARING_ELEMENT_KEY, SmartPointerManager.getInstance((Project)declaringElement.getProject()).createSmartPsiElementPointer(declaringElement));
        return this;
    }

    public DomExtension setConverter(@NotNull Converter converter2) {
        if (converter2 == null) {
            DomExtensionImpl.$$$reportNull$$$0(4);
        }
        return this.setConverter(converter2, false);
    }

    public final DomExtension setConverter(@NotNull Converter converter2, boolean soft) {
        if (converter2 == null) {
            DomExtensionImpl.$$$reportNull$$$0(5);
        }
        this.myConverter = converter2;
        this.mySoft = soft;
        return this;
    }

    public DomExtension addCustomAnnotation(@NotNull Annotation anno) {
        if (anno == null) {
            DomExtensionImpl.$$$reportNull$$$0(6);
        }
        this.myCustomAnnos.add(anno);
        return this;
    }

    public <T> void putUserData(Key<T> key, T value) {
        if (this.myUserMap == null) {
            this.myUserMap = new THashMap();
        }
        this.myUserMap.put(key, value);
    }

    public DomExtension addExtender(DomExtender extender) {
        if (this.myUserMap == null || !this.myUserMap.containsKey(DOM_EXTENDER_KEY)) {
            this.putUserData(DOM_EXTENDER_KEY, new SmartList());
        }
        ((List)this.myUserMap.get(DOM_EXTENDER_KEY)).add(extender);
        return this;
    }

    public final DomExtensionImpl setCount(int count) {
        this.myCount = count;
        return this;
    }

    public final int getCount() {
        return this.myCount;
    }

    public final <T extends DomChildDescriptionImpl> T addAnnotations(T t) {
        t.setUserMap(this.myUserMap);
        if (this.myConverter != null) {
            t.addCustomAnnotation((Annotation)((Object)new ConvertAnnotationImpl(this.myConverter, this.mySoft)));
        }
        for (Annotation anno : this.myCustomAnnos) {
            t.addCustomAnnotation(anno);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/reflect/DomExtensionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/reflect/DomExtensionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDeclaringElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setConverter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCustomAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

