/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.DefinitionWriter;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.framework.XMIMultiplicity;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

class ObjectDefWriter
extends DefinitionWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String ELEMENT_PROPERTIES = "%XMI.element.att;";
    protected static final String LINK_PROPERTIES = "%XMI.link.att;";

    public ObjectDefWriter(Object object) {
        super(object);
    }

    protected void writeCommentAndDecls(int n, int n2) throws Exception {
        Object object;
        Object object2 = this.getDefinition();
        PrintXML.printComment("CLASS: " + this.stripNamespace(this.wrapper.getXMIName(object2)), true);
        PrintXML.printBlankLine();
        Collection collection = this.wrapper.getFeatures(object2);
        Iterator iterator = this.wrapper.getProperties(collection).iterator();
        while (iterator.hasNext()) {
            object = WriterFactory.makeClassPropertyWriter(iterator.next(), this.wrapper, this.getDTD().getXMIVersion(), "DTD");
            ((DefinitionWriter)object).setDTD(this.getDTD());
            ((DefinitionWriter)object).setWrapper(this.wrapper);
            ((DefinitionWriter)object).write(n, n2);
        }
        object = this.wrapper.getLinks(collection).iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (this.wrapper.getType(e) == 4) continue;
            DefinitionWriter definitionWriter = WriterFactory.makeClassLinkWriter(e, this.wrapper, this.getDTD().getXMIVersion(), "DTD");
            definitionWriter.setDTD(this.getDTD());
            definitionWriter.setWrapper(this.wrapper);
            definitionWriter.write(n, n2);
        }
    }

    public void write(int n, int n2) throws Exception {
        Object object;
        super.write(n, n2);
        this.writeCommentAndDecls(n, n2);
        Object object2 = this.getDefinition();
        String string = "";
        Collection collection = this.wrapper.getAllFeatures(object2);
        Iterator iterator = this.wrapper.getProperties(collection).iterator();
        while (iterator.hasNext()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + this.stripNamespace(this.wrapper.getFullName(iterator.next(), 500)) + "?";
        }
        if (!string.equals("")) {
            string = string + ", ";
        }
        Iterator iterator2 = this.wrapper.getLinks(collection).iterator();
        string = string + "XMI.extension*";
        while (iterator2.hasNext()) {
            object = iterator2.next();
            string = string + ", " + this.stripNamespace(this.wrapper.getFullName(object, 500)) + XMIMultiplicity.convert(this.wrapper, object, true);
        }
        string = "(" + string + ")?";
        object = new Vector(2);
        ((Vector)object).addElement((String)ELEMENT_PROPERTIES);
        ((Vector)object).addElement(LINK_PROPERTIES);
        PrintXML.printElementDecl(this.stripNamespace(this.wrapper.getFullName(object2, 500)), string, null, (Vector)object, n, n2);
    }
}

