/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.activity;

import com.baselet.control.enums.Direction;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.old.activity.Connector;
import com.baselet.element.old.activity.Element;
import com.baselet.element.old.activity.StartElement;
import java.awt.Graphics2D;
import java.awt.Point;

public class Fork
extends StartElement {
    private int h = (int)(4.0f * this.getZoom());
    private int pad = (int)(20.0f * this.getZoom());
    private int w = (int)(80.0f * this.getZoom());
    private int con_pad = (int)(10.0f * this.getZoom());
    private Integer current_left_x;
    private Integer current_right_x;

    public Fork(DiagramHandler handler, Graphics2D g, String id) {
        super(handler, g, (int)(10.0f * handler.getZoomFactor()), id == null ? "Fork" : id);
        this.setHeight(this.h + this.pad);
        this.setWidth(this.w);
    }

    @Override
    public void paint() {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        this.getGraphics().fillRect(x - this.w / 2, y - (this.h + this.pad) / 2, this.w, (int)(4.0f * this.getZoom()));
    }

    @Override
    public boolean arrowIn() {
        return true;
    }

    @Override
    protected Point getNonStdConnectIn(Direction dir) {
        Point c = this.getConnect(Direction.UP);
        if (dir.equals((Object)Direction.LEFT)) {
            c.x -= (int)(10.0f * this.getZoom());
        } else if (dir.equals((Object)Direction.RIGHT)) {
            c.x += (int)(10.0f * this.getZoom());
        }
        if (this.arrowIn()) {
            Connector.drawArrow(this.getGraphics(), this.getZoom(), c.x, c.y - (int)(10.0f * this.getZoom()), c.x, c.y);
        } else {
            this.getGraphics().drawLine(c.x, c.y - (int)(10.0f * this.getZoom()), c.x, c.y);
        }
        c.y -= (int)(10.0f * this.getZoom());
        return c;
    }

    @Override
    protected Point getNonStdConnectOut(Direction dir) {
        Point c = this.getConnect(dir);
        if (dir.equals((Object)Direction.LEFT)) {
            this.getGraphics().drawLine(c.x - (int)(10.0f * this.getZoom()), c.y + (int)(3.0f * this.getZoom()), c.x, c.y);
            c.x -= (int)(10.0f * this.getZoom());
            c.y += (int)(3.0f * this.getZoom());
        } else if (dir.equals((Object)Direction.RIGHT)) {
            this.getGraphics().drawLine(c.x + (int)(10.0f * this.getZoom()), c.y + (int)(3.0f * this.getZoom()), c.x, c.y);
            c.x += (int)(10.0f * this.getZoom());
            c.y += (int)(3.0f * this.getZoom());
        }
        return c;
    }

    @Override
    protected Point getConnect(Direction dir) {
        Point c = (Point)this.getPosition().clone();
        if (this.current_left_x == null) {
            this.current_right_x = this.current_left_x = Integer.valueOf(this.getPosition().x);
        }
        if (dir == Direction.UP) {
            c.y -= (this.pad + this.h) / 2;
        } else if (dir == Direction.DOWN) {
            c.y += (this.h - this.pad) / 2;
        } else if (dir == Direction.LEFT) {
            if (c.x - this.current_left_x < this.w / 2 - this.con_pad) {
                this.current_left_x = this.current_left_x - this.con_pad;
            }
            c.x = this.current_left_x;
            c.y += (this.h - this.pad) / 2;
        } else if (dir == Direction.RIGHT) {
            if (this.current_right_x - c.x < this.w / 2 - this.con_pad) {
                this.current_right_x = this.current_right_x + this.con_pad;
            }
            c.x = this.current_right_x;
            c.y += (this.h - this.pad) / 2;
        }
        return c;
    }

    @Override
    public void connectTo(Element e) {
        if (e != null && this.connectOut_overrideable() && e.connectIn()) {
            Point from = this.getPosition();
            Point to = e.getConnect(Direction.UP);
            if (from.x == to.x) {
                from = this.getConnect(Direction.DOWN);
            } else if (from.x < to.x) {
                from = this.getConnect(Direction.RIGHT);
            } else if (from.x > to.x) {
                from = this.getConnect(Direction.LEFT);
            }
            if (from.x != to.x) {
                this.getGraphics().drawLine(from.x, from.y, to.x, to.y - (int)(10.0f * this.getZoom()) * 2);
                from.x = to.x;
                from.y = (int)((float)to.y - 10.0f * this.getZoom() * 2.0f);
            }
            if (this.arrowOut() && e.arrowIn()) {
                Connector.drawArrow(this.getGraphics(), this.getZoom(), from.x, from.y, to.x, to.y);
            } else {
                this.getGraphics().drawLine(from.x, from.y, to.x, to.y);
            }
        }
    }
}

