/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.io.OutputHandler;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.CurrentGui;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.List;

public class ClipBoard
implements Transferable {
    private final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private List<GridElement> entities;
    private static ClipBoard _instance = new ClipBoard();

    public static ClipBoard getInstance() {
        return _instance;
    }

    public void copyAndZoomToDefaultLevel(List<GridElement> entities, DiagramHandler handler) {
        if (entities.isEmpty()) {
            return;
        }
        this.entities = new ArrayList<GridElement>(entities.size());
        DiagramHandler dhNew = new DiagramHandler(null);
        for (GridElement entitiy : entities) {
            this.entities.add(ElementFactorySwing.createCopy(entitiy, dhNew));
        }
        DiagramHandler.zoomEntities(handler.getGridSize(), 10, this.entities);
        CurrentGui.getInstance().getGui().enablePasteMenuEntry();
        if (this.clipboard != null) {
            this.clipboard.setContents(this, null);
        }
    }

    public List<GridElement> paste() {
        return this.entities;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return OutputHandler.createImageForGridElements(this.entities, null);
    }
}

