/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest;

import java.util.HashMap;
import java.util.Map;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.manualrequest.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.manualrequest.http.impl.ManualHttpRequestEditorDialog;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.httppanel.Message;

public class ExtensionManualRequestEditor
extends ExtensionAdaptor
implements SessionChangedListener {
    private Map<Class<? extends Message>, ManualRequestEditorDialog> dialogues = new HashMap<Class<? extends Message>, ManualRequestEditorDialog>();
    public static final String NAME = "ExtensionManualRequest";

    public ExtensionManualRequestEditor() {
        super(NAME);
        this.setOrder(36);
    }

    @Override
    public void initView(ViewDelegate viewDelegate) {
        super.initView(viewDelegate);
        ManualHttpRequestEditorDialog manualHttpRequestEditorDialog = new ManualHttpRequestEditorDialog(true, "manual", "ui.dialogs.manreq");
        manualHttpRequestEditorDialog.setTitle(Constant.messages.getString("manReq.dialog.title"));
        this.addManualSendEditor(manualHttpRequestEditorDialog);
    }

    public void addManualSendEditor(ManualRequestEditorDialog manualRequestEditorDialog) {
        this.dialogues.put(manualRequestEditorDialog.getMessageType(), manualRequestEditorDialog);
    }

    public void removeManualSendEditor(Class<? extends Message> clazz) {
        ManualRequestEditorDialog manualRequestEditorDialog = this.dialogues.remove(clazz);
        if (manualRequestEditorDialog != null) {
            manualRequestEditorDialog.clear();
            manualRequestEditorDialog.dispose();
            if (this.getView() != null) {
                ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
                extensionLoader.removeToolsMenuItem(manualRequestEditorDialog.getMenuItem());
            }
        }
    }

    public ManualRequestEditorDialog getManualSendEditor(Class<? extends Message> clazz) {
        return this.dialogues.get(clazz);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            for (Map.Entry<Class<? extends Message>, ManualRequestEditorDialog> entry : this.dialogues.entrySet()) {
                extensionHook.getHookMenu().addToolsMenuItem(entry.getValue().getMenuItem());
            }
            extensionHook.addSessionListener(this);
        }
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    @Override
    public void sessionChanged(Session session) {
        for (Map.Entry<Class<? extends Message>, ManualRequestEditorDialog> entry : this.dialogues.entrySet()) {
            entry.getValue().clear();
            entry.getValue().setDefaultMessage();
        }
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        Boolean bl = null;
        switch (mode) {
            case safe: {
                bl = false;
                break;
            }
            case protect: 
            case standard: 
            case attack: {
                bl = true;
            }
        }
        if (bl != null) {
            for (Map.Entry<Class<? extends Message>, ManualRequestEditorDialog> entry : this.dialogues.entrySet()) {
                entry.getValue().setEnabled(bl);
            }
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

