/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.alert.AlertParam;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsAlertPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -7541236934312940852L;
    private static final String NAME = Constant.messages.getString("alert.optionspanel.name");
    private ZapNumberSpinner maxInstances;
    private JCheckBox mergeRelatedIssues;
    private JTextField overridesFilename;

    public OptionsAlertPanel() {
        this.setName(NAME);
        this.setLayout(new FlowLayout(3, 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        jPanel.add((Component)this.getMergeRelatedIssues(), LayoutHelper.getGBC(0, 0, 2, 1.0, new Insets(2, 2, 2, 2)));
        JLabel jLabel = new JLabel(Constant.messages.getString("alert.optionspanel.label.maxinstances"));
        jLabel.setLabelFor(this.getMaxInstances());
        jPanel.add((Component)jLabel, LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
        jPanel.add((Component)this.getMaxInstances(), LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
        JButton jButton = new JButton(Constant.messages.getString("alert.optionspanel.button.overridesFilename"));
        jButton.addActionListener(new FileChooserAction(this.getOverridesFilename()));
        JLabel jLabel2 = new JLabel(Constant.messages.getString("alert.optionspanel.label.overridesFilename"));
        jLabel2.setLabelFor(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(this.getOverridesFilename());
        jPanel2.add(jButton);
        jPanel.add((Component)jLabel2, LayoutHelper.getGBC(0, 2, 1, 1.0, new Insets(2, 2, 2, 2)));
        jPanel.add((Component)jPanel2, LayoutHelper.getGBC(1, 2, 1, 1.0, new Insets(2, 2, 2, 2)));
        this.add(jPanel);
    }

    private JCheckBox getMergeRelatedIssues() {
        if (this.mergeRelatedIssues == null) {
            this.mergeRelatedIssues = new JCheckBox();
            this.mergeRelatedIssues.setText(Constant.messages.getString("alert.optionspanel.label.mergerelated"));
            this.mergeRelatedIssues.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsAlertPanel.this.getMaxInstances().setEditable(OptionsAlertPanel.this.mergeRelatedIssues.isSelected());
                }
            });
        }
        return this.mergeRelatedIssues;
    }

    private ZapNumberSpinner getMaxInstances() {
        if (this.maxInstances == null) {
            this.maxInstances = new ZapNumberSpinner();
        }
        return this.maxInstances;
    }

    private JTextField getOverridesFilename() {
        if (this.overridesFilename == null) {
            this.overridesFilename = new JTextField(20);
        }
        return this.overridesFilename;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        AlertParam alertParam = optionsParam.getParamSet(AlertParam.class);
        this.getMaxInstances().setValue((Object)alertParam.getMaximumInstances());
        this.getMergeRelatedIssues().setSelected(alertParam.isMergeRelatedIssues());
        this.getMaxInstances().setEditable(alertParam.isMergeRelatedIssues());
        this.getOverridesFilename().setText(alertParam.getOverridesFilename());
    }

    @Override
    public void validateParam(Object object) throws Exception {
        File file;
        String string = this.getOverridesFilename().getText();
        if (!(string == null || string.length() <= 0 || (file = new File(string)).isFile() && file.canRead())) {
            throw new IllegalArgumentException(Constant.messages.getString("alert.optionspanel.warn.badOverridesFilename"));
        }
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        AlertParam alertParam = optionsParam.getParamSet(AlertParam.class);
        alertParam.setMaximumInstances(this.getMaxInstances().getValue());
        alertParam.setMergeRelatedIssues(this.getMergeRelatedIssues().isSelected());
        alertParam.setOverridesFilename(this.getOverridesFilename().getText());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.alert";
    }

    private static class FileChooserAction
    implements ActionListener {
        private final JTextField textField;

        public FileChooserAction(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            String string = this.textField.getText();
            if (string != null && (file = new File(string)).canRead() && !file.isDirectory()) {
                jFileChooser.setSelectedFile(file);
            }
            if (jFileChooser.showOpenDialog(null) == 0) {
                file = jFileChooser.getSelectedFile();
                this.textField.setText(file.getAbsolutePath());
            }
        }
    }
}

