/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.callback.CallbackParam;
import org.zaproxy.zap.extension.callback.ExtensionCallback;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsCallbackPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panel = null;
    private ExtensionCallback ext;
    private JComboBox<String> localAddress = null;
    private JComboBox<String> remoteAddress = null;
    private ZapTextField testURL = null;
    private JCheckBox randomPort = null;
    private ZapPortNumberSpinner spinnerPort = null;

    public OptionsCallbackPanel(ExtensionCallback extensionCallback) {
        this.ext = extensionCallback;
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("callback.options.title"));
        this.add((Component)this.getCallbackPanel(), this.getCallbackPanel().getName());
    }

    private JPanel getCallbackPanel() {
        if (this.panel == null) {
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 0.5;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.ipadx = 50;
            gridBagConstraints4.ipady = 0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.ipadx = 50;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            jLabel.setText(Constant.messages.getString("options.proxy.local.label.browser"));
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            JLabel jLabel2 = new JLabel(Constant.messages.getString("callback.options.label.localaddress"));
            jLabel2.setLabelFor(this.getLocalAddress());
            this.panel.add((Component)jLabel2, LayoutHelper.getGBC(0, 0, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add(this.getLocalAddress(), LayoutHelper.getGBC(1, 0, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel jLabel3 = new JLabel(Constant.messages.getString("callback.options.label.remoteaddress"));
            jLabel3.setLabelFor(this.getRemoteAddress());
            this.panel.add((Component)jLabel3, LayoutHelper.getGBC(0, 1, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add(this.getRemoteAddress(), LayoutHelper.getGBC(1, 1, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel jLabel4 = new JLabel(Constant.messages.getString("callback.options.label.rndport"));
            jLabel4.setLabelFor(this.getSpinnerPort());
            this.panel.add((Component)jLabel4, LayoutHelper.getGBC(0, 2, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getRandomPort(), LayoutHelper.getGBC(1, 2, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel jLabel5 = new JLabel(Constant.messages.getString("callback.options.label.port"));
            jLabel5.setLabelFor(this.getSpinnerPort());
            this.panel.add((Component)jLabel5, LayoutHelper.getGBC(0, 3, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getSpinnerPort(), LayoutHelper.getGBC(1, 3, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel jLabel6 = new JLabel(Constant.messages.getString("callback.options.label.testurl"));
            jLabel6.setLabelFor(this.getTestURL());
            this.panel.add((Component)jLabel6, LayoutHelper.getGBC(0, 4, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getTestURL(), LayoutHelper.getGBC(1, 4, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 20, 2, 0.5, 1.0));
        }
        return this.panel;
    }

    private JComboBox<String> getLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = new JComboBox();
        }
        return this.localAddress;
    }

    private JComboBox<String> getRemoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = new JComboBox();
            this.remoteAddress.setEditable(true);
        }
        return this.remoteAddress;
    }

    private ZapTextField getTestURL() {
        if (this.testURL == null) {
            this.testURL = new ZapTextField();
            this.testURL.setEditable(false);
            this.testURL.setFocusable(true);
        }
        return this.testURL;
    }

    private JCheckBox getRandomPort() {
        if (this.randomPort == null) {
            this.randomPort = new JCheckBox();
            this.randomPort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCallbackPanel.this.getSpinnerPort().setEnabled(!OptionsCallbackPanel.this.randomPort.isSelected());
                }
            });
        }
        return this.randomPort;
    }

    private ZapPortNumberSpinner getSpinnerPort() {
        if (this.spinnerPort == null) {
            this.spinnerPort = new ZapPortNumberSpinner(0);
        }
        return this.spinnerPort;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        CallbackParam callbackParam = optionsParam.getParamSet(CallbackParam.class);
        List<String> list = callbackParam.getAvailableAddresses(false);
        this.localAddress.removeAllItems();
        this.localAddress.addItem("0.0.0.0");
        for (String string : list) {
            this.localAddress.addItem(string);
        }
        this.localAddress.setSelectedItem(callbackParam.getLocalAddress());
        this.remoteAddress.removeAllItems();
        for (String string : list) {
            this.remoteAddress.addItem(string);
        }
        this.remoteAddress.setSelectedItem(callbackParam.getRemoteAddress());
        if (callbackParam.getPort() == 0) {
            this.getRandomPort().setSelected(true);
            this.getSpinnerPort().setEnabled(false);
            this.getSpinnerPort().setValue(this.ext.getPort());
        } else {
            this.getSpinnerPort().setEnabled(true);
            this.getSpinnerPort().setValue(callbackParam.getPort());
        }
        this.getTestURL().setText(this.ext.getTestUrl());
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        CallbackParam callbackParam = optionsParam.getParamSet(CallbackParam.class);
        callbackParam.setLocalAddress((String)this.localAddress.getSelectedItem());
        callbackParam.setRemoteAddress((String)this.remoteAddress.getSelectedItem());
        if (this.getRandomPort().isSelected()) {
            callbackParam.setPort(0);
        } else {
            callbackParam.setPort(this.spinnerPort.getValue());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.callback";
    }
}

