/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.history.PopupMenuExportURLs;

public class PopupMenuExportSelectedURLs
extends PopupMenuExportURLs {
    private static final long serialVersionUID = -4426560452505908380L;
    private static Logger LOG = Logger.getLogger(PopupMenuExportSelectedURLs.class);

    public PopupMenuExportSelectedURLs(String string) {
        super(string);
    }

    @Override
    protected void performAction() {
        File file = super.getOutputFile();
        if (file == null) {
            return;
        }
        JTree jTree = this.extension.getView().getSiteTreePanel().getTreeSite();
        super.writeURLs(file, this.getOutputSet(jTree.getSelectionPaths()));
    }

    private SortedSet<String> getOutputSet(TreePath[] treePathArray) {
        JTree jTree = this.extension.getView().getSiteTreePanel().getTreeSite();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        if (ArrayUtils.isEmpty((Object[])treePathArray)) {
            arrayList.add(new TreePath(jTree.getModel().getRoot()));
        } else {
            arrayList.addAll(Arrays.asList(treePathArray));
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (TreePath treePath : arrayList) {
            Enumeration<TreeNode> enumeration = ((SiteNode)treePath.getLastPathComponent()).preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                HistoryReference historyReference;
                SiteNode siteNode = (SiteNode)enumeration.nextElement();
                if (siteNode.isRoot() || (historyReference = siteNode.getHistoryReference()) == null || HistoryReference.getTemporaryTypes().contains(historyReference.getHistoryType())) continue;
                treeSet.add(historyReference.getURI().toString());
            }
        }
        return treeSet;
    }
}

