/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.httpsessions.HttpSessionToken;

public class HttpSessionsParam
extends AbstractParam {
    private static final String DEFAULT_TOKENS_KEY = "httpsessions.tokens";
    private static final String ALL_DEFAULT_TOKENS_KEY = "httpsessions.tokens.token";
    private static final String TOKEN_NAME_KEY = "name";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String PROXY_ONLY_KEY = "httpsessions.proxyOnly";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "httpsessions.confirmRemoveToken";
    private static final String[] DEFAULT_TOKENS = new String[]{"asp.net_sessionid", "aspsessionid", "siteserver", "cfid", "cftoken", "jsessionid", "phpsessid", "sessid", "sid", "viewstate", "zenid"};
    private static final Logger log = Logger.getLogger(HttpSessionsParam.class);
    private List<HttpSessionToken> defaultTokens = null;
    private List<String> defaultTokensEnabled = null;
    private boolean enabledProxyOnly = false;
    private boolean confirmRemove = true;

    @Override
    protected void parse() {
        try {
            String[] stringArray = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_DEFAULT_TOKENS_KEY);
            this.defaultTokens = new ArrayList<HttpSessionToken>(stringArray.size());
            this.defaultTokensEnabled = new ArrayList<String>(stringArray.size());
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.size());
            for (HierarchicalConfiguration object : stringArray) {
                String string = object.getString(TOKEN_NAME_KEY, "");
                if ("".equals(string) || arrayList.contains(string)) continue;
                boolean bl = object.getBoolean(TOKEN_ENABLED_KEY, true);
                this.defaultTokens.add(new HttpSessionToken(string, bl));
                arrayList.add(string);
                if (!bl) continue;
                this.defaultTokensEnabled.add(string);
            }
        }
        catch (ConversionException conversionException) {
            this.defaultTokens = new ArrayList<HttpSessionToken>(DEFAULT_TOKENS.length);
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        if (this.defaultTokens.size() == 0) {
            for (String string : DEFAULT_TOKENS) {
                this.defaultTokens.add(new HttpSessionToken(string));
                this.defaultTokensEnabled.add(string);
            }
        }
        try {
            this.enabledProxyOnly = this.getConfig().getBoolean(PROXY_ONLY_KEY, false);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.confirmRemove = this.getConfig().getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    public final List<HttpSessionToken> getDefaultTokens() {
        return Collections.unmodifiableList(this.defaultTokens);
    }

    public final List<String> getDefaultTokensEnabled() {
        return Collections.unmodifiableList(this.defaultTokensEnabled);
    }

    public void setDefaultTokens(List<HttpSessionToken> list) {
        this.defaultTokens = list;
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DEFAULT_TOKENS_KEY);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = "httpsessions.tokens.token(" + i + ").";
            HttpSessionToken httpSessionToken = list.get(i);
            this.getConfig().setProperty(string + TOKEN_NAME_KEY, (Object)httpSessionToken.getName());
            this.getConfig().setProperty(string + TOKEN_ENABLED_KEY, (Object)httpSessionToken.isEnabled());
            if (!httpSessionToken.isEnabled()) continue;
            arrayList.add(httpSessionToken.getName());
        }
        arrayList.trimToSize();
        this.defaultTokensEnabled = arrayList;
    }

    public boolean isEnabledProxyOnly() {
        return this.enabledProxyOnly;
    }

    public void setEnabledProxyOnly(boolean bl) {
        this.enabledProxyOnly = bl;
        this.getConfig().setProperty(PROXY_ONLY_KEY, (Object)bl);
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveDefaultToken() {
        return this.confirmRemove;
    }

    @ZapApiIgnore
    public void setConfirmRemoveDefaultToken(boolean bl) {
        this.confirmRemove = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, (Object)bl);
    }
}

