/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.DefaultValueGenerator;
import org.zaproxy.zap.model.ValueGenerator;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlFormParser
extends SpiderParser {
    private static final String ENCODING_TYPE = "UTF-8";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String METHOD_POST = "POST";
    private URI uri;
    private String url;
    private Map<String, String> envAttributes = new HashMap<String, String>();
    private final SpiderParam param;
    private final ValueGenerator valueGenerator;

    public SpiderHtmlFormParser(SpiderParam spiderParam) {
        this(spiderParam, new DefaultValueGenerator());
    }

    public SpiderHtmlFormParser(SpiderParam spiderParam, ValueGenerator valueGenerator) {
        if (spiderParam == null) {
            throw new IllegalArgumentException("Parameter param must not be null.");
        }
        if (valueGenerator == null) {
            throw new IllegalArgumentException("Parameter valueGenerator must not be null.");
        }
        this.param = spiderParam;
        this.valueGenerator = valueGenerator;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        Object object;
        log.debug((Object)"Parsing an HTML message for forms...");
        if (!this.param.isProcessForm()) {
            return false;
        }
        if (source == null) {
            source = new Source((CharSequence)httpMessage.getResponseBody().toString());
        }
        String string = httpMessage.getRequestHeader().getURI().toString();
        this.uri = httpMessage.getRequestHeader().getURI();
        Element element = source.getFirstElement("base");
        if (element != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + element.getDebugInfo()));
            }
            if ((object = element.getAttributeValue("href")) != null && !((String)object).isEmpty()) {
                string = URLCanonicalizer.getCanonicalURL((String)object, string);
            }
        }
        object = source.getAllElements("form");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object22;
            Element element2 = (Element)iterator.next();
            this.envAttributes.clear();
            for (Object object22 : element2.getAttributes()) {
                this.envAttributes.put(object22.getKey(), object22.getValue());
            }
            String string2 = element2.getAttributeValue("method");
            object22 = element2.getAttributeValue("action");
            log.debug((Object)("Found new form with method: '" + (String)string2 + "' and action: " + (String)object22));
            if (object22 == null) {
                log.debug((Object)("No form 'action' defined. Using base URL: " + string));
                object22 = string;
            }
            if (!this.param.isPostForm() && string2 != null && string2.trim().equalsIgnoreCase(METHOD_POST)) {
                log.debug((Object)"Skipping form with POST method because of user settings.");
                continue;
            }
            if (((String)object22).contains("#")) {
                int n2 = ((String)object22).lastIndexOf("#");
                object22 = ((String)object22).substring(0, n2);
            }
            this.url = URLCanonicalizer.getCanonicalURL((String)object22, string);
            FormData formData = this.prepareFormDataSet(element2.getFormFields());
            if (string2 != null && string2.trim().equalsIgnoreCase(METHOD_POST)) {
                String string3 = URLCanonicalizer.getCanonicalURL((String)object22, string);
                if (string3 == null) {
                    return false;
                }
                log.debug((Object)("Canonical URL constructed using '" + (String)object22 + "': " + string3));
                String string4 = this.buildEncodedUrlQuery(formData.getFields());
                if (formData.getSubmitFields().isEmpty()) {
                    this.notifyPostResourceFound(httpMessage, n, string3, string4);
                    continue;
                }
                for (HtmlParameter htmlParameter : formData.getSubmitFields()) {
                    this.notifyPostResourceFound(httpMessage, n, string3, SpiderHtmlFormParser.appendEncodedUrlQueryParameter(string4, htmlParameter));
                }
                continue;
            }
            if (((String)object22).contains("?")) {
                if (((String)object22).endsWith("?")) {
                    this.processGetForm(httpMessage, n, (String)object22, string, formData);
                    continue;
                }
                this.processGetForm(httpMessage, n, (String)object22 + "&", string, formData);
                continue;
            }
            this.processGetForm(httpMessage, n, (String)object22 + "?", string, formData);
        }
        return false;
    }

    private void processGetForm(HttpMessage httpMessage, int n, String string, String string2, FormData formData) {
        String string3 = this.buildEncodedUrlQuery(formData.getFields());
        if (formData.getSubmitFields().isEmpty()) {
            log.debug((Object)("Submiting form with GET method and query with form parameters: " + string3));
            this.processURL(httpMessage, n, string + string3, string2);
        } else {
            for (HtmlParameter htmlParameter : formData.getSubmitFields()) {
                String string4 = SpiderHtmlFormParser.appendEncodedUrlQueryParameter(string3, htmlParameter);
                log.debug((Object)("Submiting form with GET method and query with form parameters: " + string4));
                this.processURL(httpMessage, n, string + string4, string2);
            }
        }
    }

    private FormData prepareFormDataSet(FormFields formFields) {
        LinkedList<HtmlParameter> linkedList = new LinkedList<HtmlParameter>();
        ArrayList<HtmlParameter> arrayList = new ArrayList<HtmlParameter>();
        for (FormField formField : formFields) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New form field: " + formField.getDebugInfo()));
            }
            AbstractList abstractList = linkedList;
            if (formField.getFormControl().getFormControlType().isSubmit()) {
                abstractList = arrayList;
            }
            for (String string : this.getDefaultTextValue(formField)) {
                abstractList.add((HtmlParameter)new HtmlParameter(HtmlParameter.Type.form, formField.getName(), string));
            }
        }
        return new FormData(linkedList, arrayList);
    }

    private List<String> getDefaultTextValue(FormField formField) {
        Object object;
        String string;
        String string2 = formField.getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        hashMap.putAll(formField.getFormControl().getAttributesMap());
        hashMap.put("Control Type", formField.getFormControl().getFormControlType().name());
        if (formField.getFormControl().getFormControlType().isSubmit()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string3 : formField.getPredefinedValues()) {
                String string4 = this.valueGenerator.getValue(this.uri, this.url, string2, string3, arrayList, this.envAttributes, hashMap);
                arrayList2.add(string4);
            }
            return arrayList2;
        }
        ArrayList<String> arrayList3 = formField.getValues();
        if (formField.getFormControl().getAttributesMap().containsKey("value")) {
            string = (String)formField.getFormControl().getAttributesMap().get("value");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Existing values: " + arrayList3));
        }
        if (arrayList3.isEmpty() || arrayList3.size() == 1 && ((String)arrayList3.get(0)).isEmpty()) {
            string = DEFAULT_EMPTY_VALUE;
            object = formField.getPredefinedValues();
            if (!object.isEmpty()) {
                arrayList.addAll((Collection<String>)object);
                Iterator iterator = object.iterator();
                string = (String)iterator.next();
                if (iterator.hasNext()) {
                    string = (String)iterator.next();
                }
            }
        } else {
            string = (String)arrayList3.get(0);
        }
        object = this.valueGenerator.getValue(this.uri, this.url, string2, string, arrayList, this.envAttributes, hashMap);
        log.debug((Object)("Generated: " + (String)object + "For field " + formField.getName()));
        arrayList3 = new ArrayList<String>(1);
        arrayList3.add((String)object);
        return arrayList3;
    }

    private void notifyPostResourceFound(HttpMessage httpMessage, int n, String string, String string2) {
        log.debug((Object)("Submiting form with POST method and message body with form parameters (normal encoding): " + string2));
        this.notifyListenersPostResourceFound(httpMessage, n + 1, string, string2);
    }

    private String buildEncodedUrlQuery(List<HtmlParameter> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HtmlParameter htmlParameter : list) {
            try {
                String string = URLEncoder.encode(htmlParameter.getName(), ENCODING_TYPE);
                stringBuilder.append(string);
                stringBuilder.append("=");
                string = URLEncoder.encode(htmlParameter.getValue(), ENCODING_TYPE);
                stringBuilder.append(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.warn((Object)"Error while encoding query for form.", (Throwable)unsupportedEncodingException);
            }
            stringBuilder.append("&");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static String appendEncodedUrlQueryParameter(String string, HtmlParameter htmlParameter) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        try {
            stringBuilder.append(URLEncoder.encode(htmlParameter.getName(), ENCODING_TYPE)).append('=').append(URLEncoder.encode(htmlParameter.getValue(), ENCODING_TYPE));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"Error while encoding query for form.", (Throwable)unsupportedEncodingException);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return !bl && httpMessage.getResponseHeader().isHtml();
    }

    private static class FormData {
        private final List<HtmlParameter> fields;
        private final List<HtmlParameter> submitFields;

        public FormData(List<HtmlParameter> list, List<HtmlParameter> list2) {
            this.fields = list;
            this.submitFields = list2;
        }

        public List<HtmlParameter> getFields() {
            return this.fields;
        }

        public List<HtmlParameter> getSubmitFields() {
            return this.submitFields;
        }
    }
}

