/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.zaproxy.zap.utils.ExecutorTerminatedListener;
import org.zaproxy.zap.utils.PausableExecutorService;

public class PausableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements PausableExecutorService {
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();
    private boolean paused;
    private List<ExecutorTerminatedListener> listeners = new ArrayList<ExecutorTerminatedListener>(1);
    private long defaultDelayInMs;
    private boolean incrementalDefaultDelay;
    private AtomicInteger taskCount;

    public PausableScheduledThreadPoolExecutor(int n) {
        super(n);
    }

    public PausableScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory) {
        super(n, threadFactory);
    }

    public PausableScheduledThreadPoolExecutor(int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, rejectedExecutionHandler);
    }

    public PausableScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, threadFactory, rejectedExecutionHandler);
    }

    public void setDefaultDelay(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException("Parameter delay must be greater or equal to zero.");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Parameter unit must not be null.");
        }
        this.defaultDelayInMs = timeUnit.toMillis(l);
    }

    public long getDefaultDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.defaultDelayInMs, TimeUnit.MILLISECONDS);
    }

    public void setIncrementalDefaultDelay(boolean bl) {
        if (this.incrementalDefaultDelay == bl) {
            return;
        }
        this.incrementalDefaultDelay = bl;
        this.taskCount = this.incrementalDefaultDelay ? new AtomicInteger() : null;
    }

    public boolean isIncrementalDefaultDelay() {
        return this.incrementalDefaultDelay;
    }

    public void resetIncrementalDefaultDelay() {
        if (this.incrementalDefaultDelay) {
            this.taskCount = new AtomicInteger();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        this.schedule(runnable, this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    private long getDefaultDelayForTask() {
        if (this.incrementalDefaultDelay) {
            return (long)this.taskCount.incrementAndGet() * this.defaultDelayInMs;
        }
        return this.defaultDelayInMs;
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.schedule(runnable, this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.schedule(Executors.callable(runnable, t), this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.schedule(callable, this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.pauseLock.lock();
        try {
            while (this.paused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.pauseLock.lock();
        try {
            if (!this.paused) {
                return;
            }
            this.paused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.resume();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.resume();
        return super.shutdownNow();
    }

    @Override
    protected void terminated() {
        super.terminated();
        PausableScheduledThreadPoolExecutor.notifyListeners(new ArrayList<ExecutorTerminatedListener>(this.listeners));
    }

    private static void notifyListeners(List<ExecutorTerminatedListener> list) {
        for (ExecutorTerminatedListener executorTerminatedListener : list) {
            executorTerminatedListener.terminated();
        }
    }

    @Override
    public void addExecutorTerminatedListener(ExecutorTerminatedListener executorTerminatedListener) {
        this.listeners.add(executorTerminatedListener);
    }

    @Override
    public void removeExecutorTerminatedListener(ExecutorTerminatedListener executorTerminatedListener) {
        this.listeners.remove(executorTerminatedListener);
    }
}

