/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.IllegalContextNameException;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextGeneralPanel
extends AbstractContextPropertiesPanel {
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelContext = null;
    private ZapTextField txtName = null;
    private ZapTextArea txtDescription = null;
    private JCheckBox chkInScope = null;

    public static String getPanelName(Context context) {
        return ContextGeneralPanel.getPanelName(context.getIndex(), context.getName());
    }

    public static String getPanelName(int n, String string) {
        return n + ":" + string;
    }

    public ContextGeneralPanel(String string, int n) {
        super(n);
        this.setName(string);
        this.setLayout(new CardLayout());
        this.add((Component)this.getPanelSession(), this.getName() + "gen");
    }

    @Override
    public void setName(String string) {
        if (string.startsWith(this.getContextIndex() + ":")) {
            string = string.substring(string.indexOf(":") + 1);
        }
        super.setName(ContextGeneralPanel.getPanelName(this.getContextIndex(), string));
    }

    private JPanel getPanelSession() {
        if (this.panelContext == null) {
            this.panelContext = new JPanel();
            this.panelContext.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelContext.setSize(180, 101);
            }
            this.panelContext.add((Component)new JLabel(Constant.messages.getString("context.label.name")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelContext.add((Component)this.getTxtName(), LayoutHelper.getGBC(0, 1, 1, 1.0));
            this.panelContext.add((Component)this.getChkInScope(), LayoutHelper.getGBC(0, 2, 2, 1.0));
            this.panelContext.add((Component)new JLabel(Constant.messages.getString("context.label.desc")), LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelContext.add((Component)this.getTxtDescription(), LayoutHelper.getGBC(0, 4, 1, 1.0, 1.0));
        }
        return this.panelContext;
    }

    private ZapTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new ZapTextField();
        }
        return this.txtName;
    }

    private JCheckBox getChkInScope() {
        if (this.chkInScope == null) {
            this.chkInScope = new JCheckBox();
            this.chkInScope.setText(Constant.messages.getString("context.inscope.label"));
        }
        return this.chkInScope;
    }

    private ZapTextArea getTxtDescription() {
        if (this.txtDescription == null) {
            this.txtDescription = new ZapTextArea();
            this.txtDescription.setBorder(BorderFactory.createBevelBorder(1));
            this.txtDescription.setLineWrap(true);
        }
        return this.txtDescription;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context context) {
        String string;
        int n;
        this.getTxtName().setText(context.getName());
        this.getTxtName().discardAllEdits();
        this.getTxtDescription().setText(context.getDescription());
        this.getTxtDescription().discardAllEdits();
        this.getChkInScope().setSelected(context.isInScope());
        if (context.getName().equals(Integer.toString(context.getIndex())) && context.getIncludeInContextRegexs().size() == 1 && (n = (string = context.getIncludeInContextRegexs().get(0)).indexOf("://")) > 0) {
            String string2 = string.substring(n + 3);
            int n2 = string2.indexOf("\\");
            if (n2 > 0) {
                string2 = string2.substring(0, n2);
            }
            if ((n2 = string2.indexOf("/")) > 0) {
                string2 = string2.substring(0, n2);
            }
            this.getTxtName().setText(string2);
        }
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        String string = this.getTxtName().getText();
        if (string == null || string.isEmpty()) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.EMPTY_NAME, Constant.messages.getString("context.error.name.empty"));
        }
        if (!this.getName().equals(ContextGeneralPanel.getPanelName(this.getContextIndex(), string)) && session.getContext(string) != null) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.DUPLICATED_NAME, Constant.messages.getString("context.error.name.duplicated"));
        }
    }

    @Override
    public void saveContextData(Session session) {
        Context context = session.getContext(this.getContextIndex());
        this.saveDataInContext(context);
        String string = this.getTxtName().getText();
        if (!this.getName().equals(ContextGeneralPanel.getPanelName(this.getContextIndex(), string)) && View.isInitialised()) {
            View.getSingleton().renameContext(context);
        }
    }

    @Override
    public void saveTemporaryContextData(Context context) {
        this.saveDataInContext(context);
    }

    private void saveDataInContext(Context context) {
        context.setName(this.getTxtName().getText());
        context.setDescription(this.getTxtDescription().getText());
        context.setInScope(this.getChkInScope().isSelected());
    }
}

