/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.table.HistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public abstract class AbstractHistoryReferencesTableModel<T extends HistoryReferencesTableEntry>
extends AbstractTableModel
implements HistoryReferencesTableModel<T> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("view.href.table.header.hrefid"), Constant.messages.getString("view.href.table.header.timestamp.request"), Constant.messages.getString("view.href.table.header.timestamp.response"), Constant.messages.getString("view.href.table.header.hreftype"), Constant.messages.getString("view.href.table.header.method"), Constant.messages.getString("view.href.table.header.url"), Constant.messages.getString("view.href.table.header.code"), Constant.messages.getString("view.href.table.header.reason"), Constant.messages.getString("view.href.table.header.rtt"), Constant.messages.getString("view.href.table.header.size.message"), Constant.messages.getString("view.href.table.header.size.requestheader"), Constant.messages.getString("view.href.table.header.size.requestbody"), Constant.messages.getString("view.href.table.header.size.responseheader"), Constant.messages.getString("view.href.table.header.size.responsebody"), Constant.messages.getString("view.href.table.header.sessionid"), Constant.messages.getString("view.href.table.header.highestalert"), Constant.messages.getString("view.href.table.header.note"), Constant.messages.getString("view.href.table.header.tags")};
    private final HistoryReferencesTableModel.Column[] columns;
    private final Map<HistoryReferencesTableModel.Column, Integer> cacheColumnToColumnIdx;

    public AbstractHistoryReferencesTableModel(HistoryReferencesTableModel.Column[] columnArray) {
        if (columnArray == null || columnArray.length == 0) {
            throw new IllegalArgumentException("Parameter columns must not be null.");
        }
        this.columns = Arrays.copyOf(columnArray, columnArray.length);
        this.cacheColumnToColumnIdx = this.buildCacheColumnToColumnIdx(columnArray);
    }

    private Map<HistoryReferencesTableModel.Column, Integer> buildCacheColumnToColumnIdx(HistoryReferencesTableModel.Column[] columnArray) {
        TreeMap<HistoryReferencesTableModel.Column, Integer> treeMap = new TreeMap<HistoryReferencesTableModel.Column, Integer>();
        for (int i = 0; i < columnArray.length; ++i) {
            treeMap.put(columnArray[i], i);
        }
        return treeMap;
    }

    protected boolean isCustomColumn(int n) {
        return AbstractHistoryReferencesTableModel.isCustomColumn(this.columns, n);
    }

    @Override
    public abstract Class<?> getColumnClass(int var1);

    @Override
    public HistoryReferencesTableModel.Column[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    @Override
    public HistoryReferencesTableModel.Column getColumn(int n) {
        return this.columns[n];
    }

    @Override
    public int getColumnIndex(HistoryReferencesTableModel.Column column) {
        Integer n = this.cacheColumnToColumnIdx.get((Object)column);
        if (n != null) {
            return n;
        }
        return -1;
    }

    @Override
    public boolean isColumnEnabled(HistoryReferencesTableModel.Column column) {
        return this.getColumnIndex(column) != -1;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[this.columns[n].ordinal()];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getEntry(n).getValue(this.getColumn(n2));
    }

    protected static boolean isCustomColumn(HistoryReferencesTableModel.Column[] columnArray, int n) {
        return columnArray[n] == HistoryReferencesTableModel.Column.CUSTOM;
    }
}

