// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_PermissionsVerifier_h__
#define __Glacier2_PermissionsVerifier_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Glacier2/SSLInfo.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

class PermissionsVerifier;
class PermissionsVerifierPrx;
class SSLPermissionsVerifier;
class SSLPermissionsVerifierPrx;

}

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) PermissionDeniedException : public ::Ice::UserExceptionHelper<PermissionDeniedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~PermissionDeniedException();

    PermissionDeniedException(const PermissionDeniedException&) = default;

    PermissionDeniedException() = default;

    PermissionDeniedException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

    ::std::string reason;

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::SlicedData> ice_getSlicedData() const override;

    ICE_MEMBER(GLACIER2_API) virtual void _write(::Ice::OutputStream*) const override;
    ICE_MEMBER(GLACIER2_API) virtual void _read(::Ice::InputStream*) override;

    ::std::shared_ptr<::Ice::SlicedData> _slicedData;
};

static PermissionDeniedException _iceS_PermissionDeniedException_init;

}

namespace Glacier2
{

class GLACIER2_API PermissionsVerifier : public virtual ::Ice::Object
{
public:

    using ProxyType = PermissionsVerifierPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    struct CheckPermissionsResult
    {
        bool returnValue;
        ::std::string reason;
    };

    virtual bool checkPermissions(::std::string, ::std::string, ::std::string&, const ::Ice::Current&) const = 0;
    bool _iceD_checkPermissions(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class GLACIER2_API SSLPermissionsVerifier : public virtual ::Ice::Object
{
public:

    using ProxyType = SSLPermissionsVerifierPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    struct AuthorizeResult
    {
        bool returnValue;
        ::std::string reason;
    };

    virtual bool authorize(::Glacier2::SSLInfo, ::std::string&, const ::Ice::Current&) const = 0;
    bool _iceD_authorize(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) PermissionsVerifierPrx : public virtual ::Ice::Proxy<PermissionsVerifierPrx, ::Ice::ObjectPrx>
{
public:

    bool checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, ::std::string& iceP_reason, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto result = _makePromiseOutgoing<::Glacier2::PermissionsVerifier::CheckPermissionsResult>(true, this, &Glacier2::PermissionsVerifierPrx::_iceI_checkPermissions, iceP_userId, iceP_password, context).get();
        iceP_reason = ::std::move(result.reason);
        return result.returnValue;
    }

    template<template<typename> class P = ::std::promise>
    auto checkPermissionsAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Glacier2::PermissionsVerifier::CheckPermissionsResult>>().get_future())
    {
        return _makePromiseOutgoing<::Glacier2::PermissionsVerifier::CheckPermissionsResult, P>(false, this, &Glacier2::PermissionsVerifierPrx::_iceI_checkPermissions, iceP_userId, iceP_password, context);
    }

    ::std::function<void()>
    checkPermissionsAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password,
                          ::std::function<void(bool, ::std::string)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto responseCb = [response](::Glacier2::PermissionsVerifier::CheckPermissionsResult&& result)
        {
            response(result.returnValue, ::std::move(result.reason));
        };
        return _makeLamdaOutgoing<::Glacier2::PermissionsVerifier::CheckPermissionsResult>(responseCb, ex, sent, this, &Glacier2::PermissionsVerifierPrx::_iceI_checkPermissions, iceP_userId, iceP_password, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_checkPermissions(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Glacier2::PermissionsVerifier::CheckPermissionsResult>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    PermissionsVerifierPrx() = default;
    friend ::std::shared_ptr<PermissionsVerifierPrx> IceInternal::createProxy<PermissionsVerifierPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(GLACIER2_API) SSLPermissionsVerifierPrx : public virtual ::Ice::Proxy<SSLPermissionsVerifierPrx, ::Ice::ObjectPrx>
{
public:

    bool authorize(const ::Glacier2::SSLInfo& iceP_info, ::std::string& iceP_reason, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto result = _makePromiseOutgoing<::Glacier2::SSLPermissionsVerifier::AuthorizeResult>(true, this, &Glacier2::SSLPermissionsVerifierPrx::_iceI_authorize, iceP_info, context).get();
        iceP_reason = ::std::move(result.reason);
        return result.returnValue;
    }

    template<template<typename> class P = ::std::promise>
    auto authorizeAsync(const ::Glacier2::SSLInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Glacier2::SSLPermissionsVerifier::AuthorizeResult>>().get_future())
    {
        return _makePromiseOutgoing<::Glacier2::SSLPermissionsVerifier::AuthorizeResult, P>(false, this, &Glacier2::SSLPermissionsVerifierPrx::_iceI_authorize, iceP_info, context);
    }

    ::std::function<void()>
    authorizeAsync(const ::Glacier2::SSLInfo& iceP_info,
                   ::std::function<void(bool, ::std::string)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto responseCb = [response](::Glacier2::SSLPermissionsVerifier::AuthorizeResult&& result)
        {
            response(result.returnValue, ::std::move(result.reason));
        };
        return _makeLamdaOutgoing<::Glacier2::SSLPermissionsVerifier::AuthorizeResult>(responseCb, ex, sent, this, &Glacier2::SSLPermissionsVerifierPrx::_iceI_authorize, iceP_info, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_authorize(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Glacier2::SSLPermissionsVerifier::AuthorizeResult>>&, const ::Glacier2::SSLInfo&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    SSLPermissionsVerifierPrx() = default;
    friend ::std::shared_ptr<SSLPermissionsVerifierPrx> IceInternal::createProxy<SSLPermissionsVerifierPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<typename S>
struct StreamReader<::Glacier2::PermissionDeniedException, S>
{
    static void read(S* istr, ::Glacier2::PermissionDeniedException& v)
    {
        istr->readAll(v.reason);
    }
};

}

namespace Glacier2
{

using PermissionsVerifierPtr = ::std::shared_ptr<PermissionsVerifier>;
using PermissionsVerifierPrxPtr = ::std::shared_ptr<PermissionsVerifierPrx>;

using SSLPermissionsVerifierPtr = ::std::shared_ptr<SSLPermissionsVerifier>;
using SSLPermissionsVerifierPrxPtr = ::std::shared_ptr<SSLPermissionsVerifierPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace Glacier2
{

class PermissionsVerifier;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::PermissionsVerifier>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::PermissionsVerifier*);

class SSLPermissionsVerifier;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SSLPermissionsVerifier>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::SSLPermissionsVerifier*);

}

}

namespace Glacier2
{

class PermissionsVerifier;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::PermissionsVerifier*);
typedef ::IceInternal::Handle< ::Glacier2::PermissionsVerifier> PermissionsVerifierPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::PermissionsVerifier> PermissionsVerifierPrx;
typedef PermissionsVerifierPrx PermissionsVerifierPrxPtr;
GLACIER2_API void _icePatchObjectPtr(PermissionsVerifierPtr&, const ::Ice::ObjectPtr&);

class SSLPermissionsVerifier;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::SSLPermissionsVerifier*);
typedef ::IceInternal::Handle< ::Glacier2::SSLPermissionsVerifier> SSLPermissionsVerifierPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SSLPermissionsVerifier> SSLPermissionsVerifierPrx;
typedef SSLPermissionsVerifierPrx SSLPermissionsVerifierPrxPtr;
GLACIER2_API void _icePatchObjectPtr(SSLPermissionsVerifierPtr&, const ::Ice::ObjectPtr&);

}

namespace Glacier2
{

class GLACIER2_API PermissionDeniedException : public ::Ice::UserException
{
public:

    PermissionDeniedException() {}
    explicit PermissionDeniedException(const ::std::string&);
    virtual ~PermissionDeniedException() throw();

    virtual ::std::string ice_id() const;
    virtual PermissionDeniedException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

    virtual ::Ice::SlicedDataPtr ice_getSlicedData() const;

    virtual void _write(::Ice::OutputStream*) const;
    virtual void _read(::Ice::InputStream*);
    using ::Ice::UserException::_write;
    using ::Ice::UserException::_read;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);

    ::Ice::SlicedDataPtr _slicedData;
};

static PermissionDeniedException _iceS_PermissionDeniedException_init;

}

namespace Glacier2
{

class Callback_PermissionsVerifier_checkPermissions_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PermissionsVerifier_checkPermissions_Base> Callback_PermissionsVerifier_checkPermissionsPtr;

class Callback_SSLPermissionsVerifier_authorize_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SSLPermissionsVerifier_authorize_Base> Callback_SSLPermissionsVerifier_authorizePtr;

}

namespace IceProxy
{

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) PermissionsVerifier : public virtual ::Ice::Proxy<PermissionsVerifier, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) bool checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, ::std::string& iceP_reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_checkPermissions(iceP_reason, _iceI_begin_checkPermissions(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_checkPermissions(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(iceP_userId, iceP_password, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Glacier2::Callback_PermissionsVerifier_checkPermissionsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::Glacier2::Callback_PermissionsVerifier_checkPermissionsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(iceP_userId, iceP_password, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) bool end_checkPermissions(::std::string& iceP_reason, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_checkPermissions(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(GLACIER2_API) SSLPermissionsVerifier : public virtual ::Ice::Proxy<SSLPermissionsVerifier, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) bool authorize(const ::Glacier2::SSLInfo& iceP_info, ::std::string& iceP_reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_authorize(iceP_reason, _iceI_begin_authorize(iceP_info, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_authorize(iceP_info, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& iceP_info, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& iceP_info, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(iceP_info, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::Callback_SSLPermissionsVerifier_authorizePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& iceP_info, const ::Ice::Context& context, const ::Glacier2::Callback_SSLPermissionsVerifier_authorizePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(iceP_info, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) bool end_authorize(::std::string& iceP_reason, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_authorize(const ::Glacier2::SSLInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace Glacier2
{

class GLACIER2_API PermissionsVerifier : public virtual ::Ice::Object
{
public:

    typedef PermissionsVerifierPrx ProxyType;
    typedef PermissionsVerifierPtr PointerType;

    virtual ~PermissionsVerifier();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual bool checkPermissions(const ::std::string&, const ::std::string&, ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_checkPermissions(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const PermissionsVerifier& lhs, const PermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const PermissionsVerifier& lhs, const PermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class GLACIER2_API SSLPermissionsVerifier : public virtual ::Ice::Object
{
public:

    typedef SSLPermissionsVerifierPrx ProxyType;
    typedef SSLPermissionsVerifierPtr PointerType;

    virtual ~SSLPermissionsVerifier();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual bool authorize(const ::Glacier2::SSLInfo&, ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_authorize(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const SSLPermissionsVerifier& lhs, const SSLPermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SSLPermissionsVerifier& lhs, const SSLPermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::PermissionDeniedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::Glacier2::PermissionDeniedException, S>
{
    static void write(S* ostr, const ::Glacier2::PermissionDeniedException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::Glacier2::PermissionDeniedException, S>
{
    static void read(S* istr, ::Glacier2::PermissionDeniedException& v)
    {
        istr->read(v.reason);
    }
};

}

namespace Glacier2
{

template<class T>
class CallbackNC_PermissionsVerifier_checkPermissions : public Callback_PermissionsVerifier_checkPermissions_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool, const ::std::string&);

    CallbackNC_PermissionsVerifier_checkPermissions(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::PermissionsVerifierPrx proxy = ::Glacier2::PermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_checkPermissions(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_reason);
        }
    }

private:

    Response _response;
};

template<class T> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PermissionsVerifier_checkPermissions<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(T* instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PermissionsVerifier_checkPermissions<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_PermissionsVerifier_checkPermissions : public Callback_PermissionsVerifier_checkPermissions_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const ::std::string&, const CT&);

    Callback_PermissionsVerifier_checkPermissions(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::PermissionsVerifierPrx proxy = ::Glacier2::PermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_checkPermissions(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_reason, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PermissionsVerifier_checkPermissions<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(T* instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PermissionsVerifier_checkPermissions<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SSLPermissionsVerifier_authorize : public Callback_SSLPermissionsVerifier_authorize_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool, const ::std::string&);

    CallbackNC_SSLPermissionsVerifier_authorize(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SSLPermissionsVerifierPrx proxy = ::Glacier2::SSLPermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_authorize(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_reason);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLPermissionsVerifier_authorize<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(T* instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLPermissionsVerifier_authorize<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SSLPermissionsVerifier_authorize : public Callback_SSLPermissionsVerifier_authorize_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const ::std::string&, const CT&);

    Callback_SSLPermissionsVerifier_authorize(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SSLPermissionsVerifierPrx proxy = ::Glacier2::SSLPermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_authorize(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_reason, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLPermissionsVerifier_authorize<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(T* instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLPermissionsVerifier_authorize<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
