/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen.target;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.Target;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.ast.GrammarAST;
import org.stringtemplate.v4.NumberRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.misc.STMessage;

public class CppTarget
extends Target {
    protected static final String[] cppKeywords = new String[]{"alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "concept", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"};
    protected final Set<String> badWords = new HashSet<String>();

    public CppTarget(CodeGenerator gen) {
        super(gen, "Cpp");
    }

    @Override
    public String getVersion() {
        return "4.6";
    }

    @Override
    public boolean needsHeader() {
        return true;
    }

    public Set<String> getBadWords() {
        if (this.badWords.isEmpty()) {
            this.addBadWords();
        }
        return this.badWords;
    }

    protected void addBadWords() {
        this.badWords.addAll(Arrays.asList(cppKeywords));
        this.badWords.add("rule");
        this.badWords.add("parserRule");
    }

    @Override
    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        StringBuilder sb = new StringBuilder();
        String is = literal;
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 1; i < is.length() - 1; ++i) {
            if (is.charAt(i) == '\\') {
                switch (is.charAt(i + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        sb.append('\\');
                        break;
                    }
                    case 'u': {
                        sb.append('\\');
                        sb.append('\\');
                        break;
                    }
                }
                ++i;
            } else if (is.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(is.charAt(i));
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    @Override
    public String encodeIntAsCharEscape(int v) {
        return "0x" + Integer.toHexString(v) + ", ";
    }

    @Override
    public int getSerializedATNSegmentLimit() {
        return 21845;
    }

    @Override
    public String getRecognizerFileName(boolean header) {
        ST extST = this.getTemplates().getInstanceOf(header ? "headerFileExtension" : "codeFileExtension");
        String recognizerName = this.gen.g.getRecognizerName();
        return recognizerName + extST.render();
    }

    @Override
    public String getListenerFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf(header ? "headerFileExtension" : "codeFileExtension");
        String listenerName = this.gen.g.name + "Listener";
        return listenerName + extST.render();
    }

    @Override
    public String getVisitorFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf(header ? "headerFileExtension" : "codeFileExtension");
        String listenerName = this.gen.g.name + "Visitor";
        return listenerName + extST.render();
    }

    @Override
    public String getBaseListenerFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf(header ? "headerFileExtension" : "codeFileExtension");
        String listenerName = this.gen.g.name + "BaseListener";
        return listenerName + extST.render();
    }

    @Override
    public String getBaseVisitorFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf(header ? "headerFileExtension" : "codeFileExtension");
        String listenerName = this.gen.g.name + "BaseVisitor";
        return listenerName + extST.render();
    }

    @Override
    protected boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        return this.getBadWords().contains(idNode.getText());
    }

    @Override
    protected STGroup loadTemplates() {
        STGroup result = super.loadTemplates();
        result.registerRenderer(Integer.class, new NumberRenderer());
        result.registerRenderer(String.class, new StringRenderer());
        result.setListener(new STErrorListener(){

            @Override
            public void compileTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void runTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void IOError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void internalError(STMessage msg) {
                this.reportError(msg);
            }

            private void reportError(STMessage msg) {
                CppTarget.this.getCodeGenerator().tool.errMgr.toolError(ErrorType.STRING_TEMPLATE_WARNING, msg.cause, msg.toString());
            }
        });
        return result;
    }
}

