/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationMethodInfoWithAnnotations;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithAnnotations;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;

public class AnnotationMethodInfo
extends MethodInfo {
    protected Object defaultValue = null;

    public static MethodInfo createAnnotationMethod(byte[] byArray, int[] nArray, int n) {
        MethodInfo methodInfo = new MethodInfo(byArray, nArray, n);
        int n2 = methodInfo.u2At(6);
        int n3 = 8;
        AnnotationInfo[] annotationInfoArray = null;
        Object object = null;
        for (int i = 0; i < n2; ++i) {
            int n4 = methodInfo.constantPoolOffsets[methodInfo.u2At(n3)] - methodInfo.structOffset;
            char[] cArray = methodInfo.utf8At(n4 + 3, methodInfo.u2At(n4 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'A': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.AnnotationDefaultName)) break;
                        Object object2 = new AnnotationInfo(methodInfo.reference, methodInfo.constantPoolOffsets, n3 + 6 + methodInfo.structOffset);
                        object = ((AnnotationInfo)object2).decodeDefaultValue();
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        methodInfo.signatureUtf8Offset = methodInfo.constantPoolOffsets[methodInfo.u2At(n3 + 6)] - methodInfo.structOffset;
                        break;
                    }
                    case 'R': {
                        Object object2 = null;
                        if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                            object2 = AnnotationMethodInfo.decodeMethodAnnotations(n3, true, methodInfo);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                            object2 = AnnotationMethodInfo.decodeMethodAnnotations(n3, false, methodInfo);
                        }
                        if (object2 == null) break;
                        if (annotationInfoArray == null) {
                            annotationInfoArray = object2;
                            break;
                        }
                        int n5 = annotationInfoArray.length;
                        AnnotationInfo[] annotationInfoArray2 = new AnnotationInfo[n5 + ((Object)object2).length];
                        System.arraycopy(annotationInfoArray, 0, annotationInfoArray2, 0, n5);
                        System.arraycopy(object2, 0, annotationInfoArray2, n5, ((Object)object2).length);
                        annotationInfoArray = annotationInfoArray2;
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + methodInfo.u4At(n3 + 2)));
        }
        methodInfo.attributeBytes = n3;
        if (object != null) {
            if (annotationInfoArray != null) {
                return new AnnotationMethodInfoWithAnnotations(methodInfo, object, annotationInfoArray);
            }
            return new AnnotationMethodInfo(methodInfo, object);
        }
        if (annotationInfoArray != null) {
            return new MethodInfoWithAnnotations(methodInfo, annotationInfoArray);
        }
        return methodInfo;
    }

    AnnotationMethodInfo(MethodInfo methodInfo, Object object) {
        super(methodInfo.reference, methodInfo.constantPoolOffsets, methodInfo.structOffset);
        this.defaultValue = object;
        this.accessFlags = methodInfo.accessFlags;
        this.attributeBytes = methodInfo.attributeBytes;
        this.descriptor = methodInfo.descriptor;
        this.exceptionNames = methodInfo.exceptionNames;
        this.name = methodInfo.name;
        this.signature = methodInfo.signature;
        this.signatureUtf8Offset = methodInfo.signatureUtf8Offset;
        this.tagBits = methodInfo.tagBits;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected void toStringContent(StringBuffer stringBuffer) {
        super.toStringContent(stringBuffer);
        if (this.defaultValue != null) {
            stringBuffer.append(" default ");
            if (this.defaultValue instanceof Object[]) {
                stringBuffer.append('{');
                Object[] objectArray = (Object[])this.defaultValue;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(objectArray[i]);
                }
                stringBuffer.append('}');
            } else {
                stringBuffer.append(this.defaultValue);
            }
            stringBuffer.append('\n');
        }
    }
}

