/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.maildir;

import gnu.mail.providers.maildir.MaildirMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;

public final class MaildirFolder
extends Folder {
    static final FilenameFilter filter = new MaildirFilter();
    static final String INBOX = "INBOX";
    File maildir;
    File tmpdir;
    MaildirTuple newdir;
    MaildirTuple curdir;
    int type;
    boolean inbox;
    static Flags permanentFlags = new Flags();
    static long deliveryCount = 0L;

    protected MaildirFolder(Store store, String filename, boolean root, boolean inbox) {
        super(store);
        this.maildir = new File(filename);
        this.tmpdir = new File(this.maildir, "tmp");
        this.newdir = new MaildirTuple(new File(this.maildir, "new"));
        this.curdir = new MaildirTuple(new File(this.maildir, "cur"));
        this.mode = -1;
        this.type = root ? 2 : 1;
        this.inbox = inbox;
    }

    protected MaildirFolder(Store store, String filename) {
        this(store, filename, false, false);
    }

    public String getName() {
        if (this.inbox) {
            return INBOX;
        }
        return this.maildir.getName();
    }

    public String getFullName() {
        if (this.inbox) {
            return INBOX;
        }
        return this.maildir.getPath();
    }

    public URLName getURLName() throws MessagingException {
        URLName url = super.getURLName();
        return new URLName(url.getProtocol(), null, -1, url.getFile(), null, null);
    }

    public int getType() throws MessagingException {
        return this.type;
    }

    public boolean exists() throws MessagingException {
        return this.maildir.exists();
    }

    public boolean hasNewMessages() throws MessagingException {
        return this.getNewMessageCount() > 0;
    }

    public void open(int mode) throws MessagingException {
        if (this.mode != -1) {
            throw new IllegalStateException("Folder is open");
        }
        if (!this.maildir.exists() || !this.maildir.canRead()) {
            throw new FolderNotFoundException((Folder)this);
        }
        boolean success = true;
        if (!this.tmpdir.exists()) {
            boolean bl = success = success && this.tmpdir.mkdirs();
        }
        if (!this.newdir.dir.exists()) {
            boolean bl = success = success && this.newdir.dir.mkdirs();
        }
        if (!this.curdir.dir.exists()) {
            boolean bl = success = success && this.curdir.dir.mkdirs();
        }
        if (!success) {
            throw new MessagingException("Unable to create directories");
        }
        if (mode == 2 && !this.maildir.canWrite()) {
            throw new MessagingException("Folder is read-only");
        }
        this.mode = mode;
        this.notifyConnectionListeners(1);
    }

    public void close(boolean expunge) throws MessagingException {
        if (this.mode == -1) {
            throw new IllegalStateException("Folder is closed");
        }
        if (expunge) {
            this.expunge();
        }
        this.mode = -1;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] expunge() throws MessagingException {
        Message[] expunged;
        if (this.mode == -1) {
            throw new IllegalStateException("Folder is closed");
        }
        if (!this.exists()) {
            throw new FolderNotFoundException((Folder)this);
        }
        if (this.mode == 1) {
            throw new IllegalWriteException();
        }
        MaildirFolder maildirFolder = this;
        synchronized (maildirFolder) {
            ArrayList<MaildirMessage> elist = new ArrayList<MaildirMessage>();
            try {
                if (this.newdir.messages != null) {
                    for (MaildirMessage message : this.newdir.messages) {
                        if (!message.getFlags().contains(Flags.Flag.DELETED)) continue;
                        message.file.delete();
                        elist.add(message);
                    }
                }
                if (this.curdir.messages != null) {
                    for (MaildirMessage message : this.curdir.messages) {
                        if (!message.getFlags().contains(Flags.Flag.DELETED)) continue;
                        message.file.delete();
                        elist.add(message);
                    }
                }
            }
            catch (SecurityException e) {
                throw new IllegalWriteException(e.getMessage());
            }
            expunged = new Message[elist.size()];
            elist.toArray(expunged);
        }
        if (expunged.length > 0) {
            this.notifyMessageRemovedListeners(true, expunged);
        }
        return expunged;
    }

    public boolean isOpen() {
        return this.mode != -1;
    }

    public Flags getPermanentFlags() {
        return permanentFlags;
    }

    public synchronized int getMessageCount() throws MessagingException {
        this.statDir(this.curdir);
        this.statDir(this.newdir);
        return this.curdir.messages.length + this.newdir.messages.length;
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.statDir(this.newdir);
        return this.newdir.messages.length;
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        this.statDir(this.curdir);
        this.statDir(this.newdir);
        int clen = this.curdir.messages.length;
        int alen = clen + this.newdir.messages.length;
        int index = msgnum - 1;
        if (index < 0 || index >= alen) {
            throw new MessagingException("No such message: " + msgnum);
        }
        if (index < clen) {
            return this.curdir.messages[index];
        }
        return this.newdir.messages[index - clen];
    }

    public synchronized Message[] getMessages() throws MessagingException {
        this.statDir(this.curdir);
        this.statDir(this.newdir);
        int clen = this.curdir.messages.length;
        int nlen = this.newdir.messages.length;
        int alen = clen + nlen;
        Message[] m = new Message[alen];
        System.arraycopy(this.curdir.messages, 0, m, 0, clen);
        System.arraycopy(this.newdir.messages, 0, m, clen, nlen);
        return m;
    }

    void statDir(MaildirTuple dir) throws MessagingException {
        long timestamp = dir.dir.lastModified();
        if (timestamp == dir.timestamp) {
            return;
        }
        File[] files = dir.dir.listFiles(filter);
        int mlen = files.length;
        dir.messages = new MaildirMessage[mlen];
        for (int i = 0; i < mlen; ++i) {
            File file = files[i];
            String uniq = file.getName();
            String info = null;
            int ci = uniq.indexOf(58);
            if (ci != -1) {
                info = uniq.substring(ci + 1);
                uniq = uniq.substring(0, ci);
            }
            dir.messages[i] = new MaildirMessage(this, file, uniq, info, i + 1);
        }
        dir.timestamp = timestamp;
    }

    void setSeen(MaildirMessage message, boolean seen) throws MessagingException {
        File src = message.file;
        File dst = null;
        if (seen) {
            String dstname = new StringBuffer(message.uniq).append(':').append(message.getInfo()).toString();
            dst = new File(this.curdir.dir, dstname);
        } else {
            dst = new File(this.newdir.dir, message.uniq);
        }
        if (!src.renameTo(dst)) {
            throw new MessagingException("Unable to move message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendMessages(Message[] m) throws MessagingException {
        MaildirMessage[] n;
        MaildirFolder maildirFolder = this;
        synchronized (maildirFolder) {
            this.statDir(this.newdir);
            this.statDir(this.curdir);
            int nlen = this.newdir.messages.length;
            int clen = this.curdir.messages.length;
            ArrayList<MaildirMessage> appended = new ArrayList<MaildirMessage>(m.length);
            for (int i = 0; i < m.length; ++i) {
                if (!(m[i] instanceof MimeMessage)) continue;
                MimeMessage src = (MimeMessage)m[i];
                Flags flags = src.getFlags();
                boolean seen = flags.contains(Flags.Flag.SEEN);
                int count = seen ? ++clen : ++nlen;
                try {
                    String uniq;
                    String tmpname = uniq = MaildirFolder.createUniq();
                    String info = null;
                    if (seen) {
                        info = MaildirMessage.getInfo(flags);
                        tmpname = new StringBuffer(uniq).append(':').append(info).toString();
                    }
                    File tmpfile = new File(this.tmpdir, tmpname);
                    long time = System.currentTimeMillis();
                    long timeout = time + 86400000L;
                    while (time < timeout && tmpfile.exists()) {
                        try {
                            ((Object)((Object)this)).wait(2000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        time = System.currentTimeMillis();
                    }
                    if (!tmpfile.createNewFile()) {
                        throw new MessagingException("Temporary file already exists");
                    }
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpfile));
                    src.writeTo((OutputStream)out);
                    ((OutputStream)out).close();
                    File file = new File(seen ? this.curdir.dir : this.newdir.dir, tmpname);
                    tmpfile.renameTo(file);
                    tmpfile.delete();
                    MaildirMessage dst = new MaildirMessage(this, file, uniq, info, count);
                    appended.add(dst);
                    continue;
                }
                catch (IOException e) {
                    throw new MessagingException(e.getMessage(), (Exception)e);
                }
                catch (SecurityException e) {
                    throw new IllegalWriteException(e.getMessage());
                }
            }
            n = new MaildirMessage[appended.size()];
            if (n.length > 0) {
                appended.toArray(n);
            }
        }
        if (n.length > 0) {
            this.notifyMessageAddedListeners((Message[])n);
        }
    }

    static String createUniq() throws MessagingException, IOException {
        long time = System.currentTimeMillis() / 1000L;
        long pid = 0L;
        File urandom = new File("/dev/urandom");
        if (urandom.exists() && urandom.canRead()) {
            byte[] bytes = new byte[8];
            FileInputStream in = new FileInputStream(urandom);
            for (int offset = 0; offset < bytes.length; offset += ((InputStream)in).read(bytes, offset, bytes.length - offset)) {
            }
            ((InputStream)in).close();
            for (int i = 0; i < bytes.length; ++i) {
                pid |= (long)bytes[i] * (long)Math.pow(i, 2.0);
            }
        } else {
            pid += ++deliveryCount;
        }
        String host = InetAddress.getLocalHost().getHostName();
        return new StringBuffer().append(time).append('.').append(pid).append('.').append(host).toString();
    }

    public Folder getParent() throws MessagingException {
        return this.store.getFolder(this.maildir.getParent());
    }

    public Folder[] list() throws MessagingException {
        if (this.type != 2) {
            throw new MessagingException("This folder can't contain subfolders");
        }
        try {
            String[] files = this.maildir.list();
            Folder[] folders = new Folder[files.length];
            for (int i = 0; i < files.length; ++i) {
                folders[i] = this.store.getFolder(this.maildir.getAbsolutePath() + File.separator + files[i]);
            }
            return folders;
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    public Folder[] list(String pattern) throws MessagingException {
        if (this.type != 2) {
            throw new MessagingException("This folder can't contain subfolders");
        }
        try {
            String[] files = this.maildir.list(new MaildirListFilter(pattern));
            Folder[] folders = new Folder[files.length];
            for (int i = 0; i < files.length; ++i) {
                folders[i] = this.store.getFolder(this.maildir.getAbsolutePath() + File.separator + files[i]);
            }
            return folders;
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    public char getSeparator() throws MessagingException {
        return File.separatorChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(int type) throws MessagingException {
        if (this.maildir.exists()) {
            throw new MessagingException("Folder already exists");
        }
        switch (type) {
            case 2: {
                try {
                    if (!this.maildir.mkdirs()) {
                        return false;
                    }
                    this.type = type;
                    this.notifyFolderListeners(1);
                    return true;
                }
                catch (SecurityException e) {
                    throw new MessagingException("Access denied", (Exception)e);
                }
            }
            case 1: {
                try {
                    boolean success = true;
                    MaildirFolder maildirFolder = this;
                    synchronized (maildirFolder) {
                        success = success && this.maildir.mkdirs();
                        success = success && this.tmpdir.mkdirs();
                        success = success && this.newdir.dir.mkdirs();
                        success = success && this.curdir.dir.mkdirs();
                    }
                    if (!success) {
                        return false;
                    }
                    this.type = type;
                    this.notifyFolderListeners(1);
                    return true;
                }
                catch (SecurityException e) {
                    throw new MessagingException("Access denied", (Exception)e);
                }
            }
        }
        return false;
    }

    public boolean delete(boolean recurse) throws MessagingException {
        if (recurse) {
            try {
                if (this.type == 2) {
                    Folder[] folders = this.list();
                    for (int i = 0; i < folders.length; ++i) {
                        if (folders[i].delete(recurse)) continue;
                        return false;
                    }
                }
                if (!this.delete(this.maildir)) {
                    return false;
                }
                this.notifyFolderListeners(2);
                return true;
            }
            catch (SecurityException e) {
                throw new MessagingException("Access denied", (Exception)e);
            }
        }
        try {
            Folder[] folders;
            if (this.type == 2 && (folders = this.list()).length > 0) {
                return false;
            }
            if (!this.delete(this.maildir)) {
                return false;
            }
            this.notifyFolderListeners(2);
            return true;
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    boolean delete(File file) throws SecurityException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (this.delete(files[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        try {
            String filename = folder.getFullName();
            if (filename != null) {
                if (!this.maildir.renameTo(new File(filename))) {
                    return false;
                }
                this.notifyFolderRenamedListeners(folder);
                return true;
            }
            throw new MessagingException("Illegal filename: null");
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    public Folder getFolder(String filename) throws MessagingException {
        if (INBOX.equalsIgnoreCase(filename)) {
            try {
                return this.store.getFolder(INBOX);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.store.getFolder(this.maildir.getAbsolutePath() + File.separator + filename);
    }

    class MaildirListFilter
    implements FilenameFilter {
        String pattern;
        int asteriskIndex;
        int percentIndex;

        MaildirListFilter(String pattern) {
            this.pattern = pattern;
            this.asteriskIndex = pattern.indexOf(42);
            this.percentIndex = pattern.indexOf(37);
        }

        @Override
        public boolean accept(File directory, String name) {
            if (this.asteriskIndex > -1) {
                String start = this.pattern.substring(0, this.asteriskIndex);
                String end = this.pattern.substring(this.asteriskIndex + 1, this.pattern.length());
                return name.startsWith(start) && name.endsWith(end);
            }
            if (this.percentIndex > -1) {
                String start = this.pattern.substring(0, this.percentIndex);
                String end = this.pattern.substring(this.percentIndex + 1, this.pattern.length());
                return directory.equals(MaildirFolder.this.maildir) && name.startsWith(start) && name.endsWith(end);
            }
            return name.equals(this.pattern);
        }
    }

    static class MaildirTuple {
        File dir;
        long timestamp = 0L;
        MaildirMessage[] messages = null;

        MaildirTuple(File dir) {
            this.dir = dir;
        }
    }

    static class MaildirFilter
    implements FilenameFilter {
        MaildirFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.length() > 0 && name.charAt(0) != '.';
        }
    }
}

