/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private byte[] buffer;
    private int buflen;
    private int index;
    private byte[] decodeBuf = new byte[4];
    private static final char[] src;
    private static final byte[] dst;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int EQ = 61;

    public Base64InputStream(InputStream in) {
        super(in);
        this.buffer = new byte[3];
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.buflen) {
            this.decode();
            if (this.buflen == 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int l;
            for (l = 0; l < len; ++l) {
                int c = this.read();
                if (c == -1) {
                    if (l != 0) break;
                    l = -1;
                    break;
                }
                b[off + l] = (byte)c;
            }
            return l;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.buflen - this.index);
    }

    private void decode() throws IOException {
        int l;
        int c;
        this.buflen = 0;
        do {
            if ((c = this.in.read()) != -1) continue;
            return;
        } while (c == 10 || c == 13);
        this.decodeBuf[0] = (byte)c;
        int j = 3;
        int k = 1;
        while ((l = this.in.read(this.decodeBuf, k, j)) != j) {
            if (l == -1) {
                throw new IOException("Base64 encoding error");
            }
            j -= l;
            k += l;
        }
        byte b0 = dst[this.decodeBuf[0] & 0xFF];
        byte b2 = dst[this.decodeBuf[1] & 0xFF];
        this.buffer[this.buflen++] = (byte)(b0 << 2 & 0xFC | b2 >>> 4 & 3);
        if (this.decodeBuf[2] != 61) {
            b0 = b2;
            b2 = dst[this.decodeBuf[2] & 0xFF];
            this.buffer[this.buflen++] = (byte)(b0 << 4 & 0xF0 | b2 >>> 2 & 0xF);
            if (this.decodeBuf[3] != 61) {
                b0 = b2;
                b2 = dst[this.decodeBuf[3] & 0xFF];
                this.buffer[this.buflen++] = (byte)(b0 << 6 & 0xC0 | b2 & 0x3F);
            }
        }
    }

    static {
        int i;
        src = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        dst = new byte[256];
        for (i = 0; i < 255; ++i) {
            Base64InputStream.dst[i] = -1;
        }
        for (i = 0; i < src.length; ++i) {
            Base64InputStream.dst[Base64InputStream.src[i]] = (byte)i;
        }
    }
}

