/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Hashing;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MIN_SEGMENT_TABLE_CAPACITY = 2;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    private final transient int hashSeed = ConcurrentHashMap.randomHashSeed(this);
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    private static final Unsafe UNSAFE;
    private static final long SBASE;
    private static final int SSHIFT;
    private static final long TBASE;
    private static final int TSHIFT;
    private static final long HASHSEED_OFFSET;
    private static final long SEGSHIFT_OFFSET;
    private static final long SEGMASK_OFFSET;
    private static final long SEGMENTS_OFFSET;

    private static int randomHashSeed(ConcurrentHashMap instance) {
        if (VM.isBooted() && Holder.ALTERNATIVE_HASHING) {
            return Hashing.randomHashSeed(instance);
        }
        return 0;
    }

    static final <K, V> HashEntry<K, V> entryAt(HashEntry<K, V>[] tab, int i) {
        return tab == null ? null : (HashEntry)UNSAFE.getObjectVolatile(tab, ((long)i << TSHIFT) + TBASE);
    }

    static final <K, V> void setEntryAt(HashEntry<K, V>[] tab, int i, HashEntry<K, V> e) {
        UNSAFE.putOrderedObject(tab, ((long)i << TSHIFT) + TBASE, e);
    }

    private int hash(Object k) {
        int h = this.hashSeed;
        if (0 != h && k instanceof String) {
            return Hashing.stringHash32((String)k);
        }
        h ^= k.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    static final <K, V> Segment<K, V> segmentAt(Segment<K, V>[] ss, int j) {
        long u = (long)(j << SSHIFT) + SBASE;
        return ss == null ? null : (Segment)UNSAFE.getObjectVolatile(ss, u);
    }

    private Segment<K, V> ensureSegment(int k) {
        Segment seg;
        block2: {
            Segment<K, V>[] ss = this.segments;
            long u = (long)(k << SSHIFT) + SBASE;
            seg = (Segment)UNSAFE.getObjectVolatile(ss, u);
            if (seg != null) break block2;
            Segment<K, V> proto = ss[0];
            int cap = proto.table.length;
            float lf = proto.loadFactor;
            int threshold = (int)((float)cap * lf);
            HashEntry[] tab = new HashEntry[cap];
            seg = (Segment)UNSAFE.getObjectVolatile(ss, u);
            if (seg == null) {
                Segment s = new Segment(lf, threshold, tab);
                while ((seg = (Segment)UNSAFE.getObjectVolatile(ss, u)) == null && !UNSAFE.compareAndSwapObject(ss, u, null, seg = s)) {
                }
            }
        }
        return seg;
    }

    private Segment<K, V> segmentForHash(int h) {
        long u = (long)((h >>> this.segmentShift & this.segmentMask) << SSHIFT) + SBASE;
        return (Segment)UNSAFE.getObjectVolatile(this.segments, u);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final <K, V> HashEntry<K, V> entryForHash(Segment<K, V> seg, int h) {
        if (seg == null) return null;
        HashEntry<K, V>[] tab = seg.table;
        if (seg.table == null) {
            return null;
        }
        HashEntry hashEntry = (HashEntry)UNSAFE.getObjectVolatile(tab, ((long)(tab.length - 1 & h) << TSHIFT) + TBASE);
        return hashEntry;
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 2; cap < c; cap <<= 1) {
        }
        Segment s0 = new Segment(loadFactor, (int)((float)cap * loadFactor), new HashEntry[cap]);
        Segment[] ss = new Segment[ssize];
        UNSAFE.putOrderedObject(ss, SBASE, s0);
        this.segments = ss;
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        Segment<K, V> seg;
        int j;
        long sum = 0L;
        Segment<K, V>[] segments = this.segments;
        for (j = 0; j < segments.length; ++j) {
            seg = ConcurrentHashMap.segmentAt(segments, j);
            if (seg == null) continue;
            if (seg.count != 0) {
                return false;
            }
            sum += (long)seg.modCount;
        }
        if (sum != 0L) {
            for (j = 0; j < segments.length; ++j) {
                seg = ConcurrentHashMap.segmentAt(segments, j);
                if (seg == null) continue;
                if (seg.count != 0) {
                    return false;
                }
                sum -= (long)seg.modCount;
            }
            if (sum != 0L) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        boolean overflow;
        int size;
        int j;
        Segment<K, V>[] segments = this.segments;
        long last = 0L;
        int retries = -1;
        try {
            while (true) {
                if (retries++ == 2) {
                    for (j = 0; j < segments.length; ++j) {
                        this.ensureSegment(j).lock();
                    }
                }
                long sum = 0L;
                size = 0;
                overflow = false;
                for (j = 0; j < segments.length; ++j) {
                    Segment<K, V> seg = ConcurrentHashMap.segmentAt(segments, j);
                    if (seg == null) continue;
                    sum += (long)seg.modCount;
                    int c = seg.count;
                    if (c >= 0 && (size += c) >= 0) continue;
                    overflow = true;
                }
                if (sum == last) {
                    break;
                }
                last = sum;
            }
        }
        finally {
            if (retries > 2) {
                for (j = 0; j < segments.length; ++j) {
                    ConcurrentHashMap.segmentAt(segments, j).unlock();
                }
            }
        }
        return overflow ? Integer.MAX_VALUE : size;
    }

    @Override
    public V get(Object key) {
        int h = this.hash(key);
        long u = (long)((h >>> this.segmentShift & this.segmentMask) << SSHIFT) + SBASE;
        Segment s = (Segment)UNSAFE.getObjectVolatile(this.segments, u);
        if (s != null) {
            HashEntry<K, V>[] tab = s.table;
            if (s.table != null) {
                HashEntry e = (HashEntry)UNSAFE.getObjectVolatile(tab, ((long)(tab.length - 1 & h) << TSHIFT) + TBASE);
                while (e != null) {
                    Object k = e.key;
                    if (k == key || e.hash == h && key.equals(k)) {
                        return e.value;
                    }
                    e = e.next;
                }
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        int h = this.hash(key);
        long u = (long)((h >>> this.segmentShift & this.segmentMask) << SSHIFT) + SBASE;
        Segment s = (Segment)UNSAFE.getObjectVolatile(this.segments, u);
        if (s != null) {
            HashEntry<K, V>[] tab = s.table;
            if (s.table != null) {
                HashEntry e = (HashEntry)UNSAFE.getObjectVolatile(tab, ((long)(tab.length - 1 & h) << TSHIFT) + TBASE);
                while (e != null) {
                    Object k = e.key;
                    if (k == key || e.hash == h && key.equals(k)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        boolean found;
        block14: {
            if (value == null) {
                throw new NullPointerException();
            }
            Segment<K, V>[] segments = this.segments;
            found = false;
            long last = 0L;
            int retries = -1;
            try {
                while (true) {
                    if (retries++ == 2) {
                        for (int j = 0; j < segments.length; ++j) {
                            this.ensureSegment(j).lock();
                        }
                    }
                    long hashSum = 0L;
                    int sum = 0;
                    for (int j = 0; j < segments.length; ++j) {
                        Segment<K, V> seg = ConcurrentHashMap.segmentAt(segments, j);
                        if (seg == null) continue;
                        HashEntry<K, V>[] tab = seg.table;
                        if (seg.table == null) continue;
                        for (int i = 0; i < tab.length; ++i) {
                            HashEntry e = ConcurrentHashMap.entryAt(tab, i);
                            while (e != null) {
                                Object v = e.value;
                                if (v != null && value.equals(v)) {
                                    found = true;
                                    break block14;
                                }
                                e = e.next;
                            }
                        }
                        sum += seg.modCount;
                    }
                    if (retries > 0 && (long)sum == last) {
                        break;
                    }
                    last = sum;
                }
            }
            finally {
                if (retries > 2) {
                    for (int j = 0; j < segments.length; ++j) {
                        ConcurrentHashMap.segmentAt(segments, j).unlock();
                    }
                }
            }
        }
        return found;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.hash(key);
        int j = hash >>> this.segmentShift & this.segmentMask;
        Segment<K, V> s = (Segment<K, V>)UNSAFE.getObject(this.segments, (long)(j << SSHIFT) + SBASE);
        if (s == null) {
            s = this.ensureSegment(j);
        }
        return s.put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.hash(key);
        int j = hash >>> this.segmentShift & this.segmentMask;
        Segment<K, V> s = (Segment<K, V>)UNSAFE.getObject(this.segments, (long)(j << SSHIFT) + SBASE);
        if (s == null) {
            s = this.ensureSegment(j);
        }
        return s.put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = this.hash(key);
        Segment<K, V> s = this.segmentForHash(hash);
        return s == null ? null : (V)s.remove(key, hash, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Segment<K, V> s;
        int hash = this.hash(key);
        return value != null && (s = this.segmentForHash(hash)) != null && s.remove(key, hash, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int hash = this.hash(key);
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Segment<K, V> s = this.segmentForHash(hash);
        return s != null && s.replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        int hash = this.hash(key);
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<K, V> s = this.segmentForHash(hash);
        return s == null ? null : (V)s.replace(key, hash, value);
    }

    @Override
    public void clear() {
        Segment<K, V>[] segments = this.segments;
        for (int j = 0; j < segments.length; ++j) {
            Segment<K, V> s = ConcurrentHashMap.segmentAt(segments, j);
            if (s == null) continue;
            s.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        for (int k = 0; k < this.segments.length; ++k) {
            this.ensureSegment(k);
        }
        s.defaultWriteObject();
        Segment<K, V>[] segments = this.segments;
        for (int k = 0; k < segments.length; ++k) {
            Segment<K, V> seg = ConcurrentHashMap.segmentAt(segments, k);
            seg.lock();
            try {
                HashEntry<K, V>[] tab = seg.table;
                for (int i = 0; i < tab.length; ++i) {
                    HashEntry e = ConcurrentHashMap.entryAt(tab, i);
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField oisFields = s.readFields();
        Segment[] oisSegments = (Segment[])oisFields.get("segments", null);
        int ssize = oisSegments.length;
        if (ssize < 1 || ssize > 65536 || (ssize & ssize - 1) != 0) {
            throw new InvalidObjectException("Bad number of segments:" + ssize);
        }
        int sshift = 0;
        for (int ssizeTmp = ssize; ssizeTmp > 1; ssizeTmp >>>= 1) {
            ++sshift;
        }
        UNSAFE.putIntVolatile(this, SEGSHIFT_OFFSET, 32 - sshift);
        UNSAFE.putIntVolatile(this, SEGMASK_OFFSET, ssize - 1);
        UNSAFE.putObjectVolatile(this, SEGMENTS_OFFSET, oisSegments);
        UNSAFE.putIntVolatile(this, HASHSEED_OFFSET, ConcurrentHashMap.randomHashSeed(this));
        int cap = 2;
        Segment<K, V>[] segments = this.segments;
        for (int k = 0; k < segments.length; ++k) {
            Segment<K, V> seg = segments[k];
            if (seg == null) continue;
            seg.threshold = (int)((float)cap * seg.loadFactor);
            seg.table = new HashEntry[cap];
        }
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    static {
        int ss;
        int ts;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<HashEntry[]> tc = HashEntry[].class;
            Class<Segment[]> sc = Segment[].class;
            TBASE = UNSAFE.arrayBaseOffset(tc);
            SBASE = UNSAFE.arrayBaseOffset(sc);
            ts = UNSAFE.arrayIndexScale(tc);
            ss = UNSAFE.arrayIndexScale(sc);
            HASHSEED_OFFSET = UNSAFE.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("hashSeed"));
            SEGSHIFT_OFFSET = UNSAFE.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("segmentShift"));
            SEGMASK_OFFSET = UNSAFE.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("segmentMask"));
            SEGMENTS_OFFSET = UNSAFE.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("segments"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if ((ss & ss - 1) != 0 || (ts & ts - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        SSHIFT = 31 - Integer.numberOfLeadingZeros(ss);
        TSHIFT = 31 - Integer.numberOfLeadingZeros(ts);
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e = super.nextEntry();
            return new WriteThroughEntry(e.key, e.value);
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            ConcurrentHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return super.nextEntry().value;
        }

        @Override
        public final V nextElement() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return super.nextEntry().key;
        }

        @Override
        public final K nextElement() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            while (true) {
                Segment seg;
                if (this.nextTableIndex >= 0) {
                    if ((this.nextEntry = ConcurrentHashMap.entryAt(this.currentTable, this.nextTableIndex--)) == null) continue;
                    break;
                }
                if (this.nextSegmentIndex < 0) break;
                if ((seg = ConcurrentHashMap.segmentAt(ConcurrentHashMap.this.segments, this.nextSegmentIndex--)) == null) continue;
                this.currentTable = seg.table;
                if (seg.table == null) continue;
                this.nextTableIndex = this.currentTable.length - 1;
            }
        }

        final HashEntry<K, V> nextEntry() {
            HashEntry e = this.nextEntry;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = e;
            this.nextEntry = e.next;
            if (this.nextEntry == null) {
                this.advance();
            }
            return e;
        }

        public final boolean hasNext() {
            return this.nextEntry != null;
        }

        public final boolean hasMoreElements() {
            return this.nextEntry != null;
        }

        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        static final int MAX_SCAN_RETRIES = Runtime.getRuntime().availableProcessors() > 1 ? 64 : 1;
        volatile transient HashEntry<K, V>[] table;
        transient int count;
        transient int modCount;
        transient int threshold;
        final float loadFactor;

        Segment(float lf, int threshold, HashEntry<K, V>[] tab) {
            this.loadFactor = lf;
            this.threshold = threshold;
            this.table = tab;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V put(K key, int hash, V value, boolean onlyIfAbsent) {
            Object oldValue;
            block10: {
                HashEntry<K, V> node = this.tryLock() ? null : this.scanAndLockForPut(key, hash, value);
                try {
                    HashEntry<K, V> first;
                    HashEntry<K, V>[] tab = this.table;
                    int index = tab.length - 1 & hash;
                    HashEntry<K, V> e = first = ConcurrentHashMap.entryAt(tab, index);
                    while (e != null) {
                        Object k = e.key;
                        if (k == key || e.hash == hash && key.equals(k)) {
                            oldValue = e.value;
                            if (!onlyIfAbsent) {
                                e.value = value;
                                ++this.modCount;
                            }
                            break block10;
                        }
                        e = e.next;
                    }
                    if (node != null) {
                        node.setNext(first);
                    } else {
                        node = new HashEntry<K, V>(hash, key, value, first);
                    }
                    int c = this.count + 1;
                    if (c > this.threshold && tab.length < 0x40000000) {
                        this.rehash(node);
                    } else {
                        ConcurrentHashMap.setEntryAt(tab, index, node);
                    }
                    ++this.modCount;
                    this.count = c;
                    oldValue = null;
                }
                finally {
                    this.unlock();
                }
            }
            return oldValue;
        }

        private void rehash(HashEntry<K, V> node) {
            HashEntry<K, V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            int newCapacity = oldCapacity << 1;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            HashEntry[] newTable = new HashEntry[newCapacity];
            int sizeMask = newCapacity - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                HashEntry<K, V> e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry<K, V> lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    int k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry<K, V> p = e;
                while (p != lastRun) {
                    Object v = p.value;
                    int h = p.hash;
                    int k = h & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(h, p.key, v, n);
                    p = p.next;
                }
            }
            int nodeIndex = node.hash & sizeMask;
            node.setNext(newTable[nodeIndex]);
            newTable[nodeIndex] = node;
            this.table = newTable;
        }

        private HashEntry<K, V> scanAndLockForPut(K key, int hash, V value) {
            HashEntry first;
            HashEntry e = first = ConcurrentHashMap.entryForHash(this, hash);
            HashEntry<K, V> node = null;
            int retries = -1;
            while (!this.tryLock()) {
                HashEntry f;
                if (retries < 0) {
                    if (e == null) {
                        if (node == null) {
                            node = new HashEntry<K, V>(hash, key, value, null);
                        }
                        retries = 0;
                        continue;
                    }
                    if (key.equals(e.key)) {
                        retries = 0;
                        continue;
                    }
                    e = e.next;
                    continue;
                }
                if (++retries > MAX_SCAN_RETRIES) {
                    this.lock();
                    break;
                }
                if ((retries & 1) != 0 || (f = ConcurrentHashMap.entryForHash(this, hash)) == first) continue;
                e = first = f;
                retries = -1;
            }
            return node;
        }

        private void scanAndLock(Object key, int hash) {
            HashEntry first;
            HashEntry e = first = ConcurrentHashMap.entryForHash(this, hash);
            int retries = -1;
            while (!this.tryLock()) {
                HashEntry f;
                if (retries < 0) {
                    if (e == null || key.equals(e.key)) {
                        retries = 0;
                        continue;
                    }
                    e = e.next;
                    continue;
                }
                if (++retries > MAX_SCAN_RETRIES) {
                    this.lock();
                    break;
                }
                if ((retries & 1) != 0 || (f = ConcurrentHashMap.entryForHash(this, hash)) == first) continue;
                e = first = f;
                retries = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V remove(Object key, int hash, Object value) {
            if (!this.tryLock()) {
                this.scanAndLock(key, hash);
            }
            V oldValue = null;
            try {
                HashEntry<K, V>[] tab = this.table;
                int index = tab.length - 1 & hash;
                HashEntry e = ConcurrentHashMap.entryAt(tab, index);
                HashEntry pred = null;
                while (e != null) {
                    HashEntry next = e.next;
                    Object k = e.key;
                    if (k == key || e.hash == hash && key.equals(k)) {
                        Object v = e.value;
                        if (value == null || value == v || value.equals(v)) {
                            if (pred == null) {
                                ConcurrentHashMap.setEntryAt(tab, index, next);
                            } else {
                                pred.setNext(next);
                            }
                            ++this.modCount;
                            --this.count;
                            oldValue = v;
                        }
                        break;
                    }
                    pred = e;
                    e = next;
                }
            }
            finally {
                this.unlock();
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean replace(K key, int hash, V oldValue, V newValue) {
            if (!this.tryLock()) {
                this.scanAndLock(key, hash);
            }
            boolean replaced = false;
            try {
                HashEntry e = ConcurrentHashMap.entryForHash(this, hash);
                while (e != null) {
                    Object k = e.key;
                    if (k == key || e.hash == hash && key.equals(k)) {
                        if (oldValue.equals(e.value)) {
                            e.value = newValue;
                            ++this.modCount;
                            replaced = true;
                        }
                        break;
                    }
                    e = e.next;
                }
            }
            finally {
                this.unlock();
            }
            return replaced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V replace(K key, int hash, V value) {
            if (!this.tryLock()) {
                this.scanAndLock(key, hash);
            }
            V oldValue = null;
            try {
                HashEntry e = ConcurrentHashMap.entryForHash(this, hash);
                while (e != null) {
                    Object k = e.key;
                    if (k == key || e.hash == hash && key.equals(k)) {
                        oldValue = e.value;
                        e.value = value;
                        ++this.modCount;
                        break;
                    }
                    e = e.next;
                }
            }
            finally {
                this.unlock();
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clear() {
            this.lock();
            try {
                HashEntry<K, V>[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    ConcurrentHashMap.setEntryAt(tab, i, null);
                }
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }

    static final class HashEntry<K, V> {
        final int hash;
        final K key;
        volatile V value;
        volatile HashEntry<K, V> next;
        static final Unsafe UNSAFE;
        static final long nextOffset;

        HashEntry(int hash, K key, V value, HashEntry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        final void setNext(HashEntry<K, V> n) {
            UNSAFE.putOrderedObject(this, nextOffset, n);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<HashEntry> k = HashEntry.class;
                nextOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("next"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static class Holder {
        static final boolean ALTERNATIVE_HASHING;

        private Holder() {
        }

        static {
            int threshold;
            String altThreshold = AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n = threshold = null != altThreshold ? Integer.parseInt(altThreshold) : Integer.MAX_VALUE;
                if (threshold == -1) {
                    threshold = Integer.MAX_VALUE;
                }
                if (threshold < 0) {
                    throw new IllegalArgumentException("value must be positive integer.");
                }
            }
            catch (IllegalArgumentException failed) {
                throw new Error("Illegal value for 'jdk.map.althashing.threshold'", failed);
            }
            ALTERNATIVE_HASHING = threshold <= 0x40000000;
        }
    }
}

