/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

public class DirtyRegion
implements Cloneable {
    int x;
    int y;
    int x2;
    int y2;

    public DirtyRegion() {
        this.clear();
    }

    public void clear() {
        this.x = Integer.MAX_VALUE;
        this.y = Integer.MAX_VALUE;
        this.x2 = Integer.MIN_VALUE;
        this.y2 = Integer.MIN_VALUE;
    }

    public void growDirtyRegion(int x, int y, int x2, int y2) {
        this.x = Math.min(x, this.x);
        this.y = Math.min(y, this.y);
        this.x2 = Math.max(x2, this.x2);
        this.y2 = Math.max(y2, this.y2);
    }

    public int getWidth() {
        return this.x2 - this.x;
    }

    public int getHeight() {
        return this.y2 - this.y;
    }

    public void growDirtyRegionTileLimit(int x, int y, int x2, int y2) {
        if (x < this.x) {
            this.x = Math.max(x, 0);
        }
        if (y < this.y) {
            this.y = Math.max(y, 0);
        }
        if (x2 > this.x2) {
            this.x2 = Math.min(x2, 256);
        }
        if (y2 > this.y2) {
            this.y2 = Math.min(y2, 256);
        }
    }

    public static DirtyRegion combineRegion(DirtyRegion region1, DirtyRegion region2) {
        DirtyRegion region = new DirtyRegion();
        region.x = Math.min(region1.x, region2.x);
        region.y = Math.min(region1.y, region2.y);
        region.x2 = Math.max(region1.x2, region2.x2);
        region.y2 = Math.max(region1.y2, region2.y2);
        return region;
    }

    public void setDirtyLineRegion(int x1, int y1, int x2, int y2) {
        if (x1 < x2) {
            this.x = x1;
            this.x2 = x2;
        } else {
            this.x = x2;
            this.x2 = x1;
        }
        if (y1 < y2) {
            this.y = y1;
            this.y2 = y2;
        } else {
            this.y = y2;
            this.y2 = y1;
        }
    }

    public void translate(int x, int y) {
        if (this.x != Integer.MAX_VALUE) {
            this.x += x;
            this.x2 += x;
            this.y += y;
            this.y2 += y;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(x: " + this.x + ", y:" + this.y + ", x2:" + this.x2 + ", y2:" + this.y2 + ")";
    }

    public DirtyRegion cloneRegion() {
        try {
            return (DirtyRegion)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

