/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CrawlerSessionManagerValve
extends ValveBase
implements HttpSessionBindingListener {
    private static final Log log = LogFactory.getLog(CrawlerSessionManagerValve.class);
    private final Map<String, String> clientIpSessionId = new ConcurrentHashMap<String, String>();
    private final Map<String, String> sessionIdClientIp = new ConcurrentHashMap<String, String>();
    private String crawlerUserAgents = ".*[bB]ot.*|.*Yahoo! Slurp.*|.*Feedfetcher-Google.*";
    private Pattern uaPattern = null;
    private String crawlerIps = null;
    private Pattern ipPattern = null;
    private int sessionInactiveInterval = 60;

    public CrawlerSessionManagerValve() {
        super(true);
    }

    public void setCrawlerUserAgents(String crawlerUserAgents) {
        this.crawlerUserAgents = crawlerUserAgents;
        this.uaPattern = crawlerUserAgents == null || crawlerUserAgents.length() == 0 ? null : Pattern.compile(crawlerUserAgents);
    }

    public String getCrawlerUserAgents() {
        return this.crawlerUserAgents;
    }

    public void setCrawlerIps(String crawlerIps) {
        this.crawlerIps = crawlerIps;
        this.ipPattern = crawlerIps == null || crawlerIps.length() == 0 ? null : Pattern.compile(crawlerIps);
    }

    public String getCrawlerIps() {
        return this.crawlerIps;
    }

    public void setSessionInactiveInterval(int sessionInactiveInterval) {
        this.sessionInactiveInterval = sessionInactiveInterval;
    }

    public int getSessionInactiveInterval() {
        return this.sessionInactiveInterval;
    }

    public Map<String, String> getClientIpSessionId() {
        return this.clientIpSessionId;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.uaPattern = Pattern.compile(this.crawlerUserAgents);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean isBot = false;
        String sessionId = null;
        String clientIp = request.getRemoteAddr();
        if (log.isDebugEnabled()) {
            log.debug((Object)(request.hashCode() + ": ClientIp=" + clientIp + ", RequestedSessionId=" + request.getRequestedSessionId()));
        }
        if (request.getSession(false) == null) {
            Enumeration<String> uaHeaders = request.getHeaders("user-agent");
            String uaHeader = null;
            if (uaHeaders.hasMoreElements()) {
                uaHeader = uaHeaders.nextElement();
            }
            if (uaHeader != null && !uaHeaders.hasMoreElements()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": UserAgent=" + uaHeader));
                }
                if (this.uaPattern.matcher(uaHeader).matches()) {
                    isBot = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(request.hashCode() + ": Bot found. UserAgent=" + uaHeader));
                    }
                }
            }
            if (this.ipPattern != null && this.ipPattern.matcher(clientIp).matches()) {
                isBot = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": Bot found. IP=" + clientIp));
                }
            }
            if (isBot && (sessionId = this.clientIpSessionId.get(clientIp)) != null) {
                request.setRequestedSessionId(sessionId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": SessionID=" + sessionId));
                }
            }
        }
        this.getNext().invoke(request, response);
        if (isBot) {
            if (sessionId == null) {
                HttpSession s = request.getSession(false);
                if (s != null) {
                    this.clientIpSessionId.put(clientIp, s.getId());
                    this.sessionIdClientIp.put(s.getId(), clientIp);
                    s.setAttribute(this.getClass().getName(), (Object)this);
                    s.setMaxInactiveInterval(this.sessionInactiveInterval);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(request.hashCode() + ": New bot session. SessionID=" + s.getId()));
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(request.hashCode() + ": Bot session accessed. SessionID=" + sessionId));
            }
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        String clientIp = this.sessionIdClientIp.remove(event.getSession().getId());
        if (clientIp != null) {
            this.clientIpSessionId.remove(clientIp);
        }
    }
}

