/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.platform.apple.ProtegeAppleApplication;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.menu.MenuBuilder;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.workspace.Workspace;

public class WorkspaceFrame
extends JFrame {
    private static final long serialVersionUID = -8568184212386766789L;
    public static final int DEFAULT_WIDTH = 1024;
    public static final int DEFAULT_HEIGHT = 768;
    private Workspace workspace;
    public static final String LOC_X = "LOC_X";
    public static final String LOC_Y = "LOC_Y";
    public static final String SIZE_X = "SIZE_X";
    public static final String SIZE_Y = "SIZE_Y";
    private Set<ProtegeAction> menuActions;

    public WorkspaceFrame(Workspace workspace) {
        this.workspace = workspace;
        this.menuActions = new HashSet<ProtegeAction>();
        this.createUI();
        this.restoreMetrics();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (OSUtils.isOSX()) {
                    ProtegeAppleApplication.getInstance().setEditorKit(null);
                }
                WorkspaceFrame.this.saveMetrics();
                WorkspaceFrame.this.removeWindowListener(this);
            }

            @Override
            public void windowActivated(WindowEvent event) {
                if (OSUtils.isOSX()) {
                    ProtegeAppleApplication.getInstance().setEditorKit(WorkspaceFrame.this.workspace.getEditorKit());
                }
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        for (ProtegeAction action : this.menuActions) {
            try {
                action.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void restoreMetrics() {
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(this.getClass().getName());
        int w = p.getInt(SIZE_X, 1024);
        int h = p.getInt(SIZE_Y, 768);
        this.setSize(w, h);
        Point defLoc = this.getDefaultLocation();
        int x = p.getInt(LOC_X, defLoc.x);
        int y = p.getInt(LOC_Y, defLoc.y);
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    private Point getDefaultLocation() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.getSize();
        return new Point((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
    }

    protected void saveMetrics() {
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(this.getClass().getName());
        p.putInt(LOC_X, this.getLocation().x);
        p.putInt(LOC_Y, this.getLocation().y);
        p.putInt(SIZE_X, this.getSize().width);
        p.putInt(SIZE_Y, this.getSize().height);
    }

    public JMenu getMenu(String name) {
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            JMenu menu = this.getJMenuBar().getMenu(i);
            if (menu.getText() == null || !menu.getText().equals(name)) continue;
            return menu;
        }
        JMenu menu = new JMenu(name);
        this.getJMenuBar().add(menu);
        return menu;
    }

    private void createUI() {
        JPanel contentPane = new JPanel(new BorderLayout(0, 0));
        this.setContentPane(contentPane);
        this.createMenuBar();
        contentPane.add(this.workspace);
        this.workspace.initialiseExtraMenuItems(this.getJMenuBar());
        String title = this.workspace.getTitle();
        if (title != null) {
            this.setTitle(title);
        }
        this.setIconImage(((ImageIcon)Icons.getIcon("logo32.gif")).getImage());
        Optional<JComponent> statusArea = this.workspace.getStatusArea();
        statusArea.ifPresent(sa -> contentPane.add((Component)sa, "South"));
    }

    public void updateTitle() {
        String title = this.workspace.getTitle();
        if (title != null) {
            this.setTitle(title);
        }
    }

    private void createMenuBar() {
        MenuBuilder menuBuilder = new MenuBuilder(this.workspace.getEditorKit());
        this.setJMenuBar(menuBuilder.buildMenu());
        this.menuActions.addAll(menuBuilder.getActions());
    }
}

