/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class UnparsableOntologyException
extends OWLOntologyCreationException {
    private static final long serialVersionUID = 40000L;
    private boolean includeStackTraceInMessage = true;
    private final IRI documentIRI;
    private final Map<OWLParser, OWLParserException> exceptions;

    public UnparsableOntologyException(@Nonnull IRI documentIRI, Map<OWLParser, OWLParserException> exceptions, OWLOntologyLoaderConfiguration config) {
        super("Could not parse ontology from document IRI: " + documentIRI.toQuotedString());
        this.includeStackTraceInMessage = config.isReportStackTrace();
        this.documentIRI = documentIRI;
        this.exceptions = exceptions;
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Problem parsing ");
        msg.append(this.documentIRI);
        msg.append("\nCould not parse ontology.  Either a suitable parser could not be found, or parsing failed.  See parser logs below for explanation.\nThe following parsers were tried:\n");
        int counter = 1;
        for (OWLParser oWLParser : this.exceptions.keySet()) {
            msg.append(counter);
            msg.append(") ");
            msg.append(oWLParser.toString());
            msg.append('\n');
            ++counter;
        }
        msg.append("\n\nDetailed logs:\n");
        for (Map.Entry entry : this.exceptions.entrySet()) {
            Throwable exception = (Throwable)entry.getValue();
            msg.append("--------------------------------------------------------------------------------\n");
            msg.append("Parser: ");
            msg.append(((OWLParser)entry.getKey()).toString());
            msg.append('\n');
            if (!this.includeStackTraceInMessage) {
                msg.append(exception.getMessage());
                msg.append("\n\n");
                continue;
            }
            msg.append("    Stack trace:\n");
            Throwable current = exception;
            boolean moreStackTraces = true;
            for (int i = 0; i < 5 && moreStackTraces; ++i) {
                msg.append(current.getMessage());
                StackTraceElement[] stackTrace = current.getStackTrace();
                for (int stackDepth = 0; stackDepth < 10 && stackDepth < stackTrace.length; ++stackDepth) {
                    StackTraceElement element = stackTrace[stackDepth];
                    msg.append("        ");
                    msg.append(element);
                    msg.append('\n');
                }
                if (current.getCause() != null && current.getCause() != current) {
                    current = current.getCause();
                    continue;
                }
                moreStackTraces = false;
            }
            msg.append("\n\n");
        }
        return msg.toString();
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public Map<OWLParser, OWLParserException> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }
}

