/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HeapDump {
    private static MBeanServer mserver;
    private static ObjectName hotspotDiag;
    private static boolean initialized;
    private static boolean runningOnJdk15;

    private HeapDump() {
    }

    public static void initialize(boolean bl) {
        runningOnJdk15 = bl;
        if (runningOnJdk15) {
            HeapDump.initialize15();
        } else {
            HeapDump.initialize16();
        }
    }

    public static String takeHeapDump(String string) {
        if (runningOnJdk15) {
            return HeapDump.takeHeapDump15(string);
        }
        return HeapDump.takeHeapDump16(string);
    }

    private static native void initialize15();

    private static void initialize16() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            mserver = ManagementFactory.getPlatformMBeanServer();
        }
        catch (JMRuntimeException jMRuntimeException) {
            System.err.println(jMRuntimeException.getLocalizedMessage());
            initialized = false;
            return;
        }
        try {
            hotspotDiag = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            mserver.getObjectInstance(hotspotDiag);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.err.println("Heap Dump is not available");
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private static String takeHeapDump15(String string) {
        int n = -1;
        try {
            n = HeapDump.takeHeapDump15Native(string);
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
        if (n == -1) {
            return "Take heap dump is not available.";
        }
        return null;
    }

    private static native int takeHeapDump15Native(String var0);

    private static String takeHeapDump16(String string) {
        String string2 = null;
        HeapDump.initialize16();
        if (mserver == null || hotspotDiag == null) {
            return "Take heap dump is not available.";
        }
        try {
            mserver.invoke(hotspotDiag, "dumpHeap", new Object[]{string, true}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = illegalArgumentException.getLocalizedMessage();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            string2 = instanceNotFoundException.getLocalizedMessage();
        }
        catch (MBeanException mBeanException) {
            string2 = mBeanException.getLocalizedMessage();
        }
        catch (ReflectionException reflectionException) {
            string2 = reflectionException.getLocalizedMessage();
        }
        return string2;
    }
}

