/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;

public class XbmImageDecoder
extends ImageDecoder {
    private static byte[] XbmColormap = new byte[]{-1, -1, -1, 0, 0, 0};
    private static int XbmHints = 30;

    public XbmImageDecoder(InputStreamImageSource src, InputStream is) {
        super(src, is);
        if (!(this.input instanceof BufferedInputStream)) {
            this.input = new BufferedInputStream(this.input, 80);
        }
    }

    private static void error(String s1) throws ImageFormatException {
        throw new ImageFormatException(s1);
    }

    @Override
    public void produceImage() throws IOException, ImageFormatException {
        int c;
        char[] nm = new char[80];
        int i = 0;
        int state = 0;
        int H = 0;
        int W = 0;
        int x = 0;
        int y = 0;
        boolean start = true;
        byte[] raster = null;
        IndexColorModel model = null;
        while (!this.aborted && (c = this.input.read()) != -1) {
            int p;
            int n;
            if (97 <= c && c <= 122 || 65 <= c && c <= 90 || 48 <= c && c <= 57 || c == 35 || c == 95) {
                if (i >= 78) continue;
                nm[i++] = (char)c;
                continue;
            }
            if (i <= 0) continue;
            int nc = i;
            i = 0;
            if (start) {
                if (nc != 7 || nm[0] != '#' || nm[1] != 'd' || nm[2] != 'e' || nm[3] != 'f' || nm[4] != 'i' || nm[5] != 'n' || nm[6] != 'e') {
                    XbmImageDecoder.error("Not an XBM file");
                }
                start = false;
            }
            if (nm[nc - 1] == 'h') {
                state = 1;
                continue;
            }
            if (nm[nc - 1] == 't' && nc > 1 && nm[nc - 2] == 'h') {
                state = 2;
                continue;
            }
            if (nc > 2 && state < 0 && nm[0] == '0' && nm[1] == 'x') {
                n = 0;
                for (p = 2; p < nc; ++p) {
                    c = nm[p];
                    c = 48 <= c && c <= 57 ? (c -= 48) : (65 <= c && c <= 90 ? c - 65 + 10 : (97 <= c && c <= 122 ? c - 97 + 10 : 0));
                    n = n * 16 + c;
                }
                for (int mask = 1; mask <= 128; mask <<= 1) {
                    if (x < W) {
                        raster[x] = (n & mask) != 0;
                    }
                    ++x;
                }
                if (x < W) continue;
                if (this.setPixels(0, y, W, 1, (ColorModel)model, raster, 0, W) <= 0) {
                    return;
                }
                x = 0;
                if (y++ < H) continue;
                break;
            }
            n = 0;
            for (p = 0; p < nc; ++p) {
                c = nm[p];
                if (48 > c || c > 57) {
                    n = -1;
                    break;
                }
                n = n * 10 + c - 48;
            }
            if (n <= 0 || state <= 0) continue;
            if (state == 1) {
                W = n;
            } else {
                H = n;
            }
            if (W == 0 || H == 0) {
                state = 0;
                continue;
            }
            model = new IndexColorModel(8, 2, XbmColormap, 0, false, 0);
            this.setDimensions(W, H);
            this.setColorModel(model);
            this.setHints(XbmHints);
            this.headerComplete();
            raster = new byte[W];
            state = -1;
        }
        this.input.close();
        this.imageComplete(3, true);
    }
}

