/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;

public class Bib2GlsSymbol
extends Bib2GlsEntry {
    public Bib2GlsSymbol(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public void checkRequiredFields(TeXParser teXParser) {
        BibValueList bibValueList = this.getField("name");
        BibValueList bibValueList2 = this.getField("parent");
        BibValueList bibValueList3 = this.getField("description");
        if (bibValueList != null || bibValueList2 != null && bibValueList3 != null) {
            return;
        }
        if (bibValueList == null && bibValueList2 == null) {
            this.missingFieldWarning(teXParser, "name");
        }
        if (bibValueList2 != null && bibValueList3 == null && bibValueList == null) {
            this.missingFieldWarning(teXParser, "description");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            return this.getOriginalId();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            return this.getIdField();
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        printWriter.print(" \\longnewglossaryentry*{#1}");
        printWriter.format("{name={#3},sort={#1},category={%s},#2}{#4}", this.getEntryType());
        printWriter.println("}");
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        Set<String> set = this.getFieldSet();
        for (String string4 : set) {
            if (string4.equals("name")) {
                string2 = this.getFieldValue(string4);
                continue;
            }
            if (string4.equals("description")) {
                string3 = this.getFieldValue(string4);
                continue;
            }
            printWriter.format("%s", string);
            string = String.format(",%n", new Object[0]);
            printWriter.format("%s={%s}", string4, this.getFieldValue(string4));
        }
        printWriter.println(String.format("}%%%n{%s}%%%n{%s}", string2, string3));
    }
}

