/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class If
extends Primitive
implements Expandable {
    public static final Else ELSE = new Else();
    public static final Fi FI = new Fi();

    public If() {
        this("if");
    }

    public If(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new If(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        if (this.istrue(teXParser, teXObjectList)) {
            this.doTruePart(teXParser, teXObjectList, teXObjectList2);
        } else {
            this.doFalsePart(teXParser, teXObjectList, teXObjectList2);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        if (this.istrue(teXParser, teXParser)) {
            this.doTruePart(teXParser, teXParser, teXObjectList);
        } else {
            this.doFalsePart(teXParser, teXParser, teXObjectList);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.istrue(teXParser, teXObjectList)) {
            this.doTruePart(teXParser, teXObjectList);
        } else {
            this.doFalsePart(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.istrue(teXParser, teXParser)) {
            this.doTruePart(teXParser, teXParser);
        } else {
            this.doFalsePart(teXParser, teXParser);
        }
    }

    protected boolean istrue(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2;
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject2 = teXParser.popToken();
        } else {
            teXObject2 = teXObjectList.popToken();
            if (teXObject2 == null) {
                teXObject2 = teXParser.popToken();
            }
        }
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject = teXParser.popToken();
        } else {
            teXObject = teXObjectList.popToken();
            if (teXObject == null) {
                teXObject = teXParser.popToken();
            }
        }
        if (teXObject2 instanceof TeXCsRef) {
            teXObject2 = teXParser.getControlSequence(((TeXCsRef)teXObject2).getName());
        }
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject2 == teXObject) {
            return true;
        }
        if (teXObject2 == null || teXObject == null) {
            return false;
        }
        if (teXObject2 instanceof AssignedMacro) {
            teXObject2 = ((AssignedMacro)teXObject2).getUnderlying();
        }
        if (teXObject instanceof AssignedMacro) {
            teXObject = ((AssignedMacro)teXObject).getUnderlying();
        }
        return teXObject2.equals(teXObject);
    }

    protected void doTruePart(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doTruePart(teXParser, teXObjectList, null);
    }

    protected void doTruePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObjectList teXObjectList3;
        TeXObject teXObject;
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject = teXParser.popStack();
        } else {
            teXObject = teXObjectList.popStack(teXParser);
            if (teXObject == null) {
                teXObject = teXParser.popStack();
            }
        }
        if (teXObject instanceof Expandable && (teXObjectList3 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList3;
        }
        if (teXObject instanceof Fi) {
            return;
        }
        if (teXObject instanceof Else) {
            this.skipToFi(teXParser, teXObjectList);
        } else if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
            teXObjectList3 = (TeXObjectList)teXObject;
            int n = teXObjectList3.size();
            for (int i = 0; i < n; ++i) {
                teXObject = (TeXObject)teXObjectList3.get(i);
                if (teXObject instanceof Fi) {
                    if (i != n - 1) {
                        if (teXObjectList == teXParser || teXObjectList == null) {
                            teXParser.addAll(0, teXObjectList3.subList(i + 1, n - 1));
                        } else {
                            teXObjectList.addAll(0, teXObjectList3.subList(i + 1, n - 1));
                        }
                    }
                    return;
                }
                if (teXObject instanceof Else) {
                    if (i != n - 1) {
                        if (teXObjectList == teXParser || teXObjectList == null) {
                            teXParser.addAll(0, teXObjectList3.subList(i + 1, n - 1));
                        } else {
                            teXObjectList.addAll(0, teXObjectList3.subList(i + 1, n - 1));
                        }
                    }
                    this.skipToFi(teXParser, teXObjectList);
                    return;
                }
                if (teXObjectList2 == null) {
                    if (teXObjectList == teXParser || teXObjectList == null) {
                        teXObject.process(teXParser);
                        continue;
                    }
                    teXObject.process(teXParser, teXObjectList);
                    continue;
                }
                teXObjectList2.add(teXObject);
            }
        } else {
            if (teXObjectList2 == null) {
                if (teXParser == teXObjectList || teXObjectList == null) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doTruePart(teXParser, teXObjectList, teXObjectList2);
        }
    }

    protected void skipToFi(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject;
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject = teXParser.popStack();
        } else {
            teXObject = teXObjectList.popStack(teXParser);
            if (teXObject == null) {
                teXObject = teXParser.popStack();
            }
        }
        if (teXObject instanceof Expandable && (teXObjectList2 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList2;
        }
        if (teXObject instanceof Fi) {
            return;
        }
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
            teXObjectList2 = (TeXObjectList)teXObject;
            int n = teXObjectList2.size();
            for (int i = 0; i < n; ++i) {
                teXObject = (TeXObject)teXObjectList2.get(i);
                if (!(teXObject instanceof Fi)) continue;
                if (i != n - 1) {
                    if (teXObjectList == teXParser || teXObjectList == null) {
                        teXParser.addAll(0, teXObjectList2.subList(i + 1, n - 1));
                    } else {
                        teXObjectList.addAll(0, teXObjectList2.subList(i + 1, n - 1));
                    }
                }
                return;
            }
        } else {
            this.skipToFi(teXParser, teXObjectList);
        }
    }

    protected boolean skipToElse(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject;
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject = teXParser.popStack();
        } else {
            teXObject = teXObjectList.popStack(teXParser);
            if (teXObject == null) {
                teXObject = teXParser.popStack();
            }
        }
        if (teXObject instanceof Expandable && (teXObjectList2 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            if (teXObject instanceof Group || teXObjectList2.isEmpty()) {
                teXObject = teXObjectList2;
            } else {
                teXObject = (TeXObject)teXObjectList2.remove(0);
                if (!teXObjectList2.isEmpty()) {
                    if (teXObjectList == null) {
                        teXParser.addAll(0, teXObjectList2);
                    } else {
                        teXObjectList.addAll(0, teXObjectList2);
                    }
                }
            }
        }
        if (teXObject.equals(ELSE)) {
            return true;
        }
        if (teXObject.equals(FI)) {
            return false;
        }
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
            teXObjectList2 = (TeXObjectList)teXObject;
            int n = teXObjectList2.size();
            for (int i = 0; i < n; ++i) {
                teXObject = (TeXObject)teXObjectList2.get(i);
                boolean bl = teXObject.equals(ELSE);
                if (!bl && !teXObject.equals(FI)) continue;
                if (i != n - 1) {
                    if (teXObjectList == teXParser || teXObjectList == null) {
                        teXParser.addAll(0, teXObjectList2.subList(i + 1, n - 1));
                    } else {
                        teXObjectList.addAll(0, teXObjectList2.subList(i + 1, n - 1));
                    }
                }
                return bl;
            }
        }
        return this.skipToElse(teXParser, teXObjectList);
    }

    protected void doFalsePart(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doFalsePart(teXParser, teXObjectList, null);
    }

    protected void doFalsePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        if (!this.skipToElse(teXParser, teXObjectList)) {
            return;
        }
        this.doRemainingFalsePart(teXParser, teXObjectList, teXObjectList2);
    }

    protected void doRemainingFalsePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObjectList teXObjectList3;
        TeXObject teXObject;
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject = teXParser.popStack();
        } else {
            teXObject = teXObjectList.popStack(teXParser);
            if (teXObject == null) {
                teXObject = teXParser.popStack();
            }
        }
        if (teXObject instanceof Expandable && (teXObjectList3 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            if (teXObject instanceof Group || teXObjectList3.isEmpty()) {
                teXObject = teXObjectList3;
            } else {
                teXObject = (TeXObject)teXObjectList3.remove(0);
                if (!teXObjectList3.isEmpty()) {
                    if (teXObjectList == null) {
                        teXParser.addAll(0, teXObjectList3);
                    } else {
                        teXObjectList.addAll(0, teXObjectList3);
                    }
                }
            }
        }
        if (teXObject.equals(FI)) {
            return;
        }
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
            teXObjectList3 = (TeXObjectList)teXObject;
            int n = teXObjectList3.size();
            for (int i = 0; i < n; ++i) {
                teXObject = (TeXObject)teXObjectList3.get(i);
                if (teXObject.equals(FI)) {
                    if (i != n - 1) {
                        if (teXObjectList == teXParser || teXObjectList == null) {
                            teXParser.addAll(0, teXObjectList3.subList(i + 1, n - 1));
                        } else {
                            teXObjectList.addAll(0, teXObjectList3.subList(i + 1, n - 1));
                        }
                    }
                    return;
                }
                if (teXObjectList2 == null) {
                    if (teXObjectList == teXParser || teXObjectList == null) {
                        teXObject.process(teXParser);
                        continue;
                    }
                    teXObject.process(teXParser, teXObjectList);
                    continue;
                }
                teXObjectList2.add(teXObject);
            }
        } else {
            if (teXObjectList2 == null) {
                if (teXParser == teXObjectList || teXObjectList == null) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doRemainingFalsePart(teXParser, teXObjectList, teXObjectList2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof TeXObject)) {
            return false;
        }
        if (object instanceof AssignedMacro) {
            return ((AssignedMacro)object).getUnderlying().equals(this);
        }
        return object.getClass().getName().equals(this.getClass().getName());
    }
}

